/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.bumblebee.claysoldiers.blueprint.BlueprintData;
import net.bumblebee.claysoldiers.blueprint.BlueprintManager;
import net.bumblebee.claysoldiers.claypoifunction.ClayPoiFunctions;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClayPredicates;
import net.bumblebee.claysoldiers.entity.ClayWraithEntity;
import net.bumblebee.claysoldiers.entity.boss.BossBatEntity;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.horse.ClayHorseEntity;
import net.bumblebee.claysoldiers.entity.horse.ClayPegasusEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModArmorMaterials;
import net.bumblebee.claysoldiers.init.ModBlockEntities;
import net.bumblebee.claysoldiers.init.ModBlocks;
import net.bumblebee.claysoldiers.init.ModBossBehaviours;
import net.bumblebee.claysoldiers.init.ModCreativeTab;
import net.bumblebee.claysoldiers.init.ModCriterions;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModEffects;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.init.ModItemGenerators;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModMenuTypes;
import net.bumblebee.claysoldiers.init.ModParticles;
import net.bumblebee.claysoldiers.init.ModPoiTypes;
import net.bumblebee.claysoldiers.init.ModRecipes;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.networking.BlueprintClientPayload;
import net.bumblebee.claysoldiers.networking.BlueprintPlacePayload;
import net.bumblebee.claysoldiers.networking.CapabilityStatusPayload;
import net.bumblebee.claysoldiers.networking.ClayMobItemBreakParticles;
import net.bumblebee.claysoldiers.networking.ClaySoldierReviveCooldownPayload;
import net.bumblebee.claysoldiers.networking.ClayTeamPlayerDataPayload;
import net.bumblebee.claysoldiers.networking.HamsterWheelEnergyPayload;
import net.bumblebee.claysoldiers.networking.SoldierCarriedChangePayload;
import net.bumblebee.claysoldiers.networking.SoldierItemChangePayload;
import net.bumblebee.claysoldiers.networking.spawnpayloads.ClayBossSpawnPayload;
import net.bumblebee.claysoldiers.networking.spawnpayloads.ClayMobSpawnPayload;
import net.bumblebee.claysoldiers.networking.spawnpayloads.ClaySoldierSpawnPayload;
import net.bumblebee.claysoldiers.platform.services.AbstractCapabilityManger;
import net.bumblebee.claysoldiers.platform.services.ICommonHooks;
import net.bumblebee.claysoldiers.platform.services.IDataMapGetter;
import net.bumblebee.claysoldiers.platform.services.INetworkManger;
import net.bumblebee.claysoldiers.platform.services.IPlatformHelper;
import net.bumblebee.claysoldiers.soldieritemtypes.SoldierItemType;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttacks;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.team.TeamLoyaltyManger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaySoldiersCommon {
    public static final String MOD_ID = "csr";
    public static final String MOD_NAME = "Clay Soldiers Remake";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Clay Soldiers Remake");
    public static final String CLAY_SOLDIER_PROPERTY = "clay_soldier_property";
    public static final String CLAY_SOLDIER_PROPERTY_LANG = "clay_soldier_property.csr.";
    public static final IPlatformHelper PLATFORM = ClaySoldiersCommon.load(IPlatformHelper.class);
    public static final IDataMapGetter DATA_MAP = ClaySoldiersCommon.load(IDataMapGetter.class);
    public static final INetworkManger NETWORK_MANGER = ClaySoldiersCommon.load(INetworkManger.class);
    public static final ICommonHooks COMMON_HOOKS = ClaySoldiersCommon.load(ICommonHooks.class);
    public static final AbstractCapabilityManger CAPABILITY_MANGER = ClaySoldiersCommon.load(AbstractCapabilityManger.class);
    public static final GameRules.Key<GameRules.IntegerValue> CLAY_SOLDIER_DROP_RULE = PLATFORM.createIntRule("soldierDropThemSelf", GameRules.Category.DROPS, 50);
    public static final GameRules.Key<GameRules.BooleanValue> CLAY_SOLDIER_INVENTORY_DROP_RULE = PLATFORM.createBoolRule("soldierDropInventory", GameRules.Category.DROPS, true);
    public static final String CSR_DATA_PACK_LOCATION = "data/datapacks";
    public static final String CSR_DEFAULT_DATA_PACK_PATH = "csr_default_datapack";
    public static final String CSR_DEFAULT_DATA_PACK_LANG = "resourcePack.%s.csr_default.name".formatted("csr");
    public static final String CSR_DEFAULT_PACK_DESCRIPTION = "datapack.%s.%s.description".formatted("csr", "csr_default_datapack");
    public static final String BLUEPRINT_PACK_PATH = "blueprint_pack";
    public static final String BLUEPRINT_DATA_PACK_LANG = "resourcePack.%s.blueprint.name".formatted("csr");
    public static final String BLUEPRINT_PACK_DESCRIPTION = "datapack.%s.%s.description".formatted("csr", "blueprint_pack");
    public static final String BLUEPRINT_PACK_SOURCE = "pack.source.%s.%s".formatted("csr", "blueprint_pack");
    public static Predicate<Player> IS_WEARING_GOGGLES = p -> p.getItemBySlot(EquipmentSlot.HEAD).is((Item)ModItems.CLAY_GOGGLES.get());
    public static final List<Predicate<Player>> IS_WEARING_CLAY_SOLDIER = new ArrayList<Predicate<Player>>();
    @Nullable
    public static @Nullable Supplier<@Nullable Player> clientPlayer;
    public static boolean claySolderMenuModify;

    public static void init() {
        ModRegistries.init();
        ModItems.init();
        ModBlocks.init();
        ModBlockEntities.init();
        ModArmorMaterials.init();
        ModDataComponents.init();
        ModEffects.init();
        ModParticles.init();
        ModRecipes.init();
        ModEntityTypes.init();
        ModMenuTypes.init();
        ModCreativeTab.init();
        SoldierPropertyTypes.init();
        SpecialAttacks.init();
        ClayPoiFunctions.init();
        ClayPredicates.init();
        ModItemGenerators.init();
        ModBossBehaviours.init();
        ModPoiTypes.init();
        ModCriterions.init();
        NETWORK_MANGER.registerS2CPayload(ClayMobItemBreakParticles.ID, ClayMobItemBreakParticles.STREAM_CODEC, ClayMobItemBreakParticles::handleClient);
        NETWORK_MANGER.registerS2CPayload(SoldierItemChangePayload.ID, SoldierItemChangePayload.STREAM_CODEC, SoldierItemChangePayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(ClaySoldierReviveCooldownPayload.ID, ClaySoldierReviveCooldownPayload.STREAM_CODEC, ClaySoldierReviveCooldownPayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(SoldierCarriedChangePayload.ID, SoldierCarriedChangePayload.STREAM_CODEC, SoldierCarriedChangePayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(ClayTeamPlayerDataPayload.Single.ID, ClayTeamPlayerDataPayload.STREAM_CODEC_SINGLE, ClayTeamPlayerDataPayload.Single::handleClient);
        NETWORK_MANGER.registerS2CPayload(ClayTeamPlayerDataPayload.Remove.ID, ClayTeamPlayerDataPayload.STREAM_CODEC_REMOVE, ClayTeamPlayerDataPayload.Remove::handleClient);
        NETWORK_MANGER.registerS2CPayload(ClayTeamPlayerDataPayload.Creation.ID, ClayTeamPlayerDataPayload.STREAM_CODEC_CREATION, ClayTeamPlayerDataPayload.Creation::handleClient);
        NETWORK_MANGER.registerS2CPayload(BlueprintClientPayload.ID, BlueprintClientPayload.STREAM_CODEC, BlueprintClientPayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(CapabilityStatusPayload.ID, CapabilityStatusPayload.STREAM_CODEC, CapabilityStatusPayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(HamsterWheelEnergyPayload.ID, HamsterWheelEnergyPayload.STREAM_CODEC, HamsterWheelEnergyPayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(ClayMobSpawnPayload.ID, ClayMobSpawnPayload.STREAM_CODEC, ClayMobSpawnPayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(ClaySoldierSpawnPayload.ID, ClaySoldierSpawnPayload.STREAM_CODEC, ClaySoldierSpawnPayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(ClayBossSpawnPayload.ID, ClayBossSpawnPayload.STREAM_CODEC, ClayBossSpawnPayload::handleClient);
        NETWORK_MANGER.registerS2CPayload(BlueprintPlacePayload.ID, BlueprintPlacePayload.STREAM_CODEC, BlueprintPlacePayload::handleClient);
    }

    public static void playerJoinsServerEvent(@Nullable ServerPlayer player, Stream<ServerPlayer> relevantPlayers) {
        if (player != null) {
            ClaySoldiersCommon.playerJoinedServer(player, false);
        } else {
            relevantPlayers.forEach(serverPlayer -> ClaySoldiersCommon.playerJoinedServer(serverPlayer, true));
        }
    }

    public static void playerJoinedServer(ServerPlayer player, boolean reload) {
        ClaySoldiersCommon.sendWhenChannel(player, new ClayTeamPlayerDataPayload.Creation(TeamLoyaltyManger.getTeamData(player.serverLevel()), reload), reload);
        if (!reload) {
            ClaySoldiersCommon.sendWhenChannel(player, new BlueprintClientPayload(BlueprintManager.getBlueprintShapeData(player.registryAccess())), false);
        }
        if (NETWORK_MANGER.isMemoryConnection(player)) {
            LOGGER.info("No data PackSync Payloads will be send as the Connection is Memory for {}", (Object)player.getScoreboardName());
            return;
        }
        ClaySoldiersCommon.sendWhenChannel(player, new CapabilityStatusPayload(AbstractCapabilityManger.getEnabledMap()), reload);
    }

    private static void sendWhenChannel(ServerPlayer serverPlayer, CustomPacketPayload payload, boolean reload) {
        if (NETWORK_MANGER.hasChannel(serverPlayer, payload.type())) {
            NETWORK_MANGER.sendToPlayer(serverPlayer, payload);
            LOGGER.info("Sending {} to {} was {}", new Object[]{payload.type().id(), serverPlayer.getScoreboardName(), reload ? "reload" : "join"});
        } else {
            LOGGER.error("Could not send {} Packet to {} because there was no Channel", (Object)payload.type().id(), (Object)serverPlayer.getScoreboardName());
        }
    }

    public static void serverStartedEvent(MinecraftServer server) {
        LOGGER.info("TeamPlayerData on server: {}", (Object)TeamLoyaltyManger.getTeamPlayerData(server.overworld()));
        LOGGER.info("Teams loaded: {}", ClayMobTeamManger.getAllKeys((HolderLookup.Provider)server.registryAccess()).toList());
    }

    public static void entityAttributes(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier> event) {
        event.accept(ModEntityTypes.CLAY_SOLDIER_ENTITY.get(), AbstractClaySoldierEntity.setSoldierAttributes());
        event.accept(ModEntityTypes.CLAY_WRAITH.get(), ClayWraithEntity.setWraithAttributes());
        event.accept(ModEntityTypes.ZOMBIE_CLAY_SOLDIER_ENTITY.get(), AbstractClaySoldierEntity.setSoldierAttributes());
        event.accept(ModEntityTypes.VAMPIRE_CLAY_SOLDIER_ENTITY.get(), AbstractClaySoldierEntity.setSoldierAttributes());
        event.accept(ModEntityTypes.CLAY_HORSE_ENTITY.get(), ClayHorseEntity.createBaseHorseAttributes());
        event.accept(ModEntityTypes.CLAY_PEGASUS_ENTITY.get(), ClayPegasusEntity.createPegasusAttributes());
        event.accept(ModEntityTypes.BOSS_CLAY_SOLDIER_ENTITY.get(), BossClaySoldierEntity.bossAttributes());
        event.accept(ModEntityTypes.VAMPIRE_BAT.get(), BossBatEntity.createBatAttributes());
    }

    public static void registerDynamicRegistry(DynamicRegistryEvent event) {
        event.register(ModRegistries.BLUEPRINTS, BlueprintData.JSON_CODEC, BlueprintData.JSON_CODEC);
        event.register(ModRegistries.SOLDIER_ITEM_TYPES, SoldierItemType.CODEC, null, (id, location, value) -> value.onRegister(location));
        event.register(ModRegistries.CLAY_MOB_TEAMS, ClayMobTeam.CODEC_JSON, ClayMobTeam.CODEC_JSON, (id, key, value) -> ClayMobTeamManger.appendFromItemMap(value.getGetFrom(), key));
    }

    public static void onTagLoad(HolderLookup.Provider registryAccess, boolean client) {
        if (!client) {
            SoldierItemType.onTagLoad(registryAccess);
        }
    }

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    static {
        claySolderMenuModify = false;
    }

    public static interface DynamicRegistryEvent {
        default public <T> void register(ResourceKey<Registry<T>> registry, Codec<T> codec, @Nullable Codec<T> synced) {
            this.register(registry, codec, synced, null);
        }

        public <T> void register(ResourceKey<Registry<T>> var1, Codec<T> var2, @Nullable Codec<T> var3, RegistryRegisteredCallBack<T> var4);
    }

    public static interface RegistryRegisteredCallBack<T> {
        public void onRegister(int var1, ResourceLocation var2, T var3);
    }

    public static class BlueprintTagLoad
    implements BiConsumer<BlueprintManager, ResourceManager> {
        private BlueprintManager manger;
        private ResourceManager resourceManager;

        @Override
        public void accept(BlueprintManager manger, ResourceManager resourceManager) {
            this.manger = manger;
            this.resourceManager = resourceManager;
        }

        public void onTagLoad(HolderLookup.Provider registries) {
            if (this.manger == null) {
                if (PLATFORM.isClient()) {
                    return;
                }
                throw new IllegalStateException("Cannot load Blueprint Tags on the Client");
            }
            this.manger.onTagLoad(this.resourceManager, ((HolderSet.Named)registries.lookupOrThrow(Registries.BLOCK).get(ModTags.Blocks.BLUEPRINT_BLACK_LISTED).orElseThrow()).stream().toList());
            this.manger = null;
            this.resourceManager = null;
        }
    }
}

