/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.bumblebee.claysoldiers.init.ModCriterions;
import net.bumblebee.claysoldiers.item.ClayBrushItem;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;

public class ClayBrushCommandTrigger
extends SimpleCriterionTrigger<Condition> {
    public void trigger(ServerPlayer serverPlayer, ClayBrushItem.Mode command) {
        this.trigger(serverPlayer, c -> c.matches(command));
    }

    public static Criterion<Condition> create(ClayBrushItem.Mode command) {
        return ModCriterions.CLAY_BRUSH_COMMAND_TRIGGER.get().createCriterion((CriterionTriggerInstance)new Condition(Optional.empty(), command));
    }

    public Codec<Condition> codec() {
        return Condition.CODEC;
    }

    public record Condition(Optional<ContextAwarePredicate> player, ClayBrushItem.Mode command) implements SimpleCriterionTrigger.SimpleInstance
    {
        private static final Codec<Condition> CODEC = RecordCodecBuilder.create(in -> in.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Condition::player), (App)ClayBrushItem.Mode.CODEC.fieldOf("command").forGetter(Condition::command)).apply((Applicative)in, Condition::new));

        private boolean matches(ClayBrushItem.Mode mode) {
            return mode == this.command;
        }
    }
}

