/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.bumblebee.claysoldiers.init.ModCriterions;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class ClaySoldierDeathTrigger
extends SimpleCriterionTrigger<Condition> {
    public Codec<Condition> codec() {
        return Condition.CODEC;
    }

    public static Criterion<Condition> createBattle(@Nullable EntityPredicate builder) {
        return ModCriterions.CLAY_SOLDIER_DEATH.get().createCriterion((CriterionTriggerInstance)new Condition(Optional.empty(), Optional.ofNullable(builder)));
    }

    public void trigger(ServerPlayer serverPlayer, @Nullable Entity killer) {
        this.trigger(serverPlayer, s -> s.match(serverPlayer, killer));
    }

    public record Condition(Optional<ContextAwarePredicate> player, Optional<EntityPredicate> entityPredicate) implements SimpleCriterionTrigger.SimpleInstance
    {
        private static final Codec<Condition> CODEC = RecordCodecBuilder.create(in -> in.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Condition::player), (App)EntityPredicate.CODEC.optionalFieldOf("killer").forGetter(Condition::entityPredicate)).apply((Applicative)in, Condition::new));

        private boolean match(ServerPlayer serverPlayer, @Nullable Entity entity) {
            return this.entityPredicate.map(p -> p.matches(serverPlayer, entity)).orElse(true);
        }
    }
}

