/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.bumblebee.claysoldiers.init.ModCriterions;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;

public class DisruptorKillTrigger
extends SimpleCriterionTrigger<Condition> {
    public Codec<Condition> codec() {
        return Condition.CODEC;
    }

    public static Criterion<Condition> createInstance(int amountRequired) {
        return ModCriterions.DISRUPTOR_KILL_TRIGGER.get().createCriterion((CriterionTriggerInstance)new Condition(Optional.empty(), amountRequired));
    }

    public void trigger(ServerPlayer serverPlayer, int amountKilled) {
        this.trigger(serverPlayer, instance -> instance.matches(amountKilled));
    }

    public record Condition(Optional<ContextAwarePredicate> player, int amountRequired) implements SimpleCriterionTrigger.SimpleInstance
    {
        private static final Codec<Condition> CODEC = RecordCodecBuilder.create(in -> in.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Condition::player), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("amount").forGetter(Condition::amountRequired)).apply((Applicative)in, Condition::new));

        private boolean matches(int amountKilled) {
            return amountKilled >= this.amountRequired;
        }
    }
}

