/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.bumblebee.claysoldiers.init.ModCriterions;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;

public class FeedItemClaySoldierTrigger
extends SimpleCriterionTrigger<Condition> {
    public Codec<Condition> codec() {
        return Condition.CODEC;
    }

    public static Builder wax() {
        return new Builder(Type.WAX);
    }

    public static Builder ofCookie() {
        return new Builder(Type.COOKIE);
    }

    public static Builder ofLoyalty() {
        return new Builder(Type.LOYALTY);
    }

    public void triggerWax(ServerPlayer serverPlayer, ItemStack stack) {
        this.trigger(serverPlayer, c -> c.type == Type.WAX && c.itemPredicate.map(i -> i.test(stack)).orElse(true) != false);
    }

    public void triggerFood(ServerPlayer serverPlayer, ItemStack stack) {
        this.trigger(serverPlayer, c -> c.type == Type.COOKIE && c.itemPredicate.map(i -> i.test(stack)).orElse(true) != false);
    }

    public void triggerLoyalty(ServerPlayer serverPlayer, ItemStack stack) {
        this.trigger(serverPlayer, c -> (c.type == Type.COOKIE || c.type == Type.LOYALTY) && c.itemPredicate.map(i -> i.test(stack)).orElse(true) != false);
    }

    public record Condition(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> itemPredicate, Type type) implements SimpleCriterionTrigger.SimpleInstance
    {
        private static final Codec<Condition> CODEC = RecordCodecBuilder.create(in -> in.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Condition::player), (App)ItemPredicate.CODEC.optionalFieldOf("item_predicate").forGetter(Condition::itemPredicate), (App)Type.CODEC.fieldOf("type").forGetter(Condition::type)).apply((Applicative)in, Condition::new));
    }

    public static class Builder {
        private ItemPredicate itemPredicate;
        private final Type type;

        private Builder(Type type) {
            this.type = type;
        }

        public Builder setItemPredicate(ItemPredicate itemPredicate) {
            this.itemPredicate = itemPredicate;
            return this;
        }

        public Criterion<Condition> build() {
            return ModCriterions.FEED_CLAY_SOLDIER_TRIGGER.get().createCriterion((CriterionTriggerInstance)new Condition(Optional.empty(), Optional.ofNullable(this.itemPredicate), this.type));
        }
    }

    private static enum Type implements StringRepresentable
    {
        WAX("wax"),
        COOKIE("food"),
        LOYALTY("loyalty");

        private static final Codec<Type> CODEC;
        private final String serializedName;

        private Type(String serializedName) {
            this.serializedName = serializedName;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }
}

