/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.bumblebee.claysoldiers.init.ModCriterions;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class HitWithClayBlockTrigger
extends SimpleCriterionTrigger<Condition> {
    public void trigger(ServerPlayer serverPlayer, Entity target, boolean block, @Nullable ItemStack weapon) {
        this.trigger(serverPlayer, c -> c.matches(serverPlayer, target, block, weapon));
    }

    public static Builder of() {
        return new Builder();
    }

    public Codec<Condition> codec() {
        return Condition.CODEC;
    }

    public static class Builder {
        private EntityPredicate target;
        private Boolean isBlock;
        private ItemPredicate weapon;

        private Builder() {
        }

        public Builder setTarget(EntityPredicate.Builder target) {
            return this.setTarget(target.build());
        }

        public Builder setTarget(EntityPredicate target) {
            this.target = target;
            return this;
        }

        public Builder needsToBeBlock() {
            this.isBlock = true;
            return this;
        }

        public Builder needsToBeSoldier() {
            this.isBlock = false;
            return this;
        }

        public Builder setWeapon(ItemPredicate.Builder weapon) {
            return this.setWeapon(weapon.build());
        }

        public Builder setWeapon(ItemPredicate weapon) {
            this.weapon = weapon;
            return this;
        }

        public Criterion<Condition> build() {
            return ModCriterions.HIT_WITH_CLAY_BLOCK_TRIGGER.get().createCriterion((CriterionTriggerInstance)new Condition(Optional.empty(), Optional.ofNullable(this.target), Optional.ofNullable(this.isBlock), Optional.ofNullable(this.weapon)));
        }
    }

    public record Condition(Optional<ContextAwarePredicate> player, Optional<EntityPredicate> target, Optional<Boolean> isBlock, Optional<ItemPredicate> weapon) implements SimpleCriterionTrigger.SimpleInstance
    {
        private static final Codec<Condition> CODEC = RecordCodecBuilder.create(in -> in.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Condition::player), (App)EntityPredicate.CODEC.optionalFieldOf("target").forGetter(Condition::target), (App)Codec.BOOL.optionalFieldOf("isBlock").forGetter(Condition::isBlock), (App)ItemPredicate.CODEC.optionalFieldOf("weapon").forGetter(Condition::weapon)).apply((Applicative)in, Condition::new));

        private boolean matches(ServerPlayer player, @Nullable Entity target, boolean block, @Nullable ItemStack weapon) {
            if (this.target.isPresent() && !this.target.get().matches(player, target)) {
                return false;
            }
            if (this.isBlock.isPresent() && this.isBlock.get() != block) {
                return false;
            }
            if (weapon == null && this.weapon.isPresent()) {
                return false;
            }
            return weapon == null || this.weapon.map(p -> p.test(weapon)).orElse(true) != false;
        }
    }
}

