/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.bumblebee.claysoldiers.init.ModCriterions;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;

public class MultiSpawnItemUseTrigger
extends SimpleCriterionTrigger<Condition> {
    public void trigger(ServerPlayer serverPlayer, EntityType<?> type, int amountSpawned) {
        this.trigger(serverPlayer, c -> c.matches(type, amountSpawned));
    }

    public static Builder of() {
        return new Builder();
    }

    public Codec<Condition> codec() {
        return Condition.CODEC;
    }

    public static class Builder {
        private EntityTypePredicate entityTypePredicate;
        private MinMaxBounds.Ints minMaxBounds;

        private Builder() {
        }

        public Builder setEntityTypePredicate(EntityTypePredicate entityTypePredicate) {
            this.entityTypePredicate = entityTypePredicate;
            return this;
        }

        public Builder setMinMaxBounds(MinMaxBounds.Ints minMaxBounds) {
            this.minMaxBounds = minMaxBounds;
            return this;
        }

        public Criterion<Condition> build() {
            return ModCriterions.MULTI_SPAWN_ITEM_USE_TRIGGER.get().createCriterion((CriterionTriggerInstance)new Condition(Optional.empty(), Optional.ofNullable(this.entityTypePredicate), Optional.of(this.minMaxBounds)));
        }
    }

    public record Condition(Optional<ContextAwarePredicate> player, Optional<EntityTypePredicate> type, Optional<MinMaxBounds.Ints> spawnCount) implements SimpleCriterionTrigger.SimpleInstance
    {
        private static final Codec<Condition> CODEC = RecordCodecBuilder.create(in -> in.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Condition::player), (App)EntityTypePredicate.CODEC.optionalFieldOf("type").forGetter(Condition::type), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("spawn_amount").forGetter(Condition::spawnCount)).apply((Applicative)in, Condition::new));

        private boolean matches(EntityType<?> type, int amountSpawned) {
            if (this.type.isPresent() && !this.type.orElseThrow().matches(type)) {
                return false;
            }
            return this.spawnCount.map(b -> b.matches(amountSpawned)).orElse(true);
        }
    }
}

