/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.bumblebee.claysoldiers.init.ModCriterions;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoiWithSource;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;

public class SoldierPoiUseTrigger
extends SimpleCriterionTrigger<Condition> {
    public Codec<Condition> codec() {
        return Condition.CODEC;
    }

    public void trigger(ServerPlayer serverPlayer, SoldierPoiWithSource.Type type) {
        this.trigger(serverPlayer, instance -> instance.matches(type));
    }

    public static Criterion<Condition> of(SoldierPoiWithSource.Type type) {
        return ModCriterions.SOLDIER_POI_USE_TRIGGER.get().createCriterion((CriterionTriggerInstance)new Condition(Optional.empty(), Optional.of(type)));
    }

    public static Criterion<Condition> any() {
        return ModCriterions.SOLDIER_POI_USE_TRIGGER.get().createCriterion((CriterionTriggerInstance)new Condition(Optional.empty(), Optional.empty()));
    }

    public record Condition(Optional<ContextAwarePredicate> player, Optional<SoldierPoiWithSource.Type> type) implements SimpleCriterionTrigger.SimpleInstance
    {
        private static final Codec<Condition> CODEC = RecordCodecBuilder.create(in -> in.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Condition::player), (App)SoldierPoiWithSource.Type.CODEC.optionalFieldOf("type").forGetter(Condition::type)).apply((Applicative)in, Condition::new));

        private boolean matches(SoldierPoiWithSource.Type type) {
            return this.type.map(t -> t == type).orElse(true);
        }
    }
}

