/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.bumblebee.claysoldiers.capability.AssignableWorksiteCapability;
import net.bumblebee.claysoldiers.init.ModCriterions;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class UseAssignedWorksiteTrigger
extends SimpleCriterionTrigger<Condition> {
    public void trigger(ServerPlayer serverPlayer, Entity user, AssignableWorksiteCapability poiCapability, int timesUsed) {
        this.trigger(serverPlayer, c -> c.matches(serverPlayer, user, poiCapability.descriptionId(), timesUsed));
    }

    public static Builder of() {
        return new Builder();
    }

    public Codec<Condition> codec() {
        return Condition.CODEC;
    }

    public static class Builder {
        private ResourceLocation type;
        private EntityPredicate predicate;
        private MinMaxBounds.Ints time;
        private MinMaxBounds.Ints timesUsed = MinMaxBounds.Ints.atLeast((int)1);

        private Builder() {
        }

        public Builder setType(ResourceLocation type) {
            this.type = type;
            return this;
        }

        public Builder setPredicate(EntityPredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder setTime(MinMaxBounds.Ints time) {
            this.time = time;
            return this;
        }

        public Builder setTimesUsed(MinMaxBounds.Ints timesUsed) {
            this.timesUsed = timesUsed;
            return this;
        }

        public Criterion<Condition> build() {
            return ModCriterions.USE_ASSIGNED_POI_TRIGGER.get().createCriterion((CriterionTriggerInstance)new Condition(Optional.empty(), Optional.ofNullable(this.predicate), Optional.ofNullable(this.type), Optional.ofNullable(this.time), this.timesUsed));
        }
    }

    public record Condition(Optional<ContextAwarePredicate> player, Optional<EntityPredicate> entity, Optional<ResourceLocation> type, Optional<MinMaxBounds.Ints> time, MinMaxBounds.Ints timesUsed) implements SimpleCriterionTrigger.SimpleInstance
    {
        private static final Codec<Condition> CODEC = RecordCodecBuilder.create(in -> in.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Condition::player), (App)EntityPredicate.CODEC.optionalFieldOf("clay_mob").forGetter(Condition::entity), (App)ResourceLocation.CODEC.optionalFieldOf("type").forGetter(Condition::type), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("time").forGetter(Condition::time), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("times_used", (Object)MinMaxBounds.Ints.atLeast((int)1)).forGetter(Condition::timesUsed)).apply((Applicative)in, Condition::new));

        private boolean matches(ServerPlayer serverPlayer, Entity entity, ResourceLocation resourceLocation, int timesUsed) {
            if (!this.timesUsed.matches(timesUsed)) {
                return false;
            }
            if (this.time.isPresent() && !this.time.orElseThrow().matches((int)serverPlayer.level().getDayTime() % 24000)) {
                return false;
            }
            if (this.entity.isPresent() && !this.entity.get().matches(serverPlayer, entity)) {
                return false;
            }
            return this.type.map(arg_0 -> ((ResourceLocation)resourceLocation).equals(arg_0)).orElse(true);
        }
    }
}

