/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.block.blueprint;

import com.mojang.serialization.MapCodec;
import java.util.Objects;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.block.blueprint.EaselBlockEntity;
import net.bumblebee.claysoldiers.blueprint.BlueprintData;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintPlan;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.item.TestItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EaselBlock
extends BaseEntityBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);
    private static final MapCodec<EaselBlock> CODEC = EaselBlock.simpleCodec(EaselBlock::new);

    public EaselBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isEnabled(FeatureFlagSet enabledFeatures) {
        return ClaySoldiersCommon.COMMON_HOOKS.isBlueprintEnabled(enabledFeatures);
    }

    protected MapCodec<? extends EaselBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new EaselBlockEntity(pPos, pState);
    }

    protected InteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        EaselBlockEntity easeBlockEntity = (EaselBlockEntity)Objects.requireNonNull(pLevel.getBlockEntity(pPos));
        if (ModItems.TEST_ITEM.is(pStack)) {
            TestItem.log((EaselBlockEntity)pLevel.getBlockEntity(pPos), ((EaselBlockEntity)pLevel.getBlockEntity(pPos)).getInfoState());
            return InteractionResult.SUCCESS_SERVER;
        }
        if (pStack.isEmpty()) {
            return InteractionResult.PASS;
        }
        BlueprintData bluePrintData = (BlueprintData)pLevel.registryAccess().lookupOrThrow(ModRegistries.BLUEPRINTS).getValue((ResourceLocation)pStack.get(ModDataComponents.BLUEPRINT_DATA.get()));
        if (bluePrintData != null && bluePrintData.isValid()) {
            easeBlockEntity.setBlueprintData(bluePrintData);
            return InteractionResult.SUCCESS_SERVER;
        }
        if (easeBlockEntity.hasBlueprintData()) {
            BlueprintPlan.PlaceResult placeResult;
            if (!pLevel.isClientSide() && (placeResult = easeBlockEntity.tryPlacingSoldier(pStack, (LivingEntity)pPlayer)).isSuccess() && !pPlayer.isCreative()) {
                pStack.shrink(1);
            }
            return InteractionResult.SUCCESS_SERVER;
        }
        return InteractionResult.FAIL;
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        EaselBlockEntity easeBlockEntity = (EaselBlockEntity)pLevel.getBlockEntity(pPos);
        if (!easeBlockEntity.hasBlueprintData()) {
            return InteractionResult.FAIL;
        }
        if (pPlayer.isCrouching()) {
            if (!pLevel.isClientSide()) {
                pPlayer.addItem(easeBlockEntity.getBlueprintItem());
            }
            easeBlockEntity.clearBlueprintData();
        } else if (!easeBlockEntity.cycleMirror()) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS_SERVER;
    }

    protected BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue(FACING, (Comparable)pRot.rotate((Direction)pState.getValue(FACING)));
    }

    protected BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue(FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }
}

