/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.block.blueprint;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.block.blueprint.EaselBlock;
import net.bumblebee.claysoldiers.blueprint.BlueprintData;
import net.bumblebee.claysoldiers.blueprint.BlueprintManager;
import net.bumblebee.claysoldiers.blueprint.BlueprintRequest;
import net.bumblebee.claysoldiers.blueprint.BlueprintTemplateSettings;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintPlan;
import net.bumblebee.claysoldiers.blueprint.templates.ClientBlueprintPlan;
import net.bumblebee.claysoldiers.blueprint.templates.ServerBlueprintPlan;
import net.bumblebee.claysoldiers.capability.BlueprintRequestHandler;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.init.ModBlockEntities;
import net.bumblebee.claysoldiers.init.ModCriterions;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.networking.BlueprintPlacePayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EaselBlockEntity
extends BlockEntity {
    private static final String INDICATE_TAG_ON_CLIENT = "Client";
    private static final String MIRROR_TAG = "mirror";
    private static final String TEMPLATE_TAG = "template";
    @Nullable
    private BlueprintData data;
    @Nullable
    private BlueprintPlan template;
    private final BlueprintRequestHandler blueprintRequestHandler = new BlueprintRequestHandler(){

        @Override
        @Nullable
        public BlueprintRequest getRequest(Predicate<BlockPos> canReach) {
            return EaselBlockEntity.this.getBlueprintRequest(canReach);
        }

        @Override
        public boolean doRequest(@Nullable BlueprintRequest request, ClayMobEntity placer) {
            return EaselBlockEntity.this.doBlueprintRequest(request, placer);
        }
    };
    private Mirror mirror = Mirror.NONE;

    public EaselBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.EASEL_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public List<String> getInfoState() {
        ArrayList<String> info = new ArrayList<String>(3);
        info.add("Data: " + String.valueOf(this.data));
        info.add("Template: " + String.valueOf(this.template));
        info.add("Settings: " + String.valueOf(this.getTemplateSettings()));
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            info.add("Blueprint Cap: " + String.valueOf(ClaySoldiersCommon.CAPABILITY_MANGER.createPoiCache(serverLevel, this.worldPosition)));
        }
        return info;
    }

    public void setBlueprintData(@NotNull BlueprintData data) {
        this.data = data;
        this.template = !this.level.isClientSide() ? (BlueprintPlan)data.createServerPlan().orElseThrow(IllegalArgumentException::new) : data.createClientPlan().orElseThrow(IllegalArgumentException::new);
        this.setChanged();
    }

    public void clearBlueprintData() {
        this.data = null;
        this.template = null;
        this.setChanged();
    }

    public ItemStack getBlueprintItem() {
        return BlueprintManager.createBlueprintItem(this.data, this.level.registryAccess());
    }

    public boolean hasBlueprintData() {
        return this.data != null;
    }

    @Nullable
    public BlueprintData getBlueprintData() {
        return this.data;
    }

    public List<ItemStack> getRequiredItems() {
        return this.template == null ? List.of() : this.template.getNeededItems();
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        if (this.data != null) {
            this.data.save(pTag, pRegistries);
        }
        if (pTag.contains(INDICATE_TAG_ON_CLIENT)) {
            if (this.template != null) {
                this.template.saveItems(pTag);
                this.template.saveSize(pTag);
                this.template.saveHasStarted(pTag);
            } else {
                pTag.remove(INDICATE_TAG_ON_CLIENT);
            }
        } else {
            BlueprintPlan blueprintPlan = this.template;
            if (blueprintPlan instanceof ServerBlueprintPlan) {
                ServerBlueprintPlan serverTemplate = (ServerBlueprintPlan)blueprintPlan;
                CompoundTag templateTag = new CompoundTag();
                pTag.put(TEMPLATE_TAG, (Tag)serverTemplate.save(templateTag));
            }
        }
        this.saveMirror(pTag);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.data = BlueprintData.load(pTag, pRegistries);
        if (pTag.contains(INDICATE_TAG_ON_CLIENT)) {
            this.template = new ClientBlueprintPlan(pTag);
        } else if (pTag.contains(TEMPLATE_TAG)) {
            this.template = ServerBlueprintPlan.load(pTag.getCompound(TEMPLATE_TAG), pRegistries);
        }
        this.loadMirror(pTag);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean(INDICATE_TAG_ON_CLIENT, true);
        this.saveAdditional(tag, pRegistries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    private void saveMirror(CompoundTag tag) {
        tag.putString(MIRROR_TAG, this.mirror.toString());
    }

    private void loadMirror(CompoundTag tag) {
        try {
            this.mirror = Mirror.valueOf((String)tag.getString(MIRROR_TAG));
        }
        catch (IllegalArgumentException ignored) {
            this.mirror = Mirror.NONE;
        }
    }

    public boolean cycleMirror() {
        if (this.hasStarted()) {
            return false;
        }
        this.mirror = this.mirror == Mirror.NONE ? Mirror.FRONT_BACK : Mirror.NONE;
        return true;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public boolean hasStarted() {
        return this.template != null && this.template.hasStarted();
    }

    public boolean isFinished() {
        return this.template != null && this.template.isFinished();
    }

    @Nullable
    public BlueprintTemplateSettings getTemplateSettings() {
        if (this.template == null) {
            return null;
        }
        return new BlueprintTemplateSettings(this.template.getSize(), this.mirror, EaselBlockEntity.fromDirection(this.getFacing()));
    }

    public Direction getFacing() {
        return (Direction)this.getBlockState().getValue(EaselBlock.FACING);
    }

    private static Rotation fromDirection(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> Rotation.NONE;
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
            default -> throw new IllegalStateException("Easel Block Entity should never have a BlockState Facing of:" + String.valueOf(direction));
        };
    }

    @Nullable
    private BlueprintRequest getBlueprintRequest(Predicate<BlockPos> canReachDestination) {
        if (this.template == null || this.template.isFinished()) {
            return null;
        }
        BlueprintTemplateSettings settings = this.getTemplateSettings();
        BlueprintRequest request = ((ServerBlueprintPlan)this.template).getRequest((ServerLevel)this.level, this.getTemplateBase(settings), this.getTemplateSettings(), canReachDestination);
        if (request != null && !canReachDestination.test(request.getPos())) {
            request.cancel();
            return null;
        }
        return request;
    }

    private BlockPos getTemplateBase(BlueprintTemplateSettings settings) {
        return this.worldPosition.offset((Vec3i)BlockPos.ZERO.relative(this.getFacing().getOpposite(), 2).relative(this.getFacing().getClockWise(), settings.getDistanceToCenter()));
    }

    private boolean doBlueprintRequest(@Nullable BlueprintRequest request, ClayMobEntity placer) {
        if (request == null) {
            return false;
        }
        return this.tryPlacingSoldier(request.getItem().getDefaultInstance(), (LivingEntity)placer).isSuccess();
    }

    public BlueprintPlan.PlaceResult tryPlacingSoldier(ItemStack item, @Nullable LivingEntity placer) {
        if (this.template == null) {
            return BlueprintPlan.PlaceResult.NOT_NEEDED;
        }
        BlueprintTemplateSettings settings = this.getTemplateSettings();
        BlueprintPlan.PlaceResult result = this.template.tryPlacing(this.level, item, this.getTemplateBase(settings), settings);
        if (result.isSuccess()) {
            if (!this.level.isClientSide()) {
                ClaySoldiersCommon.NETWORK_MANGER.sendToPlayersTrackingBlockEntity(this, new BlueprintPlacePayload(this.worldPosition, item.getItem()));
                this.triggerAdvancement(placer, this.template.isFinished());
            }
            this.setChanged();
        }
        return result;
    }

    private void triggerAdvancement(@Nullable LivingEntity placer, boolean isFinished) {
        ClayMobEntity clayMob;
        Player player;
        ResourceKey key = (ResourceKey)this.level.registryAccess().lookupOrThrow(ModRegistries.BLUEPRINTS).getResourceKey((Object)this.data).orElseThrow(() -> new IllegalStateException("Key for BlueprintData does not exist"));
        if (placer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)placer;
            ModCriterions.BLUEPRINT_COMPLETION_TRIGGER.get().trigger(serverPlayer, (ResourceKey<BlueprintData>)key, isFinished);
        } else if (placer instanceof ClayMobEntity && (player = (clayMob = (ClayMobEntity)placer).getClayTeamOwner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModCriterions.BLUEPRINT_COMPLETION_TRIGGER.get().trigger(serverPlayer, (ResourceKey<BlueprintData>)key, isFinished);
        }
    }

    public BlueprintRequestHandler getBlueprintRequestHandler() {
        return this.blueprintRequestHandler;
    }

    public String toString() {
        String levelName = this.level != null ? (this.level.isClientSide() ? INDICATE_TAG_ON_CLIENT : "Server") : "Null";
        return "EaselBlockEntity(%s, %s)".formatted(levelName, this.getBlockPos());
    }
}

