/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.block.blueprint;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.bumblebee.claysoldiers.ClaySoldiersClient;
import net.bumblebee.claysoldiers.block.blueprint.EaselBlockEntity;
import net.bumblebee.claysoldiers.blueprint.BlueprintData;
import net.bumblebee.claysoldiers.blueprint.BlueprintTemplateSettings;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EaselBlockEntityRenderer
implements BlockEntityRenderer<EaselBlockEntity> {
    public static final ResourceLocation STAND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"textures/block/easel.png");
    private static final ResourceLocation BLUEPRINT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"textures/block/easel_blueprint.png");
    private static final RenderType RENDER_TYPE_STAND = RenderType.entityCutoutNoCull((ResourceLocation)STAND_TEXTURE);
    private static final RenderType RENDER_TYPE_BLUEPRINT = RenderType.entityCutoutNoCull((ResourceLocation)BLUEPRINT_TEXTURE);
    public static final ModelLayerLocation STAND_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"easel_stand"), "main");
    public static final ModelLayerLocation BLUEPRINT_LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"easel_blueprint"), "main");
    private final ModelPart stand;
    private final ModelPart blueprint;

    public EaselBlockEntityRenderer(BlockEntityRendererProvider.Context pContext) {
        this.stand = pContext.bakeLayer(STAND_LAYER_LOCATION);
        this.blueprint = pContext.bakeLayer(BLUEPRINT_LAYER_LOCATION);
    }

    public EaselBlockEntityRenderer(EntityModelSet set) {
        this.stand = set.bakeLayer(STAND_LAYER_LOCATION);
        this.blueprint = set.bakeLayer(BLUEPRINT_LAYER_LOCATION);
    }

    public void render(EaselBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        BlueprintTemplateSettings settings = pBlockEntity.getTemplateSettings();
        BlueprintData data = pBlockEntity.getBlueprintData();
        float yRot = pBlockEntity.getFacing().getOpposite().toYRot();
        pPoseStack.pushPose();
        pPoseStack.translate(0.5f, 0.5f, 0.5f);
        pPoseStack.mulPose(Axis.YP.rotationDegrees(-yRot));
        pPoseStack.translate(-0.5f, -0.5f, -0.5f);
        this.stand.render(pPoseStack, pBuffer.getBuffer(RENDER_TYPE_STAND), pPackedLight, pPackedOverlay, -1);
        if (data == null) {
            pPoseStack.popPose();
            return;
        }
        if (pBlockEntity.getMirror() != Mirror.NONE) {
            pPoseStack.scale(-1.0f, 1.0f, 1.0f);
            pPoseStack.translate(-1.0f, 0.0f, 0.0f);
        }
        this.blueprint.render(pPoseStack, pBuffer.getBuffer(RENDER_TYPE_BLUEPRINT), pPackedLight, pPackedOverlay, -1);
        pPoseStack.popPose();
        if (settings == null || !EaselBlockEntityRenderer.shouldShowOutline()) {
            return;
        }
        Vec3i offset = settings.getOutlineOffset();
        pPoseStack.translate(0.5f, 0.5f, 0.5f);
        pPoseStack.mulPose(Axis.YP.rotation(settings.getOutlineRotation()));
        pPoseStack.translate(-0.5f, -0.5f, -0.5f);
        if (pBlockEntity.getMirror() != Mirror.NONE) {
            pPoseStack.scale(-1.0f, 1.0f, 1.0f);
            pPoseStack.translate(-1.0f, 0.0f, 0.0f);
        }
        if (!pBlockEntity.isFinished()) {
            EaselBlockEntityRenderer.renderStructureOutline(pPoseStack, pBuffer.getBuffer(RenderType.lines()), data.getShape(), offset.getX(), offset.getY(), offset.getZ(), pBlockEntity.hasStarted() ? 0.0f : 1.0f, 1.0f, 0.0f, 0.4f);
        }
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        pPoseStack.pushPose();
        pPoseStack.translate(0.5f, 0.5f, 0.5f);
        pPoseStack.translate(-0.5f, -0.5f, -0.5f);
        this.stand.render(pPoseStack, pBuffer.getBuffer(RENDER_TYPE_STAND), pPackedLight, pPackedOverlay, -1);
        pPoseStack.popPose();
    }

    public int getViewDistance() {
        return 96;
    }

    public boolean shouldRenderOffScreen(EaselBlockEntity pBlockEntity) {
        return true;
    }

    private static void renderStructureOutline(PoseStack pPoseStack, VertexConsumer pConsumer, VoxelShape pShape, double pX, double pY, double pZ, float pRed, float pGreen, float pBlue, float pAlpha) {
        PoseStack.Pose posestack$pose = pPoseStack.last();
        pShape.forAllEdges((x1, y1, z1, x2, y2, z2) -> {
            float xLength = (float)(x2 - x1);
            float yLength = (float)(y2 - y1);
            float zLength = (float)(z2 - z1);
            float f3 = Mth.sqrt((float)(xLength * xLength + yLength * yLength + zLength * zLength));
            pConsumer.addVertex(posestack$pose, (float)(x1 + pX), (float)(y1 + pY), (float)(z1 + pZ)).setColor(pRed, pGreen, pBlue, pAlpha).setNormal(posestack$pose, xLength /= f3, yLength /= f3, zLength /= f3);
            pConsumer.addVertex(posestack$pose, (float)(x2 + pX), (float)(y2 + pY), (float)(z2 + pZ)).setColor(pRed, pGreen, pBlue, pAlpha).setNormal(posestack$pose, xLength, yLength, zLength);
        });
    }

    private static boolean shouldShowOutline() {
        return ClaySoldiersClient.hasPlayerClayGogglesEquipped();
    }

    public static LayerDefinition createStandLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition stand = partdefinition.addOrReplaceChild("stand", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 3.0f, -3.0f, 10.0f, 1.0f, 1.0f).texOffs(14, 2).addBox(-1.5f, -3.0f, -1.999f, 3.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)8.0f, (float)7.0f, (float)8.0f, (float)-0.4363f, (float)0.0f, (float)((float)Math.PI)));
        PartDefinition back_r1 = stand.addOrReplaceChild("back_r1", CubeListBuilder.create().texOffs(8, 2).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 11.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-1.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition left_r1 = stand.addOrReplaceChild("left_r1", CubeListBuilder.create().texOffs(0, 2).addBox(0.0f, 0.0f, -1.0f, 1.0f, 16.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.5f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition right_r1 = stand.addOrReplaceChild("right_r1", CubeListBuilder.create().texOffs(4, 2).addBox(-1.0f, 0.0f, -1.0f, 1.0f, 16.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.5f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public static LayerDefinition createBlueprintLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("blueprint", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -5.0f, -2.001f, 8.0f, 8.0f, 0.0f), PartPose.offsetAndRotation((float)8.0f, (float)7.0f, (float)8.0f, (float)-0.4363f, (float)0.0f, (float)((float)Math.PI)));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }
}

