/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.block.hamsterwheel;

import com.mojang.serialization.MapCodec;
import net.bumblebee.claysoldiers.block.hamsterwheel.BatteryProperty;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntity;
import net.bumblebee.claysoldiers.init.ModBlockEntities;
import net.bumblebee.claysoldiers.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class HamsterWheelBlock
extends BaseEntityBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<BatteryProperty> BATTERY_PROPERTY = EnumProperty.create((String)"battery", BatteryProperty.class);
    private static final VoxelShape SHAPE_WEST = Block.box((double)5.0, (double)0.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)1.0, (double)0.0, (double)2.0, (double)11.0, (double)14.0, (double)14.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)14.0, (double)11.0);
    private static final VoxelShape SHAPE_NORTH = Block.box((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)14.0, (double)15.0);
    private static final VoxelShape SHAPE_POWERED_WEST = Block.box((double)5.0, (double)0.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private static final VoxelShape SHAPE_POWERED_EAST = Block.box((double)0.0, (double)0.0, (double)2.0, (double)11.0, (double)14.0, (double)14.0);
    private static final VoxelShape SHAPE_POWERED_SOUTH = Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)14.0, (double)11.0);
    private static final VoxelShape SHAPE_POWERED_NORTH = Block.box((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)14.0, (double)16.0);
    private static final MapCodec<HamsterWheelBlock> CODEC = HamsterWheelBlock.simpleCodec(HamsterWheelBlock::new);

    public HamsterWheelBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(BATTERY_PROPERTY, (Comparable)((Object)BatteryProperty.NONE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, BATTERY_PROPERTY});
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (HamsterWheelBlock.hasPowerConnection(pState)) {
            return HamsterWheelBlock.getVoxelShape(pState, SHAPE_POWERED_NORTH, SHAPE_POWERED_SOUTH, SHAPE_POWERED_EAST, SHAPE_POWERED_WEST);
        }
        return HamsterWheelBlock.getVoxelShape(pState, SHAPE_NORTH, SHAPE_SOUTH, SHAPE_EAST, SHAPE_WEST);
    }

    private static VoxelShape getVoxelShape(BlockState pState, VoxelShape shapeNorth, VoxelShape shapeSouth, VoxelShape shapeEast, VoxelShape shapeWest) {
        return switch ((Direction)pState.getValue(FACING)) {
            case Direction.NORTH -> shapeNorth;
            case Direction.SOUTH -> shapeSouth;
            case Direction.EAST -> shapeEast;
            case Direction.WEST -> shapeWest;
            default -> throw new IllegalStateException("Direction should never be any other than N,E,S,W");
        };
    }

    protected InteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        if (pStack.is(Items.REDSTONE)) {
            if (pState.getValue(BATTERY_PROPERTY) == BatteryProperty.NONE) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue(BATTERY_PROPERTY, (Comparable)((Object)BatteryProperty.SINGLE)), 3);
                pStack.consume(1, (LivingEntity)pPlayer);
                return InteractionResult.SUCCESS;
            }
            if (pState.getValue(BATTERY_PROPERTY) == BatteryProperty.SINGLE) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue(BATTERY_PROPERTY, (Comparable)((Object)BatteryProperty.DUAL)), 3);
                pStack.consume(1, (LivingEntity)pPlayer);
                return InteractionResult.SUCCESS;
            }
        }
        if (pStack.is(ModTags.Items.WRENCH)) {
            pLevel.setBlock(pPos, this.rotate(pState, Rotation.CLOCKWISE_90), 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        HamsterWheelBlockEntity hamsterWheelBlockEntity = (HamsterWheelBlockEntity)pLevel.getBlockEntity(pPos);
        if (hamsterWheelBlockEntity.hasSoldier()) {
            hamsterWheelBlockEntity.spawnSoldier(7);
            hamsterWheelBlockEntity.setChanged();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean hasPowerConnection(BlockState state) {
        return state.getValue(BATTERY_PROPERTY) != BatteryProperty.NONE;
    }

    protected void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (!pState.is(pNewState.getBlock())) {
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
            if (blockEntity instanceof HamsterWheelBlockEntity) {
                HamsterWheelBlockEntity hamsterWheelBlockEntity = (HamsterWheelBlockEntity)blockEntity;
                hamsterWheelBlockEntity.spawnSoldier(0);
            }
            if (HamsterWheelBlock.hasPowerConnection(pState)) {
                Containers.dropItemStack((Level)pLevel, (double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), (ItemStack)Items.REDSTONE.getDefaultInstance());
            }
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    protected MapCodec<? extends HamsterWheelBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new HamsterWheelBlockEntity(pPos, pState);
    }

    protected BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue(FACING, (Comparable)pRot.rotate((Direction)pState.getValue(FACING)));
    }

    protected BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue(FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : HamsterWheelBlock.createTickerHelper(blockEntityType, ModBlockEntities.HAMSTER_WHEEL_BLOCK_ENTITY.get(), (level1, blockPos, blockState, hamsterWheelBlockEntity) -> hamsterWheelBlockEntity.serverTick());
    }
}

