/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.block.hamsterwheel;

import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.block.ClayMobContainer;
import net.bumblebee.claysoldiers.block.hamsterwheel.BatteryProperty;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlock;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelSoldierData;
import net.bumblebee.claysoldiers.block.hamsterwheel.IHamsterWheelEnergyStorage;
import net.bumblebee.claysoldiers.capability.AssignableWorksiteCapability;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModBlockEntities;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.networking.HamsterWheelEnergyPayload;
import net.bumblebee.claysoldiers.team.TeamLoyaltyManger;
import net.bumblebee.claysoldiers.team.TeamPlayerData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HamsterWheelBlockEntity
extends BlockEntity
implements ClayMobContainer {
    public static final ResourceLocation WORKSITE_ID = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"hamster_wheel");
    private final WalkAnimationState walkAnimation = new WalkAnimationState();
    private final IHamsterWheelEnergyStorage energyStorage;
    private final AssignableWorksiteCapability poiCap = new AssignableWorksiteCapability(){

        @Override
        public boolean canUse(ClayMobEntity clayMob) {
            AbstractClaySoldierEntity soldier;
            return clayMob instanceof AbstractClaySoldierEntity && (soldier = (AbstractClaySoldierEntity)clayMob).getSoldierSize() <= 1.45f;
        }

        @Override
        public int onUse(ClayMobEntity clayMob) {
            if (clayMob instanceof AbstractClaySoldierEntity) {
                AbstractClaySoldierEntity soldier = (AbstractClaySoldierEntity)clayMob;
                HamsterWheelBlockEntity.this.addSoldier(soldier);
                return 1;
            }
            throw new IllegalArgumentException(String.valueOf(clayMob) + " cannot use this poi");
        }

        @Override
        public ResourceLocation descriptionId() {
            return WORKSITE_ID;
        }
    };
    @Nullable
    private HamsterWheelSoldierData soldierData = null;
    private long lastEnergySend = 0L;
    private int rotationTick = 0;

    public HamsterWheelBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.HAMSTER_WHEEL_BLOCK_ENTITY.get(), pPos, pBlockState);
        this.energyStorage = ClaySoldiersCommon.CAPABILITY_MANGER.createEnergyStorage(this);
    }

    public void clientTick(float partialTick) {
        if (this.hasSoldier()) {
            this.rotationTick += (int)Math.clamp(this.soldierData.getSpeed(), 1.0f, 3.0f);
            ++this.soldierData.getClientSoldier().tickCount;
            float f = Math.min(partialTick * 4.0f, 1.0f);
            this.walkAnimation.update(f, 0.4f, 1.0f);
        }
    }

    public float getRotationTick(float partialTick) {
        return (float)this.rotationTick + (this.hasSoldier() ? partialTick : 0.0f);
    }

    public boolean hasSoldier() {
        return this.soldierData != null;
    }

    @Nullable
    public HamsterWheelSoldierData getSoldierData() {
        return this.soldierData;
    }

    private void addSoldier(AbstractClaySoldierEntity soldier) {
        this.spawnSoldier(0);
        soldier.stopRiding();
        soldier.ejectPassengers();
        soldier.dropCarried();
        this.setSoldierData(HamsterWheelSoldierData.of(soldier), 7);
        soldier.discard();
    }

    public AssignableWorksiteCapability getPoiCap() {
        return this.poiCap;
    }

    @Nullable
    public IHamsterWheelEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        if (this.hasEnergyStorage()) {
            if (direction == null) {
                return this.energyStorage.asViewOnly();
            }
            return direction.getOpposite() == this.getBlockState().getValue(HamsterWheelBlock.FACING) ? this.energyStorage : null;
        }
        return null;
    }

    @Nullable
    public static IHamsterWheelEnergyStorage getEnergyStorage(BlockEntity blockEntity, Direction context) {
        if (blockEntity instanceof HamsterWheelBlockEntity) {
            HamsterWheelBlockEntity hamsterWheelBlockEntity = (HamsterWheelBlockEntity)blockEntity;
            return hamsterWheelBlockEntity.getEnergyStorage(context);
        }
        return null;
    }

    public boolean hasEnergyStorage() {
        return HamsterWheelBlock.hasPowerConnection(this.getBlockState());
    }

    public boolean hasSecondBattery() {
        return this.getBlockState().getValue(HamsterWheelBlock.BATTERY_PROPERTY) == BatteryProperty.DUAL;
    }

    public int getEnergyCapacityMultiplier() {
        return ((BatteryProperty)((Object)this.getBlockState().getValue(HamsterWheelBlock.BATTERY_PROPERTY))).getCapacityMultiplier();
    }

    public void spawnSoldier(int flags) {
        if (this.hasSoldier()) {
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                AbstractClaySoldierEntity soldier = this.soldierData.createSoldier(serverLevel);
                soldier.moveTo(this.getExitPosition());
                soldier.setHealth(soldier.getMaxHealth());
                this.getLevel().addFreshEntity((Entity)soldier);
            }
            this.setSoldierData(null, flags);
        }
    }

    public Vec3 getExitPosition() {
        BlockPos pos = this.worldPosition;
        Direction direction = (Direction)this.getBlockState().getValue(HamsterWheelBlock.FACING);
        return new Vec3((double)pos.getX() + 0.5 + (double)((float)direction.getStepX() * 0.3f), (double)pos.getY(), (double)pos.getZ() + 0.5 + (double)((float)direction.getStepZ() * 0.3f));
    }

    private void setSoldierData(@Nullable HamsterWheelSoldierData data, int flags) {
        this.soldierData = data;
        if ((flags & 1) != 0) {
            this.setChanged();
        }
        if ((flags & 2) != 0) {
            this.getLevel().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
        if ((flags & 4) != 0) {
            this.setOccupant(this.getLevel(), data);
        }
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        try {
            this.setOccupant(level, this.soldierData);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void setOccupant(@Nullable Level level, @Nullable HamsterWheelSoldierData data) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (data == null) {
                serverLevel.getPoiManager().release(this.worldPosition);
            } else {
                serverLevel.getPoiManager().take(h -> h.is(ModTags.PoiTypes.SOLDIER_CONTAINER), (h, p) -> p.equals((Object)this.worldPosition), this.worldPosition, 1);
            }
        }
    }

    @Override
    public void killSoldier(ServerLevel level, ServerPlayer player) {
        if (this.soldierData == null) {
            return;
        }
        TeamPlayerData.PlayerData owner = TeamLoyaltyManger.getTeamPlayerData(level).getPlayerForTeam(this.soldierData.getTeamId());
        if (owner == null || owner.is((Player)player)) {
            Vec3 pos = this.getExitPosition();
            this.soldierData.dropItems(level, pos.x, pos.y, pos.z);
            this.setSoldierData(null, 7);
            this.setChanged();
            level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    @Override
    public boolean canKillClayMob(ServerLevel level, ServerPlayer player) {
        if (this.soldierData == null) {
            return false;
        }
        TeamPlayerData.PlayerData owner = TeamLoyaltyManger.getTeamPlayerData(level).getPlayerForTeam(this.soldierData.getTeamId());
        return owner == null || owner.is((Player)player);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        if (this.soldierData != null) {
            this.soldierData.save(pTag);
        }
        this.energyStorage.save(pTag);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.setSoldierData(HamsterWheelSoldierData.load(pTag, this.getBlockPos(), this.walkAnimation, pRegistries), 0);
        this.energyStorage.load(pTag);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = super.getUpdateTag(pRegistries);
        HamsterWheelSoldierData.markTagAsClient(tag);
        this.saveAdditional(tag, pRegistries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void serverTick() {
        if (this.hasEnergyStorage() && this.hasSoldier()) {
            this.energyStorage.generate(this.soldierData.getAdjustedSpeed());
        }
        if (this.hasEnergyStorage() && Math.abs(this.lastEnergySend - this.energyStorage.energyStored()) > 2L) {
            ClaySoldiersCommon.NETWORK_MANGER.sendToPlayersTrackingBlockEntity(this, new HamsterWheelEnergyPayload(this.energyStorage.energyStored(), this.getBlockPos()));
            this.lastEnergySend = this.energyStorage.energyStored();
            this.setChanged();
        }
    }

    public String toString() {
        return "HamsterWheelBlockEntity(%s, %s)".formatted(this.worldPosition.toShortString(), this.level);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HamsterWheelBlockEntity entity = (HamsterWheelBlockEntity)o;
        return this.worldPosition.equals((Object)entity.worldPosition);
    }

    public int hashCode() {
        return this.worldPosition.hashCode();
    }
}

