/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.blueprint.templates.BaseImmutableTemplate;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintPlan;
import net.bumblebee.claysoldiers.blueprint.templates.ServerBlueprintPlan;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class BlueprintData {
    private static final String BLUEPRINT_DATA_TAG = "BlueprintData";
    public static final Codec<BlueprintData> JSON_CODEC = RecordCodecBuilder.create(in -> in.group((App)ResourceLocation.CODEC.fieldOf("location").forGetter(BlueprintData::location), (App)Codec.STRING.fieldOf("name").forGetter(BlueprintData::name), (App)Codec.FLOAT.optionalFieldOf("marking", (Object)Float.valueOf(0.0f)).forGetter(BlueprintData::marking)).apply((Applicative)in, BlueprintData::new));
    private final ResourceLocation location;
    private final String name;
    private final float marking;
    private BaseImmutableTemplate template;
    @Nullable
    private VoxelShape voxelShape;
    private boolean valid = false;

    public BlueprintData(ResourceLocation location, String name, float marking) {
        this.location = location;
        this.name = name;
        this.marking = marking;
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.name());
    }

    public void save(CompoundTag tag, HolderLookup.Provider registries) {
        registries.lookupOrThrow(ModRegistries.BLUEPRINTS).listElements().filter(h -> ((BlueprintData)h.value()).equals(this)).findAny().ifPresentOrElse(holder -> ResourceLocation.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)holder.key().location()).ifSuccess(key -> tag.put(BLUEPRINT_DATA_TAG, key)).ifError(err -> ClaySoldiersCommon.LOGGER.error("Error Saving Key of {} to tag: {}", (Object)holder.key(), (Object)err.message())), () -> ClaySoldiersCommon.LOGGER.error("Error Loading Blueprint Data from Tag"));
    }

    public void bindStructure(BaseImmutableTemplate template) {
        if (template == null) {
            return;
        }
        this.template = template;
        this.voxelShape = template.getShape();
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Optional<ServerBlueprintPlan> createServerPlan() {
        return this.valid ? this.template.createServer() : Optional.empty();
    }

    public Optional<BlueprintPlan> createClientPlan() {
        return this.valid ? this.template.createClient() : Optional.empty();
    }

    @Nullable
    public static BlueprintData load(CompoundTag tag, HolderLookup.Provider pRegistries) {
        if (!tag.contains(BLUEPRINT_DATA_TAG)) {
            return null;
        }
        ResourceLocation key = (ResourceLocation)ResourceLocation.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(BLUEPRINT_DATA_TAG)).getOrThrow();
        Optional holder = pRegistries.lookupOrThrow(ModRegistries.BLUEPRINTS).get(ResourceKey.create(ModRegistries.BLUEPRINTS, (ResourceLocation)key));
        if (holder.isEmpty()) {
            ClaySoldiersCommon.LOGGER.error("Tried Loading Blueprint Data that does not exist {}", (Object)key);
        }
        return holder.map(Holder.Reference::value).orElse(null);
    }

    public ResourceLocation location() {
        return this.location;
    }

    public String name() {
        return this.name;
    }

    public float marking() {
        return this.marking;
    }

    public BaseImmutableTemplate getTemplate() {
        if (!this.valid) {
            throw new IllegalStateException("Tried getting the Template, but data is invalid " + String.valueOf(this));
        }
        return this.template;
    }

    public VoxelShape getShape() {
        if (!this.valid) {
            throw new IllegalStateException("Tried getting the Shape, but data is invalid " + String.valueOf(this));
        }
        return this.voxelShape;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BlueprintData that = (BlueprintData)obj;
        return Objects.equals(this.location, that.location) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.name);
    }

    public String toString() {
        return "BlueprintData[%s, %s, %s, %s, %s]".formatted(this.name, this.location.getPath(), this.valid ? "Valid" : "Invalid", this.template == null ? "NoTemplate" : this.template.toShortString(), this.voxelShape == null ? "NoShape" : "WithShape");
    }
}

