/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;

public record BlueprintTemplateSettings(Vec3i structureSize, Mirror mirror, Rotation rotation) {
    private static final float DEG_90 = 1.5707964f;
    private static final float DEG_270 = -1.5707964f;

    public Vec3i getOutlineOffset() {
        return new BlockPos(-this.structureSize.getX() / 2, 0, 2);
    }

    public float getOutlineRotation() {
        return switch (this.rotation) {
            default -> throw new MatchException(null, null);
            case Rotation.NONE -> 0.0f;
            case Rotation.CLOCKWISE_90 -> -1.5707964f;
            case Rotation.CLOCKWISE_180 -> (float)Math.PI;
            case Rotation.COUNTERCLOCKWISE_90 -> 1.5707964f;
        };
    }

    public int getDistanceToCenter() {
        return this.structureSize.getX() / 2 * (this.mirror != Mirror.NONE ? 1 : -1);
    }

    public StructurePlaceSettings convertTo() {
        StructurePlaceSettings settings = new StructurePlaceSettings();
        settings.setMirror(this.mirror);
        settings.setRotation(this.rotation);
        return settings;
    }
}

