/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint.templates;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintPlan;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintUtil;
import net.bumblebee.claysoldiers.blueprint.templates.ClientBlueprintPlan;
import net.bumblebee.claysoldiers.blueprint.templates.ServerBlueprintPlan;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.UnmodifiableView;

public class BaseImmutableTemplate {
    private static final StreamCodec<ByteBuf, AABB> AABB_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, aabb -> aabb.minX, (StreamCodec)ByteBufCodecs.DOUBLE, aabb -> aabb.minY, (StreamCodec)ByteBufCodecs.DOUBLE, aabb -> aabb.minZ, (StreamCodec)ByteBufCodecs.DOUBLE, aabb -> aabb.maxX, (StreamCodec)ByteBufCodecs.DOUBLE, aabb -> aabb.maxY, (StreamCodec)ByteBufCodecs.DOUBLE, aabb -> aabb.maxZ, AABB::new);
    private static final StreamCodec<ByteBuf, VoxelShape> VOXEL_SHAPE_STREAM_CODEC = AABB_STREAM_CODEC.apply(ByteBufCodecs.list()).map(aabbs -> aabbs.stream().map(Shapes::create).reduce(Shapes.empty(), (voxelShape, voxelShape2) -> Shapes.joinUnoptimized((VoxelShape)voxelShape, (VoxelShape)voxelShape2, (BooleanOp)BooleanOp.OR)).optimize(), VoxelShape::toAabbs);
    public static final StreamCodec<RegistryFriendlyByteBuf, BaseImmutableTemplate> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), (StreamCodec)ByteBufCodecs.VAR_INT), BaseImmutableTemplate::getItemCountMap, (StreamCodec)BlockPos.STREAM_CODEC.map(b -> b, BlockPos::new), BaseImmutableTemplate::getSize, VOXEL_SHAPE_STREAM_CODEC, BaseImmutableTemplate::getShape, BaseImmutableTemplate::new);
    protected final Vec3i size;
    private final Map<Item, Integer> itemCountMap;
    private final List<ItemStack> neededItems;
    private final VoxelShape shape;
    private final int totalNeededItems;

    public BaseImmutableTemplate(Map<Item, Integer> itemCountMap, Vec3i size, VoxelShape shape) {
        this.size = size;
        this.itemCountMap = ImmutableMap.copyOf(itemCountMap);
        this.shape = shape;
        this.neededItems = BlueprintUtil.itemMapToList(itemCountMap);
        this.totalNeededItems = itemCountMap.values().stream().reduce(0, Integer::sum);
    }

    public List<ItemStack> getNeededItems() {
        return this.neededItems;
    }

    private @UnmodifiableView Map<Item, Integer> getItemCountMap() {
        return this.itemCountMap;
    }

    protected int totalNeededItems() {
        return this.totalNeededItems;
    }

    public Vec3i getSize() {
        return this.size;
    }

    public String toString() {
        return "BaseImmutableTemplate{%s Items(%s): %s}".formatted(this.size, this.totalNeededItems, this.itemCountMap);
    }

    public String toShortString() {
        return "BaseImmutableTemplate{%s Items(%s)}".formatted(this.size, this.totalNeededItems);
    }

    public VoxelShape getShape() {
        return this.shape;
    }

    public Optional<ServerBlueprintPlan> createServer() {
        return Optional.empty();
    }

    public Optional<BlueprintPlan> createClient() {
        return Optional.of(new ClientBlueprintPlan(new HashMap<Item, Integer>(this.itemCountMap), this.size));
    }
}

