/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint.templates;

import net.bumblebee.claysoldiers.blueprint.BlueprintRequest;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class BlueprintBlockInfo {
    private static final int MIN_ATTEMPT_TIME = 24000;
    private final BlockPos pos;
    private final BlockState state;
    @Nullable
    private final CompoundTag nbt;
    @Nullable
    private BlueprintRequest lastRequest;

    public BlueprintBlockInfo(BlockPos pos, BlockState state, @Nullable CompoundTag nbt) {
        this.pos = pos;
        this.state = state;
        this.nbt = nbt;
    }

    public static BlueprintBlockInfo fromInfo(StructureTemplate.StructureBlockInfo info) {
        return new BlueprintBlockInfo(info.pos(), info.state(), info.nbt() != null ? info.nbt().copy() : null);
    }

    public boolean isFor(Block block) {
        return this.state.is(block);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockState getState() {
        return this.state;
    }

    @Nullable
    public CompoundTag getNbt() {
        return this.nbt;
    }

    public boolean hasAvailableRequest(long gameTime) {
        return this.lastRequest == null || this.lastRequest.isCancelled() || this.lastRequest.getStart() + 24000L < gameTime;
    }

    public BlueprintRequest getRequest(long gameTime, BlockPos destinationPos) {
        BlueprintRequest req = new BlueprintRequest(this.state.getBlock().asItem(), destinationPos, gameTime);
        if (this.lastRequest != null) {
            this.lastRequest.cancel();
        }
        this.lastRequest = req;
        return req;
    }

    public void markDone() {
        if (this.lastRequest != null) {
            this.lastRequest.setFinished();
        }
    }

    public String toString() {
        return "BlockInfo{%s, %s, [%s]}".formatted(this.pos, this.state, this.lastRequest);
    }
}

