/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint.templates;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.blueprint.templates.ImmutableTemplate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class BlueprintUtil {
    public static final Logger LOGGER = ClaySoldiersCommon.LOGGER;
    private static final FileToIdConverter RESOURCE_LISTER = new FileToIdConverter("structure", ".nbt");

    public static List<ItemStack> itemMapToList(Map<Item, Integer> itemMap) {
        ArrayList<ItemStack> itemsSorted = new ArrayList<ItemStack>(itemMap.size());
        itemMap.forEach((item, count) -> BlueprintUtil.addItemStackToList(itemsSorted, item, count));
        return itemsSorted;
    }

    public static void addItemStackToList(List<ItemStack> itemsCounted, Item item, int count) {
        int maxStackSize = item.getDefaultMaxStackSize();
        if (count <= maxStackSize) {
            itemsCounted.add(new ItemStack((ItemLike)item, count));
        } else {
            itemsCounted.add(new ItemStack((ItemLike)item, maxStackSize));
            BlueprintUtil.addItemStackToList(itemsCounted, item, count - maxStackSize);
        }
    }

    public static Vec3i getSizeFromTag(CompoundTag tag) {
        if (!tag.contains("size")) {
            return Vec3i.ZERO;
        }
        ListTag sizeVec = tag.getList("size", 3);
        return new Vec3i(sizeVec.getInt(0), sizeVec.getInt(1), sizeVec.getInt(2));
    }

    public static <T> Map<Item, Integer> getNeededItemsFromInfo(List<T> blockInfoList, Function<T, BlockState> stateGetter) {
        HashMap<Item, Integer> map = new HashMap<Item, Integer>();
        blockInfoList.stream().map(stateGetter).map(state -> state.getBlock().asItem()).filter(item -> item != Items.AIR).forEach(item -> {
            Integer count = (Integer)map.get(item);
            if (count == null) {
                map.put((Item)item, 1);
            } else {
                count = count + 1;
                map.put((Item)item, count);
            }
        });
        return map;
    }

    public static Function<ResourceLocation, Optional<ImmutableTemplate>> createBlueprintLoader(ResourceManager resourceManager, HolderLookup<Block> blockLookup, Collection<Holder<Block>> blackListedBlocks) {
        return new BlueprintLoader(resourceManager, blockLookup, blackListedBlocks)::loadFromResource;
    }

    private record BlueprintLoader(ResourceManager resourceManager, HolderLookup<Block> blockLookup, Collection<Holder<Block>> blackListedBlocks) {
        public Optional<ImmutableTemplate> loadFromResource(ResourceLocation location) {
            ResourceLocation resourcelocation = RESOURCE_LISTER.idToFile(location);
            return this.load(() -> this.resourceManager.open(resourcelocation), error -> LOGGER.error("CSR: Couldn't load structure {}", (Object)location, error));
        }

        private Optional<ImmutableTemplate> load(InputStreamOpener pInputStream, Consumer<Throwable> pOnError) {
            try {
                Optional<ImmutableTemplate> optional;
                try (InputStream inputstream = pInputStream.open();
                     FastBufferedInputStream inputstream1 = new FastBufferedInputStream(inputstream);){
                    optional = Optional.of(this.readStructure((InputStream)inputstream1));
                }
                return optional;
            }
            catch (FileNotFoundException filenotfoundexception) {
                return Optional.empty();
            }
            catch (Throwable throwable1) {
                pOnError.accept(throwable1);
                return Optional.empty();
            }
        }

        private ImmutableTemplate readStructure(InputStream pStream) throws IOException {
            return ImmutableTemplate.create(this.blockLookup, NbtIo.readCompressed((InputStream)pStream, (NbtAccounter)NbtAccounter.unlimitedHeap()), this.blackListedBlocks);
        }
    }

    public static class SimplePalette
    implements Iterable<BlockState> {
        public static final BlockState DEFAULT_BLOCK_STATE = Blocks.AIR.defaultBlockState();
        private final IdMapper<BlockState> ids = new IdMapper(16);
        private int lastId;

        public int idFor(BlockState pState) {
            int i = this.ids.getId((Object)pState);
            if (i == -1) {
                i = this.lastId++;
                this.ids.addMapping((Object)pState, i);
            }
            return i;
        }

        @Nullable
        public BlockState stateFor(int pId) {
            BlockState blockstate = (BlockState)this.ids.byId(pId);
            return blockstate == null ? DEFAULT_BLOCK_STATE : blockstate;
        }

        @Override
        public Iterator<BlockState> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(BlockState pState, int pId) {
            this.ids.addMapping((Object)pState, pId);
        }
    }

    @FunctionalInterface
    private static interface InputStreamOpener {
        public InputStream open() throws IOException;
    }
}

