/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint.templates;

import java.util.HashMap;
import java.util.Map;
import net.bumblebee.claysoldiers.blueprint.BlueprintTemplateSettings;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintPlan;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintUtil;
import net.bumblebee.claysoldiers.util.ErrorHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ClientBlueprintPlan
extends BlueprintPlan {
    public ClientBlueprintPlan(Map<Item, Integer> itemCountMap, Vec3i size) {
        super(itemCountMap, size);
    }

    public ClientBlueprintPlan(CompoundTag tag) {
        super(new HashMap<Item, Integer>(), BlueprintUtil.getSizeFromTag(tag));
        this.loadItemCount(tag);
        this.loadHasStarted(tag);
    }

    @Override
    public BlueprintPlan.PlaceResult tryPlacing(Level level, ItemStack item, BlockPos base, BlueprintTemplateSettings settings) {
        if (this.hasItemAndShrink(item.getItem())) {
            return BlueprintPlan.PlaceResult.SUCCESS;
        }
        ErrorHandler.INSTANCE.error("Tried to Place an Item for a Blueprint but it is not needed");
        return BlueprintPlan.PlaceResult.NOT_NEEDED;
    }

    public String toString() {
        return "ClientBlueprintTemplate{%s Items(%s): %s}".formatted(this.getSize(), this.getNumberOfItems(), this.getNeededItems());
    }
}

