/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.blueprint.templates;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.bumblebee.claysoldiers.blueprint.templates.BaseImmutableTemplate;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintPlan;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintUtil;
import net.bumblebee.claysoldiers.blueprint.templates.ServerBlueprintPlan;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ImmutableTemplate
extends BaseImmutableTemplate {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<StructureTemplate.StructureBlockInfo> blockInfoList;

    protected ImmutableTemplate(List<StructureTemplate.StructureBlockInfo> blockInfoList, Map<Item, Integer> itemCountMap, Vec3i size, VoxelShape shape) {
        super(itemCountMap, size, shape);
        this.blockInfoList = blockInfoList;
    }

    @Override
    public String toString() {
        return "ImmutableTemplate{%s Blocks(%s): %s}".formatted(this.size, this.blockInfoList.size(), this.blockInfoList);
    }

    @Override
    public String toShortString() {
        return "ImmutableTemplate{%s Items(%s) Blocks(%s)}".formatted(this.size, this.totalNeededItems(), this.blockInfoList.size());
    }

    @Override
    public Optional<ServerBlueprintPlan> createServer() {
        return Optional.of(new ServerBlueprintPlan(this.size, this.blockInfoList));
    }

    @Override
    public Optional<BlueprintPlan> createClient() {
        return Optional.empty();
    }

    public static ImmutableTemplate create(HolderLookup<Block> pBlockGetter, CompoundTag pTag, Collection<Holder<Block>> blackListedBlocks) {
        List<StructureTemplate.StructureBlockInfo> blockInfoList;
        ListTag blockListTag = pTag.getList("blocks", 10);
        if (pTag.contains("palettes", 9)) {
            ListTag palettesListTag = pTag.getList("palettes", 9);
            blockInfoList = ImmutableTemplate.loadPallet(pBlockGetter, palettesListTag.getList(0), blockListTag, blackListedBlocks);
            LOGGER.warn("Clay Soldiers: Structure containing more than one Pallet. Using the first one");
        } else {
            blockInfoList = ImmutableTemplate.loadPallet(pBlockGetter, pTag.getList("palette", 10), blockListTag, blackListedBlocks);
        }
        return new ImmutableTemplate(blockInfoList, BlueprintUtil.getNeededItemsFromInfo(blockInfoList, StructureTemplate.StructureBlockInfo::state), BlueprintUtil.getSizeFromTag(pTag), ImmutableTemplate.buildShape(blockInfoList));
    }

    public static List<StructureTemplate.StructureBlockInfo> loadPallet(HolderLookup<Block> pBlockGetter, ListTag pPaletteTag, ListTag pBlocksTag, Collection<Holder<Block>> blackListedBlocks) {
        BlueprintUtil.SimplePalette structuretemplate$simplepalette = new BlueprintUtil.SimplePalette();
        for (int i = 0; i < pPaletteTag.size(); ++i) {
            structuretemplate$simplepalette.addMapping(NbtUtils.readBlockState(pBlockGetter, (CompoundTag)pPaletteTag.getCompound(i)), i);
        }
        ArrayList normalBlocks = Lists.newArrayList();
        ArrayList blockWithNbt = Lists.newArrayList();
        ArrayList blockWithSpecialShape = Lists.newArrayList();
        for (int j = 0; j < pBlocksTag.size(); ++j) {
            CompoundTag compoundtag = pBlocksTag.getCompound(j);
            ListTag listtag = compoundtag.getList("pos", 3);
            BlockPos blockpos = new BlockPos(listtag.getInt(0), listtag.getInt(1), listtag.getInt(2));
            BlockState blockState = structuretemplate$simplepalette.stateFor(compoundtag.getInt("state"));
            CompoundTag nbt = null;
            if (compoundtag.contains("nbt") && (nbt = compoundtag.getCompound("nbt")).contains("final_state")) {
                String finalState = nbt.getString("final_state");
                try {
                    blockState = BlockStateParser.parseForBlock(pBlockGetter, (String)finalState, (boolean)true).blockState();
                }
                catch (CommandSyntaxException e) {
                    LOGGER.error("Error while parsing BlockState {} in Blueprint, has an invalid final state of {}. ", (Object)blockState, (Object)finalState);
                }
                nbt.remove("final_state");
                if (nbt.isEmpty()) {
                    nbt = null;
                }
            }
            if (blockState == null) {
                LOGGER.error("Error while parsing BlockState in Blueprint");
                continue;
            }
            StructureTemplate.StructureBlockInfo blockInfo = new StructureTemplate.StructureBlockInfo(blockpos, blockState, nbt);
            ImmutableTemplate.addToLists(blockInfo, normalBlocks, blockWithNbt, blockWithSpecialShape, pBlockGetter, blackListedBlocks);
        }
        return ImmutableTemplate.buildInfoList(normalBlocks, blockWithNbt, blockWithSpecialShape);
    }

    private static void addToLists(StructureTemplate.StructureBlockInfo blockInfo, List<StructureTemplate.StructureBlockInfo> pNormalBlocks, List<StructureTemplate.StructureBlockInfo> pBlocksWithNbt, List<StructureTemplate.StructureBlockInfo> pBlocksWithSpecialShape, HolderLookup<Block> lookup, Collection<Holder<Block>> blackListedBlocks) {
        StructureTemplate.StructureBlockInfo updatedBlockInfo = ImmutableTemplate.updateBlockInfo(blockInfo, lookup);
        if (updatedBlockInfo == null) {
            return;
        }
        if (blackListedBlocks.stream().anyMatch(blockHolder -> updatedBlockInfo.state().is(blockHolder))) {
            return;
        }
        if (updatedBlockInfo.nbt() != null) {
            pBlocksWithNbt.add(updatedBlockInfo);
        } else if (!updatedBlockInfo.state().getBlock().hasDynamicShape() && updatedBlockInfo.state().isCollisionShapeFullBlock((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO)) {
            pNormalBlocks.add(updatedBlockInfo);
        } else {
            pBlocksWithSpecialShape.add(updatedBlockInfo);
        }
    }

    @Nullable
    private static StructureTemplate.StructureBlockInfo updateBlockInfo(StructureTemplate.StructureBlockInfo info, HolderLookup<Block> pBlockGetter) {
        return ImmutableTemplate.filterIllegalStates(ImmutableTemplate.setFinalState(info, pBlockGetter));
    }

    private static StructureTemplate.StructureBlockInfo setFinalState(StructureTemplate.StructureBlockInfo info, HolderLookup<Block> pBlockGetter) {
        if (info.nbt() == null) {
            return info;
        }
        String finalState = info.nbt().getString("final_state");
        if (finalState.isEmpty()) {
            return info;
        }
        try {
            return new StructureTemplate.StructureBlockInfo(info.pos(), BlockStateParser.parseForBlock(pBlockGetter, (String)finalState, (boolean)true).blockState(), info.nbt());
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            LOGGER.error("Error while parsing blockstate {} in for original block {}", (Object)finalState, (Object)info.state());
            return info;
        }
    }

    private static VoxelShape buildShape(List<StructureTemplate.StructureBlockInfo> list) {
        return list.stream().map(ImmutableTemplate::shapeFromBlockInfo).reduce(Shapes.empty(), (voxelShape1, voxelShape2) -> Shapes.joinUnoptimized((VoxelShape)voxelShape1, (VoxelShape)voxelShape2, (BooleanOp)BooleanOp.OR)).optimize();
    }

    private static VoxelShape shapeFromBlockInfo(StructureTemplate.StructureBlockInfo blockInfo) {
        BlockState state = blockInfo.state();
        VoxelShape shape = ImmutableTemplate.getShapeFromState(state, blockInfo.pos()).move((double)blockInfo.pos().getX(), (double)blockInfo.pos().getY(), (double)blockInfo.pos().getZ());
        if (state.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) {
            state.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER);
            VoxelShape shapeUpper = ImmutableTemplate.getShapeFromState(state, blockInfo.pos()).move((double)blockInfo.pos().getX(), (double)(blockInfo.pos().getY() + 1), (double)blockInfo.pos().getZ());
            state.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER);
            return Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)shapeUpper, (BooleanOp)BooleanOp.OR);
        }
        if (state.hasProperty((Property)BlockStateProperties.BED_PART)) {
            state.setValue((Property)BlockStateProperties.BED_PART, (Comparable)BedPart.HEAD);
            BlockPos posBedHead = blockInfo.pos().relative((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
            VoxelShape shapeHead = ImmutableTemplate.getShapeFromState(state, blockInfo.pos()).move((double)posBedHead.getX(), (double)posBedHead.getY(), (double)posBedHead.getZ());
            state.setValue((Property)BlockStateProperties.BED_PART, (Comparable)BedPart.FOOT);
            return Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)shapeHead, (BooleanOp)BooleanOp.OR);
        }
        return shape;
    }

    private static VoxelShape getShapeFromState(BlockState state, BlockPos pos) {
        return state.getCollisionShape((BlockGetter)EmptyBlockGetter.INSTANCE, pos, CollisionContext.empty()).singleEncompassing();
    }

    @Nullable
    private static StructureTemplate.StructureBlockInfo filterIllegalStates(StructureTemplate.StructureBlockInfo info) {
        BlockState state = info.state();
        if (ImmutableTemplate.isIllegalSate(state, BlockStateProperties.DOUBLE_BLOCK_HALF, DoubleBlockHalf.UPPER)) {
            return null;
        }
        if (ImmutableTemplate.isIllegalSate(state, BlockStateProperties.BED_PART, BedPart.HEAD)) {
            return null;
        }
        return info;
    }

    private static <T extends Comparable<T>> boolean isIllegalSate(BlockState state, Property<T> property, T when) {
        return when.equals(state.getOptionalValue(property).orElse(null));
    }

    private static List<StructureTemplate.StructureBlockInfo> buildInfoList(List<StructureTemplate.StructureBlockInfo> pNormalBlocks, List<StructureTemplate.StructureBlockInfo> pBlocksWithNbt, List<StructureTemplate.StructureBlockInfo> pBlocksWithSpecialShape) {
        Comparator<StructureTemplate.StructureBlockInfo> comparator = Comparator.comparingInt(p_74641_ -> p_74641_.pos().getY()).thenComparingInt(p_74637_ -> p_74637_.pos().getX()).thenComparingInt(p_74572_ -> p_74572_.pos().getZ());
        pNormalBlocks.sort(comparator);
        pBlocksWithSpecialShape.sort(comparator);
        pBlocksWithNbt.sort(comparator);
        ArrayList<StructureTemplate.StructureBlockInfo> list = new ArrayList<StructureTemplate.StructureBlockInfo>();
        list.addAll(pNormalBlocks);
        list.addAll(pBlocksWithSpecialShape);
        list.addAll(pBlocksWithNbt);
        list = list.stream().filter(blockInfo -> !blockInfo.state().isAir()).toList();
        return list;
    }
}

