/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.cap;

import net.bumblebee.claysoldiers.ConfigNeoForge;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlock;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntity;
import net.bumblebee.claysoldiers.block.hamsterwheel.IHamsterWheelEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class NeoForgeEnergy
extends EnergyStorage
implements IHamsterWheelEnergyStorage {
    private final HamsterWheelBlockEntity blockEntity;
    private final NeoForgeViewOnly viewOnly;
    @Nullable
    private BlockCapabilityCache<IEnergyStorage, Direction> cached;

    public NeoForgeEnergy(HamsterWheelBlockEntity entity) {
        super(ConfigNeoForge.HAMSTER_WHEEL_CAPACITY.getAsInt(), 0, ConfigNeoForge.HAMSTER_WHEEL_CAPACITY.getAsInt(), 0);
        this.blockEntity = entity;
        this.viewOnly = new NeoForgeViewOnly(this);
    }

    @Override
    public void setEnergy(long energy) {
        this.energy = Math.min((int)energy, this.getMaxEnergyStored());
    }

    @Override
    public long energyStored() {
        return this.getEnergyStored();
    }

    @Override
    public long maxEnergyStored() {
        return this.getMaxEnergyStored();
    }

    @Override
    public void generate(float speed) {
        IEnergyStorage storage;
        int generate = this.energy + (int)Math.max(1.0f, (float)((Integer)ConfigNeoForge.HAMSTER_WHEEL_SPEED.get()).intValue() * speed);
        if (generate < 0) {
            generate = Integer.MAX_VALUE;
        }
        this.energy = Math.min(generate, this.getMaxEnergyStored());
        Level level = this.blockEntity.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Direction direction = (Direction)this.blockEntity.getBlockState().getValue(HamsterWheelBlock.FACING);
        if (this.cached == null) {
            this.cached = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)serverLevel, (BlockPos)this.blockEntity.getBlockPos().relative(direction), (Object)direction.getOpposite());
        }
        if ((storage = (IEnergyStorage)this.cached.getCapability()) != null && storage.canReceive()) {
            int amount = this.extractEnergy(this.maxExtract, true);
            this.extractEnergy(storage.receiveEnergy(amount, false), false);
        }
    }

    @Override
    public void save(CompoundTag tag) {
        tag.putInt("wheel_energy", this.energy);
    }

    @Override
    public void load(CompoundTag tag) {
        this.energy = Math.min(tag.getInt("wheel_energy"), this.getMaxEnergyStored());
    }

    public boolean canExtract() {
        return super.canExtract() && this.blockEntity.hasEnergyStorage();
    }

    @Override
    public IHamsterWheelEnergyStorage asViewOnly() {
        return this.viewOnly;
    }

    public int getMaxEnergyStored() {
        return ConfigNeoForge.HAMSTER_WHEEL_CAPACITY.getAsInt() * this.blockEntity.getEnergyCapacityMultiplier();
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        if (!this.canExtract() || toExtract <= 0) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, Math.min(this.getMaxExtract(), toExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    private int getMaxExtract() {
        return ConfigNeoForge.HAMSTER_WHEEL_CAPACITY.getAsInt();
    }

    private record NeoForgeViewOnly(NeoForgeEnergy energyStorage) implements IEnergyStorage,
    IHamsterWheelEnergyStorage
    {
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return this.energyStorage.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return this.energyStorage.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return false;
        }

        @Override
        public long energyStored() {
            return this.getEnergyStored();
        }

        @Override
        public long maxEnergyStored() {
            return this.getMaxEnergyStored();
        }

        @Override
        public void generate(float speed) {
        }

        @Override
        public void save(CompoundTag tag) {
        }

        @Override
        public void load(CompoundTag tag) {
        }

        @Override
        public void setEnergy(long energy) {
            this.energyStorage.setEnergy(energy);
        }

        @Override
        public IHamsterWheelEnergyStorage asViewOnly() {
            return this;
        }
    }
}

