/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.capability;

import net.bumblebee.claysoldiers.capability.ThrowableItemCapability;
import net.bumblebee.claysoldiers.entity.throwables.ClaySoldierThrownPotion;
import net.bumblebee.claysoldiers.item.itemeffectholder.ItemStackWithEffect;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ThrowHealingCapability
implements ThrowableItemCapability {
    @NotNull
    public ThrownPotion createProjectile(Level level, LivingEntity shooter, ItemStackWithEffect holdableEffect) {
        return new ClaySoldierThrownPotion(level, shooter);
    }

    @Override
    public void performRangedAttack(LivingEntity shooter, Level level, LivingEntity pTarget, ItemStackWithEffect holdableEffect, float pVelocity) {
        Vec3 targetMovement = pTarget.getDeltaMovement();
        double potionX = pTarget.getX() + targetMovement.x - shooter.getX();
        double potionY = pTarget.getEyeY() - (double)1.1f - shooter.getY();
        double potionZ = pTarget.getZ() + targetMovement.z - shooter.getZ();
        double distanceTarget = Math.sqrt(potionX * potionX + potionZ * potionZ);
        Holder potion = Potions.REGENERATION;
        if (pTarget.getHealth() <= 4.0f) {
            potion = Potions.HEALING;
        }
        ThrownPotion thrownPotion = this.createProjectile(level, shooter, holdableEffect);
        thrownPotion.setItem(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)potion));
        thrownPotion.setXRot(thrownPotion.getXRot() + 20.0f);
        thrownPotion.shoot(potionX, potionY + distanceTarget * 0.2, potionZ, 0.75f, 8.0f);
        if (!shooter.isSilent()) {
            level.playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), SoundEvents.WITCH_THROW, shooter.getSoundSource(), 1.0f, 0.8f + shooter.getRandom().nextFloat() * 0.4f);
        }
        level.addFreshEntity((Entity)thrownPotion);
    }
}

