/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.capability;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.bumblebee.claysoldiers.capability.ThrowHealingCapability;
import net.bumblebee.claysoldiers.entity.throwables.ClaySoldierSnowball;
import net.bumblebee.claysoldiers.entity.throwables.ClaySoldierThrowableItemEntity;
import net.bumblebee.claysoldiers.item.itemeffectholder.ItemStackWithEffect;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public interface ThrowableItemCapability {
    public static final ThrowableItemCapability DEFAULT = (level, shooter, holdableEffect) -> {
        ClaySoldierThrowableItemEntity pr = new ClaySoldierThrowableItemEntity(level, shooter, holdableEffect);
        pr.setItem(holdableEffect.stack());
        return pr;
    };
    public static final Function<ItemStackWithEffect, ThrowableItemCapability> SNOWBALL = stack -> ClaySoldierSnowball::new;
    public static final Function<ItemStackWithEffect, ThrowableItemCapability> GLISTERING_MELON_SLICE = stack -> new ThrowHealingCapability();
    public static final Map<ItemLike, Function<ItemStackWithEffect, ThrowableItemCapability>> THROWABLE_ITEM_MAP = new HashMap<Item, Function<ItemStackWithEffect, ThrowableItemCapability>>(Map.of(Items.SNOWBALL, SNOWBALL, Items.GLISTERING_MELON_SLICE, GLISTERING_MELON_SLICE));

    @NotNull
    public Projectile createProjectile(Level var1, LivingEntity var2, ItemStackWithEffect var3);

    default public void performRangedAttack(LivingEntity shooter, Level level, LivingEntity pTarget, ItemStackWithEffect holdableEffect, float pVelocity) {
        Projectile projectile = this.createProjectile(level, shooter, holdableEffect);
        double deltaX = pTarget.getX() - shooter.getX();
        double deltaY = pTarget.getY(0.3333333333333333) - projectile.getY();
        double deltaZ = pTarget.getZ() - shooter.getZ();
        projectile.shoot(deltaX, deltaY, deltaZ, pVelocity * 2.0f, 0.0f);
        shooter.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (shooter.getRandom().nextFloat() * 0.4f + 0.8f));
        level.addFreshEntity((Entity)projectile);
    }
}

