/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.claypoifunction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.claypoifunction.ClayPoiFunction;
import net.bumblebee.claysoldiers.claypoifunction.ClayPoiFunctionSerializer;
import net.bumblebee.claysoldiers.claypoifunction.ClayPoiSource;
import net.bumblebee.claysoldiers.claypoifunction.ClaySoldierInventorySetter;
import net.bumblebee.claysoldiers.claypoifunction.ColorGetterFunction;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.AdditionalSoldierData;
import net.bumblebee.claysoldiers.util.EffectHolder;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class ClayPoiFunctions {
    private static final Supplier<ClayPoiFunctionSerializer<EffectFunction>> EFFECT_FUNCTION_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayFunctionSerializer("apply_effect", () -> new ClayPoiFunctionSerializer<EffectFunction>(EffectFunction.CODEC.fieldOf("effect"), EffectFunction.STREAM_CODEC));
    private static final Supplier<ClayPoiFunctionSerializer<SetItem>> SET_ITEM_FUNCTION_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayFunctionSerializer("set_item", () -> new ClayPoiFunctionSerializer<SetItem>(SetItem.CODEC.fieldOf("set_item"), SetItem.STREAM_CODEC));
    private static final Supplier<ClayPoiFunctionSerializer<ConvertTo>> CONVERSION_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayFunctionSerializer("conversion", () -> new ClayPoiFunctionSerializer<ConvertTo>(ConvertTo.CODEC.fieldOf("conversion"), ConvertTo.STREAM_CODEC));
    private static final Supplier<ClayPoiFunctionSerializer<DyeSoldierFunction>> DYE_FUNCTION_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayFunctionSerializer("dye_soldier", () -> new ClayPoiFunctionSerializer<DyeSoldierFunction>(DyeSoldierFunction.CODEC.fieldOf("dye"), DyeSoldierFunction.STREAM_CODEC));
    private static final Supplier<ClayPoiFunctionSerializer<SelectRandom>> SELECT_RANDOM_FUNCTION_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerClayFunctionSerializer("select_random", () -> new ClayPoiFunctionSerializer<SelectRandom>(SelectRandom.CODEC.fieldOf("selection"), SelectRandom.STREAM_CODEC));
    private static final String COMPONENT_PREFIX = "clay_poi_function.csr.";
    public static final String EFFECT_FUNCTION_ADD = "clay_poi_function.csr.effect_function_add";
    public static final String EFFECT_FUNCTION_REMOVE = "clay_poi_function.csr.effect_function_remove";
    public static final String EFFECT_FUNCTION_INCREASE = "clay_poi_function.csr.effect_function_increase";
    public static final String DYE_FUNCTION = "clay_poi_function.csr.dye_function";
    public static final String SET_ITEM_FUNCTION = "clay_poi_function.csr.set_item_function";
    public static final String SET_ITEM_FIND_FUNCTION = "clay_poi_function.csr.set_item_function_find";
    public static final String CONVERSION_FUNCTION = "clay_poi_function.csr.conversion";
    public static final String SELECT_RANDOM_FUNCTION = "clay_poi_function.csr.select_random";

    private ClayPoiFunctions() {
    }

    public static void init() {
    }

    public static class SelectRandom
    extends ClayPoiFunction<SelectRandom> {
        private static final StreamCodec<RegistryFriendlyByteBuf, Map<ClayPoiFunction<?>, Float>> MAP_STREAM_CODEC = ByteBufCodecs.map(HashMap::new, ClayPoiFunction.STREAM_CODEC, (StreamCodec)ByteBufCodecs.FLOAT);
        private static final Codec<SelectRandom> CODEC = ClayPoiFunction.CODEC.listOf().xmap(SelectRandom::new, s -> s.chanceList);
        private static final StreamCodec<RegistryFriendlyByteBuf, SelectRandom> STREAM_CODEC = StreamCodec.composite(ClayPoiFunction.LIST_STREAM_CODEC, s -> s.chanceList, SelectRandom::new);
        private final List<ClayPoiFunction<?>> chanceList;

        private SelectRandom(List<ClayPoiFunction<?>> functions) {
            super(SELECT_RANDOM_FUNCTION_SERIALIZER);
            this.chanceList = functions;
            if (this.chanceList.isEmpty()) {
                throw new IllegalStateException("Chance List cannot be empty");
            }
        }

        private void forEach(Consumer<ClayPoiFunction<?>> apply) {
            this.chanceList.forEach(apply);
        }

        public static SelectRandom allEqual(ClayPoiFunction<?> ... functions) {
            return new SelectRandom(List.of(functions));
        }

        @Override
        public void accept(ClaySoldierInventorySetter soldier, ClayPoiSource source) {
            ((ClayPoiFunction)Util.getRandom(this.chanceList, (RandomSource)soldier.getClaySoldierRandom())).accept(soldier, source);
        }

        @Override
        @Nullable
        public List<Component> getDisplayNameDynamic(Player player) {
            ArrayList<Component> list = new ArrayList<Component>();
            list.add((Component)Component.translatable((String)ClayPoiFunctions.SELECT_RANDOM_FUNCTION));
            this.forEach(func -> func.getDisplayNameDynamic(player).forEach((? super T component) -> list.add((Component)CommonComponents.space().append(component))));
            return list;
        }
    }

    public static class DyeSoldierFunction
    extends ClayPoiFunction<DyeSoldierFunction> {
        public static final Codec<DyeSoldierFunction> CODEC = RecordCodecBuilder.create(in -> in.group((App)Codec.either(ColorHelper.CODEC, ColorGetterFunction.CODEC).fieldOf("color").forGetter(DyeSoldierFunction::getEither), (App)Codec.BOOL.optionalFieldOf("overwrite", (Object)false).forGetter(d -> d.overwrite)).apply((Applicative)in, DyeSoldierFunction::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DyeSoldierFunction> STREAM_CODEC = StreamCodec.composite(ColorHelper.STREAM_CODEC, s -> s.color, ColorGetterFunction.STREAM_CODEC, s -> s.colorGetter, (StreamCodec)ByteBufCodecs.BOOL, s -> s.overwrite, DyeSoldierFunction::new);
        private final ColorHelper color;
        private final ColorGetterFunction colorGetter;
        private final boolean overwrite;

        private DyeSoldierFunction(ColorHelper color, ColorGetterFunction colorGetter, boolean overwrite) {
            super(DYE_FUNCTION_SERIALIZER);
            this.color = color;
            this.colorGetter = colorGetter;
            this.overwrite = overwrite;
        }

        private DyeSoldierFunction(Either<ColorHelper, ColorGetterFunction> either, boolean overwrite) {
            super(DYE_FUNCTION_SERIALIZER);
            this.overwrite = overwrite;
            if (either.left().isPresent()) {
                this.color = (ColorHelper)either.left().get();
                this.colorGetter = ColorGetterFunction.NONE;
            } else {
                this.colorGetter = (ColorGetterFunction)either.right().orElseThrow();
                this.color = ColorHelper.EMPTY;
            }
        }

        public DyeSoldierFunction(ColorGetterFunction colorGetter, boolean overwrite) {
            this(ColorHelper.EMPTY, colorGetter, overwrite);
        }

        public DyeSoldierFunction(int color, boolean overwrite) {
            this(ColorHelper.color(color), ColorGetterFunction.NONE, overwrite);
        }

        public DyeSoldierFunction(ColorHelper color, boolean overwrite) {
            this(color, ColorGetterFunction.NONE, overwrite);
        }

        @Override
        public void accept(ClaySoldierInventorySetter soldier, ClayPoiSource source) {
            ColorHelper currentColor = ColorHelper.color(this.colorGetter.getColor(source));
            if (currentColor.isEmpty()) {
                currentColor = this.color;
            }
            if (this.overwrite) {
                soldier.setOffsetColor(currentColor);
            } else {
                soldier.addOffsetColor(currentColor);
            }
        }

        private Either<ColorHelper, ColorGetterFunction> getEither() {
            if (this.colorGetter != ColorGetterFunction.NONE) {
                return Either.right((Object)this.colorGetter);
            }
            return Either.left((Object)this.color);
        }

        @Override
        @Nullable
        public List<Component> getDisplayNameDynamic(Player player) {
            if (this.colorGetter != ColorGetterFunction.NONE) {
                return List.of(Component.translatable((String)ClayPoiFunctions.DYE_FUNCTION, (Object[])new Object[]{this.colorGetter.getAnimatedDisplayName((LivingEntity)player)}));
            }
            return List.of(Component.translatable((String)ClayPoiFunctions.DYE_FUNCTION, (Object[])new Object[]{this.color.formatDynamic((LivingEntity)player)}));
        }
    }

    public static class ConvertTo
    extends ClayPoiFunction<ConvertTo> {
        private static final Codec<ConvertTo> CODEC = AdditionalSoldierData.CODEC.xmap(d -> new ConvertTo(d.soldierType(), d.tag()), c -> c.data);
        private static final StreamCodec<RegistryFriendlyByteBuf, ConvertTo> STREAM_CODEC = AdditionalSoldierData.STREAM_CODEC.map(d -> new ConvertTo(d.soldierType(), d.tag()), c -> c.data);
        private final AdditionalSoldierData data;

        public <T extends ClayMobEntity> ConvertTo(EntityType<T> soldier, CompoundTag tag) {
            super(CONVERSION_SERIALIZER);
            this.data = new AdditionalSoldierData(soldier, tag);
        }

        @Override
        public void accept(ClaySoldierInventorySetter soldier, ClayPoiSource source) {
            if (soldier instanceof AbstractClaySoldierEntity) {
                Player player;
                AbstractClaySoldierEntity entity = (AbstractClaySoldierEntity)soldier;
                Entity entity2 = source.getOwner();
                this.data.convert(entity, entity2 instanceof Player ? (player = (Player)entity2) : null);
            }
        }

        @Override
        public Component getDisplayName() {
            return Component.translatable((String)ClayPoiFunctions.CONVERSION_FUNCTION, (Object[])new Object[]{this.data.soldierType().getDescription()});
        }

        @Override
        public String toString() {
            return "%s(%s)".formatted(super.toString(), this.data);
        }
    }

    public static class SetItem
    extends ClayPoiFunction<SetItem> {
        public static final Codec<SetItem> CODEC = RecordCodecBuilder.create(in -> in.group((App)ItemStack.OPTIONAL_CODEC.fieldOf("item").forGetter(s -> s.item), (App)SoldierEquipmentSlot.CODEC.optionalFieldOf("slot").forGetter(SetItem::getSlot), (App)SetItemOperation.CODEC.optionalFieldOf("operation", (Object)SetItemOperation.DROP).forGetter(s -> s.operation)).apply((Applicative)in, (item, slot, setItemOperation) -> new SetItem((ItemStack)item, slot.orElse(null), (SetItemOperation)((Object)((Object)setItemOperation)))));
        public static final StreamCodec<RegistryFriendlyByteBuf, SetItem> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, s -> s.item, SoldierEquipmentSlot.OPTIONAL_STREAM_CODEC, s -> Optional.ofNullable(s.slot), SetItemOperation.STREAM_CODEC, s -> s.operation, (stack, slot, op) -> new SetItem((ItemStack)stack, slot.orElse(null), (SetItemOperation)((Object)op)));
        private final ItemStack item;
        @Nullable
        private final SoldierEquipmentSlot slot;
        private final SetItemOperation operation;

        private SetItem(ItemStack item, @Nullable SoldierEquipmentSlot slot, SetItemOperation operation) {
            super(SET_ITEM_FUNCTION_SERIALIZER);
            this.item = item;
            this.slot = slot;
            this.operation = operation;
        }

        private Optional<SoldierEquipmentSlot> getSlot() {
            return Optional.ofNullable(this.slot);
        }

        public static SetItem replace(ItemStack item, @Nullable SoldierEquipmentSlot slot) {
            return new SetItem(item, slot, SetItemOperation.REPLACE);
        }

        public static SetItem drop(ItemStack item, @Nullable SoldierEquipmentSlot slot) {
            return new SetItem(item, slot, SetItemOperation.DROP);
        }

        @Override
        @Nullable
        public Component getDisplayName() {
            if (this.slot == null) {
                return Component.translatable((String)ClayPoiFunctions.SET_ITEM_FIND_FUNCTION, (Object[])new Object[]{this.item.getDisplayName()});
            }
            return Component.translatable((String)ClayPoiFunctions.SET_ITEM_FUNCTION, (Object[])new Object[]{this.item.getDisplayName(), this.slot.getDisplayName()});
        }

        @Override
        public void accept(ClaySoldierInventorySetter soldier, ClayPoiSource ignored) {
            if (this.slot == null) {
                SoldierHoldableEffect effect = ClaySoldiersCommon.DATA_MAP.getEffect(this.item);
                if (effect == null) {
                    ClaySoldiersCommon.LOGGER.error("Set Item in suitable Slot is only supported for items that can be held by soldiers. {} cannot be held.", (Object)this.item.getItem());
                    return;
                }
                for (SoldierEquipmentSlot possibleSlot : effect.slots()) {
                    if (!soldier.setSlotIfEmpty(possibleSlot, this.item)) continue;
                    if (this.operation == SetItemOperation.DROP) {
                        soldier.dropItemSlotWithChance(possibleSlot);
                    }
                    return;
                }
                return;
            }
            if (this.operation == SetItemOperation.DROP) {
                soldier.dropItemSlotWithChance(this.slot);
            }
            soldier.setItemSlot(this.slot, this.item);
        }
    }

    public static class EffectFunction
    extends ClayPoiFunction<EffectFunction>
    implements EffectHolder {
        public static final Codec<EffectFunction> CODEC = RecordCodecBuilder.create(in -> in.group((App)EffectOperation.CODEC.fieldOf("operation").forGetter(ef -> ef.operation)).and(CodecUtils.addEffectAnd()).apply((Applicative)in, EffectFunction::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, EffectFunction> STREAM_CODEC = StreamCodec.composite(EffectOperation.STREAM_CODEC, t -> t.operation, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.MOB_EFFECT), t -> t.effect, (StreamCodec)ByteBufCodecs.VAR_INT, t -> t.duration, (StreamCodec)ByteBufCodecs.VAR_INT, t -> t.amplifier, EffectFunction::new);
        private final EffectOperation operation;
        private final Holder<MobEffect> effect;
        private final int duration;
        private final int amplifier;

        private EffectFunction(EffectOperation operation, Holder<MobEffect> effect, int duration, int amplifier) {
            super(EFFECT_FUNCTION_SERIALIZER);
            this.operation = operation;
            this.effect = effect;
            this.duration = duration;
            this.amplifier = amplifier;
        }

        public static EffectFunction addEffect(Holder<MobEffect> effect, int duration, int amplifier) {
            return new EffectFunction(EffectOperation.ADD, effect, duration, amplifier);
        }

        public static EffectFunction removeEffect(Holder<MobEffect> effect) {
            return new EffectFunction(EffectOperation.REMOVE, effect, 0, 0);
        }

        public static EffectFunction increaseEffect(Holder<MobEffect> effect, int duration, int amplifier) {
            return new EffectFunction(EffectOperation.INCREASE, effect, duration, amplifier);
        }

        @Override
        public void accept(ClaySoldierInventorySetter soldier, ClayPoiSource ignored) {
            this.operation.accept(soldier, new MobEffectInstance(this.effect, this.duration, this.amplifier, false, false));
        }

        @Override
        public int duration() {
            return this.duration;
        }

        @Override
        public int amplifier() {
            return this.amplifier;
        }

        @Override
        public Holder<MobEffect> effectHolder() {
            return this.effect;
        }

        @Override
        @Nullable
        public Component getDisplayName() {
            return switch (this.operation.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Component.translatable((String)ClayPoiFunctions.EFFECT_FUNCTION_ADD, (Object[])new Object[]{((MobEffect)this.effect.value()).getDisplayName(), this.amplifier + 1, this.durationToString()});
                case 2 -> Component.translatable((String)ClayPoiFunctions.EFFECT_FUNCTION_REMOVE, (Object[])new Object[]{((MobEffect)this.effect.value()).getDisplayName()});
                case 1 -> Component.translatable((String)ClayPoiFunctions.EFFECT_FUNCTION_INCREASE, (Object[])new Object[]{((MobEffect)this.effect.value()).getDisplayName(), this.amplifier, this.durationToString()});
            };
        }

        private Component durationToString() {
            if (this.duration == -1 || this.duration > 9999) {
                return Component.literal((String)"forever");
            }
            return Component.literal((String)(this.duration / 20 + "s"));
        }
    }

    private static enum SetItemOperation implements StringRepresentable
    {
        REPLACE("replace"),
        DROP("drop");

        private static final Codec<SetItemOperation> CODEC;
        private static final StreamCodec<FriendlyByteBuf, SetItemOperation> STREAM_CODEC;
        private final String serializedName;

        private SetItemOperation(String serializedName) {
            this.serializedName = serializedName;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(SetItemOperation::values);
            STREAM_CODEC = CodecUtils.createEnumStreamCodec(SetItemOperation.class);
        }
    }

    private static enum EffectOperation implements StringRepresentable
    {
        ADD("add", (soldier, effect) -> soldier.addMobEffect((MobEffectInstance)effect, null)),
        INCREASE("increase", (soldier, effect) -> soldier.increaseEffect((MobEffectInstance)effect, null)),
        REMOVE("remove", (soldier, effect) -> soldier.removeMobEffect((Holder<MobEffect>)effect.getEffect()));

        public static final Codec<EffectOperation> CODEC;
        public static final StreamCodec<FriendlyByteBuf, EffectOperation> STREAM_CODEC;
        private final String serializedNamed;
        private final BiConsumer<ClaySoldierInventorySetter, MobEffectInstance> consumer;

        private EffectOperation(String serializedNamed, BiConsumer<ClaySoldierInventorySetter, MobEffectInstance> consumer) {
            this.serializedNamed = serializedNamed;
            this.consumer = consumer;
        }

        public void accept(ClaySoldierInventorySetter soldier, MobEffectInstance effect) {
            this.consumer.accept(soldier, effect);
        }

        public String getSerializedName() {
            return this.serializedNamed;
        }

        static {
            CODEC = StringRepresentable.fromEnum(EffectOperation::values);
            STREAM_CODEC = CodecUtils.createEnumStreamCodec(EffectOperation.class);
        }
    }
}

