/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.claypoifunction;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public interface ClayPoiSource {
    @Nullable
    public ItemStack getItemStack();

    @Nullable
    default public Entity getOwner() {
        return null;
    }

    @Nullable
    default public Item getItem() {
        return this.getItemStack() != null ? this.getItemStack().getItem() : null;
    }

    default public int getBlockItemMapColor() {
        Item item = this.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItemMapColor = (BlockItem)item;
            return 0xFF000000 | blockItemMapColor.getBlock().defaultMapColor().col;
        }
        return -1;
    }

    default public int getDyeItemColor() {
        Item item = this.getItem();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            return dyeItem.getDyeColor().getTextColor();
        }
        return -1;
    }

    public static ClayPoiSource createSource(ItemStack stack) {
        return () -> stack;
    }

    public static ClayPoiSource createSource(final ItemEntity itemEntity) {
        return new ClayPoiSource(){

            @Override
            public ItemStack getItemStack() {
                return itemEntity.getItem();
            }

            @Override
            @Nullable
            public Entity getOwner() {
                Player player;
                Entity entity = itemEntity.getOwner();
                return entity instanceof Player ? (player = (Player)entity) : null;
            }
        };
    }

    public static ClayPoiSource createSource(final Block block) {
        return new ClayPoiSource(){

            @Override
            @Nullable
            public ItemStack getItemStack() {
                return block.asItem() == Items.AIR ? null : block.asItem().getDefaultInstance();
            }
        };
    }
}

