/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.claypoifunction;

import com.mojang.serialization.Codec;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.claypoifunction.ClayPoiSource;
import net.bumblebee.claysoldiers.soldierproperties.translation.KeyableTranslatableProperty;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;

public enum ColorGetterFunction implements StringRepresentable,
KeyableTranslatableProperty
{
    NONE("none", source -> -1),
    FROM_DYE("from_item", ClayPoiSource::getDyeItemColor),
    FROM_BLOCK_MAP_COLOR("from_block", ClayPoiSource::getBlockItemMapColor);

    public static final Codec<ColorGetterFunction> CODEC;
    public static final StreamCodec<FriendlyByteBuf, ColorGetterFunction> STREAM_CODEC;
    private final String serializedName;
    private final ToIntFunction<ClayPoiSource> colorGetter;

    private ColorGetterFunction(String serializedName, ToIntFunction<ClayPoiSource> colorGetter) {
        this.serializedName = serializedName;
        this.colorGetter = colorGetter;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public int getColor(ClayPoiSource source) {
        return this.colorGetter.applyAsInt(source);
    }

    @Override
    public String translatableKey() {
        return "clay_poi_function.csr.dye_function.color_getter." + this.serializedName;
    }

    static {
        CODEC = StringRepresentable.fromEnum(ColorGetterFunction::values);
        STREAM_CODEC = CodecUtils.createEnumStreamCodec(ColorGetterFunction.class);
    }
}

