/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.clayremovalcondition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalCondition;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalConditionContext;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;

public class OnHurtCondition
extends RemovalCondition {
    public static final String HURT_LANG_KEY = "clay_removal_condition.csr..hurt";
    private final DamageSourcePredicate predicate;
    public static final Codec<OnHurtCondition> CODEC = RecordCodecBuilder.create(in -> in.group((App)DamageSourcePredicate.CODEC.optionalFieldOf("condition", (Object)DamageSourcePredicate.Builder.damageType().build()).forGetter(s -> s.predicate), (App)CHANCE_CODEC.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(RemovalCondition::getChance)).apply((Applicative)in, OnHurtCondition::new));
    public static final StreamCodec<ByteBuf, OnHurtCondition> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)DamageSourcePredicate.CODEC), c -> c.predicate, (StreamCodec)ByteBufCodecs.FLOAT, RemovalCondition::getChance, OnHurtCondition::new);

    public OnHurtCondition(DamageSourcePredicate predicate, float chance) {
        super(chance, RemovalConditionContext.Type.HURT);
        this.predicate = predicate;
    }

    public OnHurtCondition(DamageSourcePredicate.Builder predicate, float chance) {
        this(predicate.build(), chance);
    }

    @Override
    public boolean shouldRemove(AbstractClaySoldierEntity soldier, RemovalConditionContext context) {
        if (this.baseTest(context.getType(), soldier.getRandom())) {
            assert (context.getDamageSource() != null);
            return this.predicate.matches((ServerLevel)soldier.level(), soldier.position(), context.getDamageSource());
        }
        return false;
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)HURT_LANG_KEY);
    }
}

