/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.clayremovalcondition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalCondition;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalConditionContext;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class OnTeleportCondition
extends RemovalCondition {
    private static final Codec<OnTeleportCondition> CODEC_SMALL = RemovalConditionContext.MovementType.CODEC.xmap(t -> new OnTeleportCondition((RemovalConditionContext.MovementType)t, 1.0f), t -> t.teleportationTyp);
    private static final Codec<OnTeleportCondition> CODEC_BIG = RecordCodecBuilder.create(in -> in.group((App)RemovalConditionContext.MovementType.CODEC.fieldOf("teleportation_type").forGetter(t -> t.teleportationTyp), (App)CHANCE_CODEC.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(RemovalCondition::getChance)).apply((Applicative)in, OnTeleportCondition::new));
    public static final Codec<OnTeleportCondition> CODEC = Codec.either(CODEC_SMALL, CODEC_BIG).xmap(either -> {
        if (either.left().isPresent()) {
            return (OnTeleportCondition)either.left().get();
        }
        if (either.right().isPresent()) {
            return (OnTeleportCondition)either.right().get();
        }
        throw new IllegalStateException("No side of Either present");
    }, teleportCondition -> teleportCondition.getChance() == 1.0f ? Either.left((Object)teleportCondition) : Either.right((Object)teleportCondition));
    public static final StreamCodec<FriendlyByteBuf, OnTeleportCondition> STREAM_CODEC = StreamCodec.composite(RemovalConditionContext.MovementType.STREAM_CODEC, t -> t.teleportationTyp, (StreamCodec)ByteBufCodecs.FLOAT, RemovalCondition::getChance, OnTeleportCondition::new);
    public static final String TELEPORTATION_LANG_KEY = "clay_removal_condition.csr..teleportation";
    private final RemovalConditionContext.MovementType teleportationTyp;

    public OnTeleportCondition(RemovalConditionContext.MovementType type, float chance) {
        super(chance, RemovalConditionContext.Type.TELEPORT);
        this.teleportationTyp = type;
    }

    @Override
    public boolean shouldRemove(AbstractClaySoldierEntity soldier, RemovalConditionContext context) {
        return this.baseTest(context.getType(), soldier.getRandom()) && context.getMovementType() == this.teleportationTyp;
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)TELEPORTATION_LANG_KEY, (Object[])new Object[]{this.teleportationTyp.getDisplayName()});
    }
}

