/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.clayremovalcondition;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalCondition;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalConditionContext;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;

public class OnUseCondition
extends RemovalCondition {
    public static final Codec<OnUseCondition> MELEE_CODEC = OnUseCondition.createForType(RemovalConditionContext.Type.MELEE_ATTACK);
    public static final Codec<OnUseCondition> RANGED_CODEC = OnUseCondition.createForType(RemovalConditionContext.Type.RANGED_ATTACK);
    public static final StreamCodec<ByteBuf, OnUseCondition> MELEE_STREAM_CODEC = OnUseCondition.createChacneStreamCodec(OnUseCondition::melee);
    public static final StreamCodec<ByteBuf, OnUseCondition> RANGED_STREAM_CODEC = OnUseCondition.createChacneStreamCodec(OnUseCondition::ranged);
    public static final String MELEE_LANG_KEY = "clay_removal_condition.csr..on_use.melee";
    public static final String RANGED_LANG_KEY = "clay_removal_condition.csr..on_use.ranged";
    public static final String ERROR_LANG_KEY = "clay_removal_condition.csr..on_use.error";

    public static OnUseCondition melee(float chance) {
        return new OnUseCondition(RemovalConditionContext.Type.MELEE_ATTACK, chance);
    }

    public static OnUseCondition ranged(float chance) {
        return new OnUseCondition(RemovalConditionContext.Type.RANGED_ATTACK, chance);
    }

    private OnUseCondition(RemovalConditionContext.Type type, float chance) {
        super(chance, type);
    }

    @Override
    public boolean shouldRemove(AbstractClaySoldierEntity soldier, RemovalConditionContext context) {
        return this.baseTest(context.getType(), soldier.getRandom());
    }

    @Override
    public Component getDisplayName() {
        return switch (this.getType()) {
            case RemovalConditionContext.Type.RANGED_ATTACK -> Component.translatable((String)RANGED_LANG_KEY);
            case RemovalConditionContext.Type.MELEE_ATTACK -> Component.translatable((String)MELEE_LANG_KEY);
            default -> Component.translatable((String)ERROR_LANG_KEY, (Object[])new Object[]{this.getType().getSerializedName()}).withStyle(ChatFormatting.RED);
        };
    }

    private static Codec<OnUseCondition> createForType(RemovalConditionContext.Type type) {
        return CHANCE_CODEC.xmap(chance -> new OnUseCondition(type, chance.floatValue()), RemovalCondition::getChance);
    }
}

