/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.clayremovalcondition;

import com.mojang.serialization.Codec;
import net.bumblebee.claysoldiers.soldierproperties.translation.KeyableTranslatableProperty;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class RemovalConditionContext {
    private final Type type;
    private final ItemStack stack;
    @Nullable
    private final DamageSource sources;
    @Nullable
    private final MovementType movementType;

    public Type getType() {
        return this.type;
    }

    public ItemStack stack() {
        return this.stack;
    }

    @Nullable
    public DamageSource getDamageSource() {
        return this.sources;
    }

    @Nullable
    public MovementType getMovementType() {
        return this.movementType;
    }

    public static RemovalConditionContext useMelee(ItemStack stack) {
        return new RemovalConditionContext(Type.MELEE_ATTACK, stack, null, null);
    }

    public static RemovalConditionContext useRanged(ItemStack stack) {
        return new RemovalConditionContext(Type.RANGED_ATTACK, stack, null, null);
    }

    public static RemovalConditionContext hurt(DamageSource sources, ItemStack stack) {
        return new RemovalConditionContext(Type.HURT, stack, sources, null);
    }

    public static RemovalConditionContext teleportation(ItemStack stack, MovementType movementType) {
        return new RemovalConditionContext(Type.TELEPORT, stack, null, movementType);
    }

    public static RemovalConditionContext fireworkRocket(ItemStack stack) {
        return new RemovalConditionContext(Type.FLIGHT, stack, null, MovementType.TO_SAFETY);
    }

    public static RemovalConditionContext bounce(ItemStack stack) {
        return new RemovalConditionContext(Type.BOUNCE, stack, null, null);
    }

    public RemovalConditionContext(Type type, ItemStack stack, @Nullable DamageSource sources, @Nullable MovementType movementType) {
        this.type = type;
        this.stack = stack;
        this.sources = sources;
        this.movementType = movementType;
    }

    public static enum Type implements StringRepresentable
    {
        RANGED_ATTACK("ranged"),
        MELEE_ATTACK("melee"),
        TELEPORT("teleport"),
        FLIGHT("flight"),
        HURT("hurt"),
        BOUNCE("bounce");

        private final String serializedName;

        private Type(String serializedName) {
            this.serializedName = serializedName;
        }

        public String getSerializedName() {
            return this.serializedName;
        }
    }

    public static enum MovementType implements StringRepresentable,
    KeyableTranslatableProperty
    {
        TO_OWNER("to_owner"),
        TO_TARGET("to_target"),
        TO_SAFETY("to_safety");

        public static final Codec<MovementType> CODEC;
        public static final StreamCodec<FriendlyByteBuf, MovementType> STREAM_CODEC;
        private static final String LANG_PREFIX = "clay_removal_condition.csr.context.";
        private final String serializedName;

        private MovementType(String serializedName) {
            this.serializedName = serializedName;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        @Override
        public String translatableKey() {
            return LANG_PREFIX + this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(MovementType::values);
            STREAM_CODEC = CodecUtils.createEnumStreamCodec(MovementType.class);
        }
    }
}

