/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.clayremovalcondition;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.bumblebee.claysoldiers.clayremovalcondition.OnBounceCondition;
import net.bumblebee.claysoldiers.clayremovalcondition.OnEscapeCondition;
import net.bumblebee.claysoldiers.clayremovalcondition.OnHurtCondition;
import net.bumblebee.claysoldiers.clayremovalcondition.OnTeleportCondition;
import net.bumblebee.claysoldiers.clayremovalcondition.OnUseCondition;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalCondition;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;

public class RemovalConditionType<T extends RemovalCondition>
implements StringRepresentable {
    private static final List<RemovalConditionType<?>> TYPES = new ArrayList();
    public static final RemovalConditionType<OnHurtCondition> ON_HURT = new RemovalConditionType<OnHurtCondition>("on_hurt", OnHurtCondition.CODEC, OnHurtCondition.STREAM_CODEC.cast());
    public static final RemovalConditionType<OnUseCondition> ON_USE_MELEE = new RemovalConditionType<OnUseCondition>("melee_use", OnUseCondition.MELEE_CODEC, OnUseCondition.MELEE_STREAM_CODEC.cast());
    public static final RemovalConditionType<OnUseCondition> ON_USE_RANGED = new RemovalConditionType<OnUseCondition>("ranged_use", OnUseCondition.RANGED_CODEC, OnUseCondition.RANGED_STREAM_CODEC.cast());
    public static final RemovalConditionType<OnTeleportCondition> ON_TELEPORT = new RemovalConditionType<OnTeleportCondition>("on_teleport", OnTeleportCondition.CODEC, OnTeleportCondition.STREAM_CODEC);
    public static final RemovalConditionType<OnEscapeCondition> ON_ESCAPE = new RemovalConditionType<OnEscapeCondition>("on_escape", OnEscapeCondition.CODEC, OnEscapeCondition.STREAM_CODEC.cast());
    public static final RemovalConditionType<OnBounceCondition> ON_BOUNCE = new RemovalConditionType<OnBounceCondition>("on_bounce", OnBounceCondition.CODEC, OnBounceCondition.STREAM_CODEC.cast());
    private static final Codec<RemovalConditionType<?>> CODEC = StringRepresentable.fromValues(RemovalConditionType::values);
    public static final Codec<Map<RemovalConditionType<?>, RemovalCondition>> PAIR_CODEC = Codec.dispatchedMap(CODEC, s -> s.contextCodec);
    private static final StreamCodec<FriendlyByteBuf, RemovalConditionType<?>> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, RemovalConditionType<?>>(){

        public RemovalConditionType<?> decode(FriendlyByteBuf byteBuf) {
            return TYPES.get(byteBuf.readByte());
        }

        public void encode(FriendlyByteBuf o, RemovalConditionType<?> removalConditionType) {
            o.writeByte(TYPES.indexOf(removalConditionType));
        }
    };
    public static final StreamCodec<FriendlyByteBuf, Map<RemovalConditionType<?>, RemovalCondition>> PAIR_STREAM_CODEC = new StreamCodec<FriendlyByteBuf, Map<RemovalConditionType<?>, RemovalCondition>>(){

        public Map<RemovalConditionType<?>, RemovalCondition> decode(FriendlyByteBuf byteBuf) {
            int i = ByteBufCodecs.readCount((ByteBuf)byteBuf, (int)Integer.MAX_VALUE);
            HashMap m = new HashMap(Math.min(i, 65536));
            for (int j = 0; j < i; ++j) {
                RemovalConditionType key = (RemovalConditionType)STREAM_CODEC.decode((Object)byteBuf);
                RemovalCondition value = (RemovalCondition)key.streamCodec.decode((Object)byteBuf);
                m.put(key, value);
            }
            return m;
        }

        public void encode(FriendlyByteBuf byteBuf, Map<RemovalConditionType<?>, RemovalCondition> map) {
            ByteBufCodecs.writeCount((ByteBuf)byteBuf, (int)map.size(), (int)Integer.MAX_VALUE);
            map.forEach((key, value) -> {
                STREAM_CODEC.encode((Object)byteBuf, key);
                key.encode(byteBuf, (RemovalCondition)value);
            });
        }
    };
    private final String serializedName;
    private final Codec<T> contextCodec;
    private final StreamCodec<FriendlyByteBuf, T> streamCodec;

    private RemovalConditionType(String serializedName, Codec<T> contextCodec, StreamCodec<FriendlyByteBuf, T> streamCodec) {
        this.serializedName = serializedName;
        this.contextCodec = contextCodec;
        this.streamCodec = streamCodec;
        TYPES.add(this);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemovalConditionType that = (RemovalConditionType)o;
        return Objects.equals(this.serializedName, that.serializedName);
    }

    public int hashCode() {
        return Objects.hashCode(this.serializedName);
    }

    private void encode(FriendlyByteBuf byteBuf, RemovalCondition condition) {
        try {
            this.streamCodec.encode((Object)byteBuf, (Object)condition);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("%s cannot be encoded for %s".formatted(condition, this.serializedName), e);
        }
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    private static RemovalConditionType<?>[] values() {
        return (RemovalConditionType[])TYPES.toArray(RemovalConditionType[]::new);
    }
}

