/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.commands;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.ResourceLocationException;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public abstract class DefaultedResourceLocationArgument
implements ArgumentType<ResourceLocation> {
    private static final Collection<String> EXAMPLES = List.of("foo:bar", "zee");
    public static final String INVALID_RESOURCE_LOCATION = "argument.csr.resource_location.invalid";
    public static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(string -> Component.translatableEscape((String)INVALID_RESOURCE_LOCATION, (Object[])new Object[]{string}));

    public static AllClayMobTeam all(CommandBuildContext context) {
        return new AllClayMobTeam(context);
    }

    public static SoldierItemType itemType(CommandBuildContext context) {
        return new SoldierItemType(context);
    }

    public static ResourceLocation key(String key, CommandContext<CommandSourceStack> context) {
        return (ResourceLocation)context.getArgument(key, ResourceLocation.class);
    }

    protected abstract boolean isValid(ResourceLocation var1);

    public ResourceLocation parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation res = DefaultedResourceLocationArgument.read(reader);
        if (!this.isValid(res)) {
            throw ERROR_INVALID_VALUE.create((Object)res.toString());
        }
        return res;
    }

    private static ResourceLocation read(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        String s = DefaultedResourceLocationArgument.readGreedy(reader);
        try {
            return CodecUtils.parse(s);
        }
        catch (ResourceLocationException resourcelocationexception) {
            reader.setCursor(i);
            throw ResourceLocation.ERROR_INVALID.createWithContext((ImmutableStringReader)reader);
        }
    }

    private static String readGreedy(StringReader reader) {
        int i = reader.getCursor();
        while (reader.canRead() && ResourceLocation.isAllowedInResourceLocation((char)reader.peek())) {
            reader.skip();
        }
        return reader.getString().substring(i, reader.getCursor());
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public abstract <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var1, SuggestionsBuilder var2);

    public static class AllClayMobTeam
    extends DefaultedResourceLocationArgument {
        private final HolderLookup<ClayMobTeam> registryLookup;

        public AllClayMobTeam(CommandBuildContext context) {
            this.registryLookup = context.lookupOrThrow(ModRegistries.CLAY_MOB_TEAMS);
        }

        @Override
        protected boolean isValid(ResourceLocation key) {
            return this.registryLookup.get(ResourceKey.create(ModRegistries.CLAY_MOB_TEAMS, (ResourceLocation)key)).isPresent();
        }

        @Override
        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return SharedSuggestionProvider.suggestResource(this.registryLookup.listElementIds().map(ResourceKey::location), (SuggestionsBuilder)builder);
        }
    }

    public static class SoldierItemType
    extends DefaultedResourceLocationArgument {
        private final CommandBuildContext context;

        public SoldierItemType(CommandBuildContext context) {
            this.context = context;
        }

        @Override
        protected boolean isValid(ResourceLocation key) {
            Optional registryLookup = this.context.lookup(ModRegistries.SOLDIER_ITEM_TYPES);
            if (registryLookup.isEmpty()) {
                return true;
            }
            return ((HolderLookup.RegistryLookup)registryLookup.orElseThrow()).get(ResourceKey.create(ModRegistries.SOLDIER_ITEM_TYPES, (ResourceLocation)key)).isPresent();
        }

        @Override
        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            CompletableFuture completableFuture;
            Object object = context.getSource();
            if (object instanceof SharedSuggestionProvider) {
                SharedSuggestionProvider sharedsuggestionprovider = (SharedSuggestionProvider)object;
                completableFuture = sharedsuggestionprovider.suggestRegistryElements(ModRegistries.SOLDIER_ITEM_TYPES, SharedSuggestionProvider.ElementSuggestionType.ELEMENTS, builder, context);
            } else {
                completableFuture = builder.buildFuture();
            }
            return completableFuture;
        }
    }
}

