/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.ClaySoldiersNeoForge;
import net.bumblebee.claysoldiers.datagen.ModDataMapAndTagProvider;
import net.bumblebee.claysoldiers.datagen.ModDataMapProvider;
import net.bumblebee.claysoldiers.datagen.ModDatapackProvider;
import net.bumblebee.claysoldiers.datagen.ModLangProvider;
import net.bumblebee.claysoldiers.datagen.ModLoottableProvider;
import net.bumblebee.claysoldiers.datagen.ModModelProvider;
import net.bumblebee.claysoldiers.datagen.ModParticleProvider;
import net.bumblebee.claysoldiers.datagen.ModRecipeProvider;
import net.bumblebee.claysoldiers.datagen.advancements.ModAdvancements;
import net.bumblebee.claysoldiers.datagen.advancements.ModBlueprintAdvancementProvider;
import net.bumblebee.claysoldiers.datagen.tags.ModBlockTagsProvider;
import net.bumblebee.claysoldiers.datagen.tags.ModItemTagProvider;
import net.bumblebee.claysoldiers.datagen.tags.ModTagProvider;
import net.bumblebee.claysoldiers.init.ModArmorMaterials;
import net.bumblebee.claysoldiers.integration.curios.ModCuriosDataProvider;
import net.minecraft.DetectedVersion;
import net.minecraft.client.data.models.EquipmentAssetProvider;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataGenerators {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"CSR DataGeneration");

    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        PackOutput neoforge = new PackOutput(Path.of(packOutput.getOutputFolder().toString().replace("common", "neoforge"), new String[0]));
        PackOutput fabric = new PackOutput(Path.of(packOutput.getOutputFolder().toString().replace("common", "fabric"), new String[0]));
        LOGGER.info("Common PackOut: {}", (Object)packOutput.getOutputFolder());
        LOGGER.info("Fabric PackOut: {}", (Object)fabric.getOutputFolder());
        LOGGER.info("NeoForge PackOut: {}", (Object)neoforge.getOutputFolder());
        CompletableFuture lookupProvider = event.getLookupProvider();
        event.createProvider(ModDatapackProvider::builtin);
        ModTagProvider.getTagProviders().forEach(arg_0 -> ((GatherDataEvent.Client)event).createProvider(arg_0));
        event.createBlockAndItemTags(ModBlockTagsProvider::new, ModItemTagProvider::new);
        event.createProvider(ModLoottableProvider::new);
        event.createProvider(ModRecipeProvider.Runner::new);
        event.createProvider(ModModelProvider::new);
        event.createProvider(ModLangProvider::new);
        event.createProvider(ModParticleProvider::new);
        event.addProvider((DataProvider)new EquipmentAssetProvider(packOutput){

            protected void registerModels(BiConsumer<ResourceKey<EquipmentAsset>, EquipmentClientInfo> output) {
                output.accept(ModArmorMaterials.CLAY_GOGGLES_ID, EquipmentClientInfo.builder().addMainHumanoidLayer(ModArmorMaterials.CLAY_GOGGLES_ID.location(), false).build());
            }
        });
        event.createProvider((p, l) -> new AdvancementProvider(p, l, List.of(new ModAdvancements())));
        event.addProvider((DataProvider)new ModCuriosDataProvider(neoforge, lookupProvider));
        DataGenerator.PackGenerator featurePack = generator.getBuiltinDatapack(true, "csr", "blueprint_pack");
        PackOutput neoBlueprintPackOut = new PackOutput(neoforge.getOutputFolder(PackOutput.Target.DATA_PACK).resolve("csr").resolve("datapacks").resolve("blueprint_pack"));
        featurePack.addProvider(packOut -> PackMetadataGenerator.forFeaturePack((PackOutput)neoBlueprintPackOut, (Component)Component.translatable((String)ClaySoldiersCommon.BLUEPRINT_PACK_DESCRIPTION), (FeatureFlagSet)FeatureFlagSet.of((FeatureFlag)ClaySoldiersNeoForge.BLUEPRINT_FLAG)));
        event.addProvider((DataProvider)new ModBlueprintAdvancementProvider("NeoForge", neoBlueprintPackOut, lookupProvider));
        PackOutput fabricBluePrintPackOut = new PackOutput(fabric.getOutputFolder().resolve("data/datapacks").resolve("blueprint_pack"));
        event.addProvider((DataProvider)new PackMetadataGenerator(fabricBluePrintPackOut).add(PackMetadataSection.TYPE, (Object)new PackMetadataSection((Component)Component.translatable((String)ClaySoldiersCommon.BLUEPRINT_PACK_DESCRIPTION), DetectedVersion.BUILT_IN.getPackVersion(PackType.SERVER_DATA))));
        event.addProvider((DataProvider)new ModBlueprintAdvancementProvider("Fabric", fabricBluePrintPackOut, lookupProvider));
        DataGenerators.itemsDataPack(packOutput.getOutputFolder(), event);
    }

    private static void itemsDataPack(Path output, GatherDataEvent.Client event) {
        PackOutput path = new PackOutput(output.resolve("data/datapacks").resolve("csr_default_datapack"));
        CompletableFuture lookupProvider = event.getLookupProvider();
        event.addProvider((DataProvider)new CustomPackMetadataProvider(path).add(PackMetadataSection.TYPE, new PackMetadataSection((Component)Component.translatable((String)ClaySoldiersCommon.CSR_DEFAULT_PACK_DESCRIPTION), DetectedVersion.BUILT_IN.getPackVersion(PackType.SERVER_DATA))));
        event.addProvider((DataProvider)ModDatapackProvider.datapack(path, lookupProvider));
        event.addProvider((DataProvider)new ModDataMapAndTagProvider(path, lookupProvider));
        event.addProvider((DataProvider)new ModDataMapProvider(path, lookupProvider));
    }

    private static class CustomPackMetadataProvider
    implements DataProvider {
        private final PackOutput output;
        private final Map<String, Supplier<JsonElement>> elements = new HashMap<String, Supplier<JsonElement>>();

        public CustomPackMetadataProvider(PackOutput output) {
            this.output = output;
        }

        public <T> CustomPackMetadataProvider add(MetadataSectionType<T> type, T value) {
            this.elements.put(type.name(), () -> (JsonElement)type.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, value).ifError(err -> LOGGER.error("Error encoding PackMetadata for {}: {}", (Object)this.output.getOutputFolder(), (Object)err.message())).result().orElseThrow());
            return this;
        }

        public CompletableFuture<?> run(CachedOutput output) {
            JsonObject jsonobject = new JsonObject();
            this.elements.forEach((p_249290_, p_251317_) -> jsonobject.add(p_249290_, (JsonElement)p_251317_.get()));
            return DataProvider.saveStable((CachedOutput)output, (JsonElement)jsonobject, (Path)this.output.getOutputFolder().resolve("pack.mcmeta"));
        }

        public String getName() {
            return "Custom Pack Metadata";
        }
    }
}

