/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datagen;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.bumblebee.claysoldiers.claypoifunction.ClayPoiFunctions;
import net.bumblebee.claysoldiers.claypoifunction.ColorGetterFunction;
import net.bumblebee.claysoldiers.clayremovalcondition.OnEscapeCondition;
import net.bumblebee.claysoldiers.clayremovalcondition.OnHurtCondition;
import net.bumblebee.claysoldiers.clayremovalcondition.OnTeleportCondition;
import net.bumblebee.claysoldiers.clayremovalcondition.OnUseCondition;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalConditionContext;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalConditionType;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClayPredicates;
import net.bumblebee.claysoldiers.datagen.api.ClaySoldiersItemProvider;
import net.bumblebee.claysoldiers.datamap.DropRateProperty;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.datamap.SoldierPickUpPriority;
import net.bumblebee.claysoldiers.datamap.armor.SoldierMultiWearable;
import net.bumblebee.claysoldiers.datamap.armor.SoldierWearableBuilder;
import net.bumblebee.claysoldiers.datamap.armor.accessories.SoldierAccessorySlot;
import net.bumblebee.claysoldiers.datamap.armor.accessories.custom.CapeRenderable;
import net.bumblebee.claysoldiers.datamap.armor.accessories.custom.GliderRenderable;
import net.bumblebee.claysoldiers.datamap.armor.accessories.custom.ShieldRenderable;
import net.bumblebee.claysoldiers.datamap.armor.accessories.custom.SkullRenderable;
import net.bumblebee.claysoldiers.datamap.armor.accessories.custom.SnorkelRenderable;
import net.bumblebee.claysoldiers.datamap.armor.accessories.custom.StringRenderLayer;
import net.bumblebee.claysoldiers.entity.ClayWraithEntity;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModBossBehaviours;
import net.bumblebee.claysoldiers.init.ModEffects;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.soldieritemtypes.DefaultSoldierItemTypes;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoi;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMap;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.DeathCloudProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.IEvacuationProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.RangedAttackType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.WraithProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.effectimmunity.EffectImmunityType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttackType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttacks;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.item.equipment.trim.TrimPatterns;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class ModDataMapAndTagProvider
extends ClaySoldiersItemProvider {
    private static final CompoundTag VAMPIRE_TAG = new CompoundTag();
    private static final CompoundTag ZOMBIE_TAG = new CompoundTag();
    private static final CompoundTag CLAY_WRAITH_TAG = new CompoundTag();
    private static final CompoundTag DEFAULT_BOSS_TAG = new CompoundTag();
    private static final CompoundTag VAMPIRE_BOSS_TAG = new CompoundTag();
    private static final CompoundTag ZOMBIE_BOSS_TAG = new CompoundTag();

    public ModDataMapAndTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider, "csr");
    }

    @Override
    protected void gather() {
        this.tag(ModTags.Items.CLAY_HORSE_ARMOR).add((Object[])new Item[]{Items.DIAMOND, Items.GOLD_INGOT, Items.IRON_INGOT, Items.LEATHER});
        this.tag(ModTags.Items.SOLDIER_THROWABLE).add((Object[])new Item[]{Items.SNOWBALL, Items.GRAVEL, Items.SLIME_BALL, Items.FIRE_CHARGE});
        this.addHoldable((ItemLike)Items.STICK, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setDamage(2.0f)).setSlot(SoldierEquipmentSlot.MAINHAND).build(), ClaySoldiersItemProvider.TagType.WEAPON, DefaultSoldierItemTypes.BASIC);
        this.addHoldable((ItemLike)ModItems.SHARPENED_STICK.get(), SoldierHoldableEffect.of(SoldierPropertyMap.builder().setDamage(3.0f)).setSlot(SoldierEquipmentSlot.MAINHAND).build(), ClaySoldiersItemProvider.TagType.WEAPON, DefaultSoldierItemTypes.BASIC);
        this.addHoldable((ItemLike)Items.BONE, new SoldierHoldableEffect(SoldierPropertyMap.builder().setDamage(1.0f).bonusAttackRange(0.1f), SoldierEquipmentSlot.MAINHAND), ClaySoldiersItemProvider.TagType.WEAPON, DefaultSoldierItemTypes.BASIC);
        this.addHoldable((ItemLike)Items.BLAZE_ROD, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setDamage(1.5f).setSetOnFire(20)).setSlot(SoldierEquipmentSlot.MAINHAND).setPickUpPriority(SoldierPickUpPriority.HIGH).build(), ClaySoldiersItemProvider.TagType.WEAPON, DefaultSoldierItemTypes.BASIC, DefaultSoldierItemTypes.ARSONIST);
        this.addHoldable((TagKey<Item>)ItemTags.COALS, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setSetOnFire(20)).setSlots(SoldierEquipmentSlot.BACKPACK_SLOTS).setPredicate(new ClayPredicates.SoldierPropertyPredicate(ClayPredicates.PropertyTestType.INCREASE, SoldierPropertyTypes.SET_ON_FIRE.get())).build(), DefaultSoldierItemTypes.ARSONIST);
        this.addHoldable((ItemLike)Items.SHEARS, SoldierHoldableEffect.of(SoldierPropertyMap.builder()).setSlots(SoldierEquipmentSlot.CUSTOM_EQUIP).setPickUpPriority(SoldierPickUpPriority.HIGH).build(), ClaySoldiersItemProvider.TagType.WEAPON, DefaultSoldierItemTypes.BASIC);
        this.addHoldable((ItemLike)ModItems.SHEAR_BLADE.get(), SoldierHoldableEffect.of(SoldierPropertyMap.builder().setDamage(1.25f).addSpecialAttack(new SpecialAttacks.SneakAttack(SpecialAttackType.MELEE, 0.5f))).setSlots(SoldierEquipmentSlot.HANDS).setPickUpPriority(SoldierPickUpPriority.LOW).build(), ClaySoldiersItemProvider.TagType.WEAPON, new ClaySoldiersItemProvider.ItemTagHolder[0]);
        this.addHoldable((ItemLike)Items.SNOWBALL, SoldierHoldableEffect.of(SoldierPropertyMap.builder().throwable(RangedAttackType.HARM, 2.0f).addSpecialAttack(new SpecialAttacks.EffectAttack(SpecialAttackType.RANGED, 0.0f, (Holder<MobEffect>)MobEffects.MOVEMENT_SLOWDOWN, 400, 0))).setSlot(SoldierEquipmentSlot.BACKPACK).setPickUpPriority(SoldierPickUpPriority.LOW).setMaxStackSize(8).removalCondition(RemovalConditionType.ON_USE_RANGED, OnUseCondition.ranged(1.0f)).build(), DefaultSoldierItemTypes.BASIC, DefaultSoldierItemTypes.RANGED);
        this.addHoldable((ItemLike)Items.FIRE_CHARGE, SoldierHoldableEffect.of(SoldierPropertyMap.builder().throwable(RangedAttackType.HARM, 2.0f).setSetOnFire(45)).setSlot(SoldierEquipmentSlot.BACKPACK).setPickUpPriority(SoldierPickUpPriority.HIGH).removalCondition(RemovalConditionType.ON_USE_RANGED, OnUseCondition.ranged(1.0f)).setMaxStackSize(6).build(), DefaultSoldierItemTypes.RANGED, DefaultSoldierItemTypes.ARSONIST);
        this.addHoldable((ItemLike)Items.SLIME_BALL, SoldierHoldableEffect.of(SoldierPropertyMap.builder().throwable(RangedAttackType.HARM, 2.0f).addSpecialAttack(new SpecialAttacks.EffectAttack(SpecialAttackType.RANGED, 0.0f, ModEffects.SLIME_ROOT, 20, 1))).setSlot(SoldierEquipmentSlot.BACKPACK).setPickUpPriority(SoldierPickUpPriority.HIGH).removalCondition(RemovalConditionType.ON_USE_RANGED, OnUseCondition.ranged(1.0f)).setMaxStackSize(6).build(), DefaultSoldierItemTypes.RANGED, DefaultSoldierItemTypes.SPECIALIST);
        this.addHoldable((ItemLike)Items.GRAVEL, SoldierHoldableEffect.of(SoldierPropertyMap.builder().addSpecialAttack(new SpecialAttacks.CritAttack(SpecialAttackType.RANGED, 1.0f, 0.5f)).throwable(RangedAttackType.HARM, 1.0f)).setSlot(SoldierEquipmentSlot.BACKPACK).removalCondition(RemovalConditionType.ON_USE_RANGED, OnUseCondition.ranged(1.0f)).setMaxStackSize(4).build(), ClaySoldiersItemProvider.TagType.HOLDABLE, DefaultSoldierItemTypes.BASIC, DefaultSoldierItemTypes.RANGED);
        this.addHoldable((ItemLike)Items.GLASS_BOTTLE, new SoldierHoldableEffect(SoldierPropertyMap.builder().setBreathHold(10), SoldierEquipmentSlot.BACKPACK, SoldierPickUpPriority.LOW), DefaultSoldierItemTypes.DIVER, DefaultSoldierItemTypes.SPECIALIST);
        this.addHoldable((ItemLike)Items.SUGAR, SoldierHoldableEffect.of(SoldierPropertyMap.builder().addAttribute((Holder<Attribute>)Attributes.MOVEMENT_SPEED, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"sugar_speed"), 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL))).setSlots(SoldierEquipmentSlot.BACKPACK_SLOTS).setPickUpPriority(SoldierPickUpPriority.LOW).build(), DefaultSoldierItemTypes.SPECIALIST);
        this.addHoldable((ItemLike)Items.GUNPOWDER, SoldierHoldableEffect.of(SoldierPropertyMap.builder().explosion(1.0f)).setSlots(SoldierEquipmentSlot.BACKPACK_SLOTS).build(), DefaultSoldierItemTypes.ARSONIST);
        this.addHoldable((ItemLike)Items.TNT, SoldierHoldableEffect.of(SoldierPropertyMap.builder().explosion(2.0f)).setSlots(SoldierEquipmentSlot.BACKPACK_SLOTS).setPickUpPriority(SoldierPickUpPriority.HIGH).build(), DefaultSoldierItemTypes.ARSONIST);
        this.addHoldable((ItemLike)Items.MAGMA_CREAM, SoldierHoldableEffect.of(SoldierPropertyMap.builder().explosion(1.0f).addSpecialAttack(new SpecialAttacks.CritAttack(SpecialAttackType.MELEE, 1.0f, 0.5f))).setSlots(SoldierEquipmentSlot.BACKPACK_SLOTS).setPickUpPriority(SoldierPickUpPriority.HIGH).build(), DefaultSoldierItemTypes.ARSONIST);
        this.addHoldable((ItemLike)Items.POISONOUS_POTATO, SoldierHoldableEffect.of(SoldierPropertyMap.builder().addSpecialAttack(new SpecialAttacks.EffectAttack(SpecialAttackType.MELEE, 0.0f, (Holder<MobEffect>)MobEffects.POISON, 30, 1)).immunity((Holder<MobEffect>)MobEffects.POISON, EffectImmunityType.IMMUNE).addDeathCloudEffect(new DeathCloudProperty((Holder<MobEffect>)MobEffects.POISON, 1, 30))).setSlots(SoldierEquipmentSlot.BACKPACK_SLOTS).build(), DefaultSoldierItemTypes.ARSONIST, DefaultSoldierItemTypes.MAGICIAN);
        this.addHoldable((ItemLike)Items.EMERALD, SoldierHoldableEffect.of(SoldierPropertyMap.builder().addSpecialAttack(new SpecialAttacks.LightningAttack(SpecialAttackType.MELEE, 1.0f))).setSlot(SoldierEquipmentSlot.BACKPACK).build(), DefaultSoldierItemTypes.SPECIALIST, DefaultSoldierItemTypes.MAGICIAN);
        this.addHoldable((ItemLike)Items.REDSTONE, SoldierHoldableEffect.of(SoldierPropertyMap.builder().addSpecialAttack(new SpecialAttacks.EffectAttack(SpecialAttackType.MELEE_AND_RANGED, 0.0f, (Holder<MobEffect>)MobEffects.BLINDNESS, 30, 1))).setSlot(SoldierEquipmentSlot.BACKPACK_PASSIVE).setPredicate(ClayPredicates.LogicPredicate.any(Set.of(new ClayPredicates.ItemPredicate(ItemStack.EMPTY.getItem(), SoldierEquipmentSlot.MAINHAND), new ClayPredicates.ItemPredicate(Items.AIR, SoldierEquipmentSlot.OFFHAND)))).build(), DefaultSoldierItemTypes.SPECIALIST);
        this.addHoldable((ItemLike)Items.NETHER_STAR, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setDamage(2.0f).addSpecialAttack(new SpecialAttacks.CritAttack(SpecialAttackType.MELEE, 1.0f, 0.5f)).size(2.0f).addAttribute((Holder<Attribute>)Attributes.MOVEMENT_SPEED, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"giant_slow"), (double)-0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)).addAttribute((Holder<Attribute>)Attributes.MAX_HEALTH, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"giant_health"), 10.0, AttributeModifier.Operation.ADD_VALUE))).setSlots(SoldierEquipmentSlot.BACKPACK_SLOTS).setPickUpPriority(SoldierPickUpPriority.VERY_HIGH).setDropRate(DropRateProperty.NEVER).build(), DefaultSoldierItemTypes.TANK);
        this.addHoldable((ItemLike)Items.AMETHYST_SHARD, SoldierHoldableEffect.of(SoldierPropertyMap.builder().invisible()).setSlots(SoldierEquipmentSlot.BACKPACK_SLOTS).addPickUpEffect(new ClayPoiFunctions.DyeSoldierFunction(8339378, false)).build(), DefaultSoldierItemTypes.MAGICIAN);
        this.addHoldable((ItemLike)Items.GLOWSTONE_DUST, SoldierHoldableEffect.of(SoldierPropertyMap.builder().glowing()).setSlots(SoldierEquipmentSlot.BACKPACK_SLOTS).setPickUpPriority(SoldierPickUpPriority.LOW).build(), DefaultSoldierItemTypes.MAGICIAN);
        this.addHoldable((ItemLike)Items.GLOW_INK_SAC, SoldierHoldableEffect.of(SoldierPropertyMap.builder().glowing()).setSlots(SoldierEquipmentSlot.BACKPACK_SLOTS).setPickUpPriority(SoldierPickUpPriority.LOW).build(), DefaultSoldierItemTypes.MAGICIAN);
        this.addHoldable((ItemLike)Items.DRAGON_BREATH, SoldierHoldableEffect.of(SoldierPropertyMap.builder().canReviveOther(new ReviveProperty(ReviveType.WRAITH, 0, 0.75f, 10))).setSlot(SoldierEquipmentSlot.BACKPACK).build(), DefaultSoldierItemTypes.MAGICIAN);
        this.addHoldable((ItemLike)Items.GOLDEN_APPLE, SoldierHoldableEffect.of(SoldierPropertyMap.builder().canReviveOther(new ReviveProperty(ReviveType.MEDIC, 3, 1.0f, 100)).attackType(AttackTypeProperty.SUPPORT).addSpecialAttack(new SpecialAttacks.EffectAttack(SpecialAttackType.MELEE, 0.0f, (Holder<MobEffect>)MobEffects.REGENERATION, 600, 2))).setSlot(SoldierEquipmentSlot.BACKPACK).setPickUpPriority(SoldierPickUpPriority.VERY_HIGH).build(), DefaultSoldierItemTypes.HEALER);
        this.addHoldable((ItemLike)Items.TOTEM_OF_UNDYING, new SoldierHoldableEffect(SoldierPropertyMap.builder().canReviveOther(new ReviveProperty(ReviveType.ANGEL, 4, 1.0f, 2000)).addSpecialAttack(new SpecialAttacks.Smite(SpecialAttackType.MELEE_AND_RANGED, 3.0f)), SoldierEquipmentSlot.BACKPACK_PASSIVE, SoldierPickUpPriority.VERY_HIGH), DefaultSoldierItemTypes.HEALER, DefaultSoldierItemTypes.MAGICIAN);
        this.addHoldable((ItemLike)Items.ECHO_SHARD, SoldierHoldableEffect.of(SoldierPropertyMap.builder().wraith(new WraithProperty(6, 0.0f, List.of(new SpecialAttacks.Smite(SpecialAttackType.MELEE, 1.0f)))).setSeeInvis()).addPickUpEffect(new ClayPoiFunctions.DyeSoldierFunction(213328, true)).setSlots(SoldierEquipmentSlot.BACKPACK_SLOTS).build(), DefaultSoldierItemTypes.MAGICIAN);
        this.addHoldable((ItemLike)Items.FERMENTED_SPIDER_EYE, new SoldierHoldableEffect(SoldierPropertyMap.builder().attackType(AttackTypeProperty.AGGRESSIVE), SoldierEquipmentSlot.BACKPACK_PASSIVE, SoldierPickUpPriority.VERY_HIGH), new ClaySoldiersItemProvider.ItemTagHolder[0]);
        this.addHoldable((ItemLike)Items.WHEAT, SoldierHoldableEffect.of(SoldierPropertyMap.builder().attackType(AttackTypeProperty.PACIFIST).setBreakingPower(2)).setSlot(SoldierEquipmentSlot.BACKPACK_PASSIVE).setPickUpPriority(SoldierPickUpPriority.VERY_HIGH).build(), new ClaySoldiersItemProvider.ItemTagHolder[0]);
        this.addHoldable((ItemLike)Items.GLISTERING_MELON_SLICE, SoldierHoldableEffect.of(SoldierPropertyMap.builder().throwable(RangedAttackType.HELPING).attackType(AttackTypeProperty.SUPPORT)).setSlot(SoldierEquipmentSlot.BACKPACK_PASSIVE).setPickUpPriority(SoldierPickUpPriority.VERY_HIGH).build(), DefaultSoldierItemTypes.HEALER);
        this.addHoldable((ItemLike)Items.ENDER_PEARL, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setTeleportingToOwner().setCanSwim()).setDropRate(DropRateProperty.NEVER).setSlot(SoldierEquipmentSlot.BACKPACK).setPickUpPriority(SoldierPickUpPriority.HIGH).build(), new ClaySoldiersItemProvider.ItemTagHolder[0]);
        this.addHoldable((ItemLike)Items.CHORUS_FRUIT, SoldierHoldableEffect.of(SoldierPropertyMap.builder().allowTeleporting().size(0.9f)).addPickUpEffect(new ClayPoiFunctions.DyeSoldierFunction(9332621, true)).setSlots(SoldierEquipmentSlot.BACKPACK_SLOTS).removalCondition(RemovalConditionType.ON_TELEPORT, new OnTeleportCondition(RemovalConditionContext.MovementType.TO_TARGET, 0.2f)).build(), DefaultSoldierItemTypes.MAGICIAN);
        this.addHoldable((ItemLike)Items.FIREWORK_ROCKET, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setEvacuation(IEvacuationProperty.FIREWORK)).removalCondition(RemovalConditionType.ON_ESCAPE, new OnEscapeCondition(1.0f)).setSlots(SoldierEquipmentSlot.BACKPACK_SLOTS).build(), DefaultSoldierItemTypes.ARSONIST, DefaultSoldierItemTypes.SPECIALIST);
        this.addHoldable((ItemLike)Items.FIREWORK_STAR, SoldierHoldableEffect.of(SoldierPropertyMap.builder()).setSlots(SoldierEquipmentSlot.BACKPACK_SLOTS).setPickUpPriority(SoldierPickUpPriority.LOW).setDropRate(DropRateProperty.NEVER).build(), new ClaySoldiersItemProvider.ItemTagHolder[0]);
        this.addWearable((ItemLike)Items.LILY_PAD, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setProtection(2.0f).setCanSwim()).setSlot(SoldierEquipmentSlot.LEGS).setPredicate(ClayPredicates.LogicPredicate.not(new ClayPredicates.SoldierPropertyPredicate(ClayPredicates.PropertyTestType.INCREASE, SoldierPropertyTypes.HEAVY.get()))).build(), SoldierWearableBuilder.armor((ArmorItem)Items.IRON_LEGGINGS).color(2129968).build(), DefaultSoldierItemTypes.ARMORED, DefaultSoldierItemTypes.DIVER);
        this.addWearable((ItemLike)Items.RED_MUSHROOM, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setProtection(1.0f).immunity((Holder<MobEffect>)MobEffects.POISON, EffectImmunityType.IMMUNE)).setSlot(SoldierEquipmentSlot.HEAD).build(), SoldierMultiWearable.accessory(SoldierAccessorySlot.HEAD_ITEM, new SkullRenderable(Items.RED_MUSHROOM_BLOCK)), DefaultSoldierItemTypes.ARMORED, DefaultSoldierItemTypes.SPECIALIST);
        this.addWearable((ItemLike)Items.LEATHER, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setProtection(3.0f)).setSlot(SoldierEquipmentSlot.CHEST).setPickUpPriority(SoldierPickUpPriority.LOW).build(), SoldierWearableBuilder.armor((ArmorItem)Items.LEATHER_CHESTPLATE).color(-6265536).affectedOffsetColor().build(), DefaultSoldierItemTypes.ARMORED);
        this.addWearable((ItemLike)Items.GLASS_PANE, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setProtection(1.0f).setSeeInvis()).setSlot(SoldierEquipmentSlot.HEAD).build(), SoldierWearableBuilder.empty().addTrim((ResourceKey<TrimPattern>)TrimPatterns.EYE, (ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ).addTrim((ResourceKey<TrimPattern>)TrimPatterns.SPIRE, (ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE).build(), DefaultSoldierItemTypes.SPECIALIST, DefaultSoldierItemTypes.ARMORED, DefaultSoldierItemTypes.FASHION);
        this.addWearable(ModTags.Items.SOLDIER_RGB_GLASSES, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setProtection(1.0f).setSeeInvis()).setSlot(SoldierEquipmentSlot.HEAD).build(), SoldierMultiWearable.of().put(SoldierEquipmentSlot.HEAD, SoldierWearableBuilder.empty().addTrim((ResourceKey<TrimPattern>)TrimPatterns.EYE, (ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, ColorHelper.jeb()).addTrim((ResourceKey<TrimPattern>)TrimPatterns.SPIRE, (ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE).build()).build(), DefaultSoldierItemTypes.FASHION);
        this.addWearable((ItemLike)Items.PAPER, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setProtection(0.1f)).setSlot(SoldierEquipmentSlot.CAPE).setDropRate(DropRateProperty.NEVER).build(), SoldierMultiWearable.of().put(SoldierAccessorySlot.CAPE, new CapeRenderable(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"textures/entity/clay_soldier/paper_cape.png"))).build(), DefaultSoldierItemTypes.FASHION, DefaultSoldierItemTypes.ARMORED);
        this.addWearable((ItemLike)Items.BAMBOO, SoldierHoldableEffect.of(SoldierPropertyMap.builder().infiniteBreathHold()).setSlot(SoldierEquipmentSlot.HEAD).build(), SoldierMultiWearable.of().put(SoldierAccessorySlot.SNORKEL, new SnorkelRenderable(SnorkelRenderable.BAMBOO_STICK_TEXTURE)).build(), DefaultSoldierItemTypes.DIVER);
        this.addWearable((ItemLike)Items.BRICK, SoldierHoldableEffect.of(SoldierPropertyMap.builder().noBreathHold().setProtection(10.0f).heavy(5.0f).addAttribute((Holder<Attribute>)Attributes.MOVEMENT_SPEED, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"brick_armor_slow"), (double)-0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL))).setSlot(SoldierEquipmentSlot.CHEST).setPickUpPriority(SoldierPickUpPriority.HIGH).build(), SoldierWearableBuilder.armor((ArmorItem)Items.NETHERITE_CHESTPLATE).color(11031355).build(), DefaultSoldierItemTypes.ARMORED, DefaultSoldierItemTypes.TANK);
        this.addWearable((ItemLike)Items.TURTLE_SCUTE, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setBreathHold(30).setProtection(2.0f)).setSlot(SoldierEquipmentSlot.HEAD).build(), SoldierWearableBuilder.armor((ArmorItem)Items.TURTLE_HELMET).build(), DefaultSoldierItemTypes.ARMORED, DefaultSoldierItemTypes.DIVER);
        this.addWearable((ItemLike)Items.SLIME_BLOCK, SoldierHoldableEffect.of(SoldierPropertyMap.builder().canBounce()).setSlot(SoldierEquipmentSlot.FEET).build(), SoldierWearableBuilder.armor((ArmorItem)Items.IRON_BOOTS).color(7845224).build(), DefaultSoldierItemTypes.ARMORED, DefaultSoldierItemTypes.SPECIALIST);
        this.addWearable((ItemLike)Items.GOLD_INGOT, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setProtection(1.5f).size(1.25f).attackType(AttackTypeProperty.KING)).setSlot(SoldierEquipmentSlot.HEAD).setPickUpPriority(SoldierPickUpPriority.VERY_HIGH).setDropRate(DropRateProperty.NEVER).build(), SoldierWearableBuilder.armor((ArmorItem)Items.GOLDEN_HELMET).addTrim((ResourceKey<TrimPattern>)TrimPatterns.SHAPER, (ResourceKey<TrimMaterial>)TrimMaterials.LAPIS).build(), DefaultSoldierItemTypes.ROYALTY);
        this.addWearable((ItemLike)Items.GOLD_BLOCK, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setProtection(2.0f).addSpecialAttack(new SpecialAttacks.CritAttack(SpecialAttackType.MELEE, 1.0f, 0.75f)).size(1.1f)).setSlots(SoldierEquipmentSlot.CUSTOM_EQUIP).setPickUpPriority(SoldierPickUpPriority.VERY_HIGH).setDropRate(DropRateProperty.NEVER).build(), SoldierMultiWearable.single(SoldierEquipmentSlot.CHEST, SoldierWearableBuilder.armor((ArmorItem)Items.CHAINMAIL_CHESTPLATE).addTrim((ResourceKey<TrimPattern>)TrimPatterns.SHAPER, (ResourceKey<TrimMaterial>)TrimMaterials.GOLD).addTrim((ResourceKey<TrimPattern>)TrimPatterns.VEX, (ResourceKey<TrimMaterial>)TrimMaterials.GOLD).build()), new ClaySoldiersItemProvider.ItemTagHolder[0]);
        this.addWearable((ItemLike)Items.DIAMOND, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setProtection(1.5f).size(1.1f).attackType(AttackTypeProperty.QUEEN)).setSlot(SoldierEquipmentSlot.HEAD).setPickUpPriority(SoldierPickUpPriority.VERY_HIGH).setDropRate(DropRateProperty.NEVER).build(), SoldierWearableBuilder.empty().addTrim((ResourceKey<TrimPattern>)TrimPatterns.HOST, (ResourceKey<TrimMaterial>)TrimMaterials.EMERALD).addTrim((ResourceKey<TrimPattern>)TrimPatterns.WAYFINDER, (ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND).build(), DefaultSoldierItemTypes.ROYALTY);
        this.addWearable((ItemLike)Items.DIAMOND_BLOCK, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setProtection(1.0f).addSpecialAttack(new SpecialAttacks.CritAttack(SpecialAttackType.MELEE, 1.0f, 0.5f)).size(1.1f)).setSlots(SoldierEquipmentSlot.CUSTOM_EQUIP).setPickUpPriority(SoldierPickUpPriority.VERY_HIGH).setDropRate(DropRateProperty.NEVER).build(), SoldierMultiWearable.single(SoldierEquipmentSlot.CHEST, SoldierWearableBuilder.empty().addTrim((ResourceKey<TrimPattern>)TrimPatterns.SHAPER, (ResourceKey<TrimMaterial>)TrimMaterials.EMERALD).addTrim((ResourceKey<TrimPattern>)TrimPatterns.VEX, (ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND).build()), new ClaySoldiersItemProvider.ItemTagHolder[0]);
        this.addWearable((ItemLike)Items.CACTUS, SoldierHoldableEffect.of(SoldierPropertyMap.builder().addCounterAttack(new SpecialAttacks.Thorns(SpecialAttackType.MELEE_AND_RANGED, 1.0f)).setProtection(1.0f)).setSlot(SoldierEquipmentSlot.CHEST).build(), SoldierWearableBuilder.armor((ArmorItem)Items.NETHERITE_CHESTPLATE).color(6592562).addTrim((ResourceKey<TrimPattern>)TrimPatterns.RIB, (ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE).build(), DefaultSoldierItemTypes.ARMORED, DefaultSoldierItemTypes.TANK);
        this.addWearable((ItemLike)Items.STRING, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setExplosionResistance(24.0f)).setMaxStackSize(2).removalCondition(RemovalConditionType.ON_HURT, new OnHurtCondition(DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.IS_EXPLOSION)), 0.5f)).setSlots(SoldierEquipmentSlot.BACKPACK_SLOTS).build(), SoldierMultiWearable.of().put(SoldierAccessorySlot.STRING, new StringRenderLayer()).build(), DefaultSoldierItemTypes.ARMORED, DefaultSoldierItemTypes.SPECIALIST);
        this.addWearable((ItemLike)Items.FEATHER, SoldierHoldableEffect.of(SoldierPropertyMap.builder().allowGliding()).setSlots(SoldierEquipmentSlot.BACKPACK_SLOTS).build(), SoldierMultiWearable.of().put(SoldierAccessorySlot.GLIDER, new GliderRenderable(Items.FEATHER)).build(), DefaultSoldierItemTypes.SPECIALIST);
        this.addWearable((ItemLike)Items.RABBIT_HIDE, SoldierHoldableEffect.of(SoldierPropertyMap.builder().allowGliding()).setSlots(SoldierEquipmentSlot.BACKPACK_SLOTS).build(), SoldierMultiWearable.of().put(SoldierAccessorySlot.GLIDER, new GliderRenderable(Items.RABBIT_HIDE)).build(), DefaultSoldierItemTypes.SPECIALIST);
        this.addWearable((ItemLike)Items.SKELETON_SKULL, SoldierHoldableEffect.of(SoldierPropertyMap.builder().canReviveOther(new ReviveProperty(ReviveType.NECROTIC, 1, 0.5f, 20))).setSlot(SoldierEquipmentSlot.HEAD).setPickUpPriority(SoldierPickUpPriority.VERY_HIGH).build(), SoldierMultiWearable.of().put(SoldierAccessorySlot.HEAD_ITEM, new SkullRenderable(Items.SKELETON_SKULL)).build(), DefaultSoldierItemTypes.MAGICIAN);
        this.addWearable((ItemLike)Items.WITHER_SKELETON_SKULL, SoldierHoldableEffect.of(SoldierPropertyMap.builder().canReviveOther(new ReviveProperty(ReviveType.DARK_NECROTIC, 2, 0.5f, 80)).addSpecialAttack(new SpecialAttacks.CritAttack(SpecialAttackType.MELEE, 1.0f, 0.5f)).addDeathCloudEffect(new DeathCloudProperty((Holder<MobEffect>)MobEffects.WITHER, 0, 10)).immunity((Holder<MobEffect>)MobEffects.WITHER, EffectImmunityType.IMMUNE)).setSlot(SoldierEquipmentSlot.HEAD).setDropRate(DropRateProperty.NORMAL).setPickUpPriority(SoldierPickUpPriority.VERY_HIGH).addPickUpEffect(ClayPoiFunctions.SetItem.drop(Items.COAL_BLOCK.getDefaultInstance(), SoldierEquipmentSlot.FEET)).addPickUpEffect(ClayPoiFunctions.SetItem.drop(Items.COAL_BLOCK.getDefaultInstance(), SoldierEquipmentSlot.LEGS)).addPickUpEffect(ClayPoiFunctions.SetItem.drop(Items.COAL_BLOCK.getDefaultInstance(), SoldierEquipmentSlot.CHEST)).build(), SoldierMultiWearable.of().put(SoldierAccessorySlot.HEAD_ITEM, new SkullRenderable(Items.WITHER_SKELETON_SKULL)).build(), DefaultSoldierItemTypes.MAGICIAN);
        this.addWearable((ItemLike)Items.COAL_BLOCK, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setProtection(2.0f)).setSlots(SoldierEquipmentSlot.NO_SLOT).setPickUpPriority(SoldierPickUpPriority.VERY_HIGH).setDropRate(DropRateProperty.NEVER).build(), SoldierMultiWearable.of().put(SoldierEquipmentSlot.CHEST, SoldierWearableBuilder.armor((ArmorItem)Items.LEATHER_CHESTPLATE).color(0x1D1D21).build()).put(SoldierEquipmentSlot.LEGS, SoldierWearableBuilder.armor((ArmorItem)Items.LEATHER_LEGGINGS).color(0x1D1D21).build()).put(SoldierEquipmentSlot.FEET, SoldierWearableBuilder.armor((ArmorItem)Items.LEATHER_BOOTS).color(0x1D1D21).build()).build(), new ClaySoldiersItemProvider.ItemTagHolder[0]);
        this.addWearable((ItemLike)Items.BOWL, SoldierHoldableEffect.of(SoldierPropertyMap.builder().damageBlock(0.5f, 2.0f)).setSlots(SoldierEquipmentSlot.HANDS).build(), SoldierMultiWearable.of().put(SoldierAccessorySlot.SHIELD, new ShieldRenderable(ShieldRenderable.SHIELD_TEXTURE)).build(), DefaultSoldierItemTypes.TANK, DefaultSoldierItemTypes.BASIC);
        this.addWearable((ItemLike)Items.IRON_NUGGET, SoldierHoldableEffect.of(SoldierPropertyMap.builder().damageBlock(0.5f, 3.0f).addCounterAttack(new SpecialAttacks.Thorns(SpecialAttackType.MELEE, 1.0f))).setSlots(SoldierEquipmentSlot.CUSTOM_EQUIP).build(), SoldierMultiWearable.of().put(SoldierAccessorySlot.SHIELD, new ShieldRenderable(ShieldRenderable.STUDDED_SHIELD_TEXTURE)).build(), DefaultSoldierItemTypes.TANK);
        this.addWearable((ItemLike)Items.COMMAND_BLOCK, SoldierHoldableEffect.of(SoldierPropertyMap.builder().heavy(5.0f).size(1.4f).setDamage(10.0f).glowing().glowOutline().setProtection(25.0f).explosion(2.0f).attackType(AttackTypeProperty.AGGRESSIVE).addDeathCloudEffect(new DeathCloudProperty((Holder<MobEffect>)MobEffects.HARM, 5, 1)).infiniteBreathHold().setCanSwim().setSetOnFire(20).addSpecialAttack(new SpecialAttacks.SneakAttack(SpecialAttackType.MELEE_AND_RANGED, 2.0f)).addSpecialAttack(new SpecialAttacks.LightningAttack(SpecialAttackType.MELEE_AND_RANGED, 1.0f)).addSpecialAttack(new SpecialAttacks.CritAttack(SpecialAttackType.MELEE_AND_RANGED, 7.0f, 0.5f)).addCounterAttack(new SpecialAttacks.Thorns(SpecialAttackType.MELEE_AND_RANGED, 2.0f)).damageBlock(0.5f, 2.0f, false).immunity((Holder<MobEffect>)MobEffects.POISON, EffectImmunityType.IMMUNE).immunity((Holder<MobEffect>)MobEffects.WITHER, EffectImmunityType.IMMUNE).immunity((Holder<MobEffect>)MobEffects.WEAKNESS, EffectImmunityType.IMMUNE).immunity((Holder<MobEffect>)MobEffects.BLINDNESS, EffectImmunityType.IMMUNE).immunity((Holder<MobEffect>)MobEffects.REGENERATION, EffectImmunityType.PERSISTENT).wraith(new WraithProperty(13, 3.5f, List.of(new SpecialAttacks.LightningAttack(SpecialAttackType.MELEE, 1.0f), new SpecialAttacks.CritAttack(SpecialAttackType.MELEE, 7.0f, 0.5f)))).addAttribute((Holder<Attribute>)Attributes.MAX_HEALTH, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"soldier_com_health"), 30.0, AttributeModifier.Operation.ADD_VALUE))).setDropRate(DropRateProperty.NEVER).addPickUpEffect(ClayPoiFunctions.EffectFunction.addEffect((Holder<MobEffect>)MobEffects.REGENERATION, 300, 3)).addPickUpEffect(ClayPoiFunctions.EffectFunction.addEffect((Holder<MobEffect>)MobEffects.REGENERATION, 100000, 0)).addPickUpEffect(new ClayPoiFunctions.DyeSoldierFunction(ColorHelper.jeb(), false)).setSlot(SoldierEquipmentSlot.HEAD).setPickUpPriority(SoldierPickUpPriority.VERY_HIGH).build(), SoldierMultiWearable.of().put(SoldierAccessorySlot.HEAD_ITEM, new SkullRenderable(Items.COMMAND_BLOCK)).build(), new ClaySoldiersItemProvider.ItemTagHolder[0]);
        this.addHoldable((ItemLike)Items.DEBUG_STICK, SoldierHoldableEffect.of(SoldierPropertyMap.builder().setDamage(25.0f).setSetOnFire(80).setSeeInvis().bonusAttackRange(0.2f).attackType(AttackTypeProperty.AGGRESSIVE).addSpecialAttack(new SpecialAttacks.CritAttack(SpecialAttackType.MELEE, 25.0f, 0.25f))).setPickUpPriority(SoldierPickUpPriority.VERY_HIGH).setDropRate(DropRateProperty.NEVER).setSlots(SoldierEquipmentSlot.HANDS).build(), ClaySoldiersItemProvider.TagType.WEAPON, new ClaySoldiersItemProvider.ItemTagHolder[0]);
        this.addSoldierItemPoi((ItemLike)Items.FLINT, new SoldierPoi(ClayPoiFunctions.SetItem.replace(ModItems.SHARPENED_STICK.get().getDefaultInstance(), SoldierEquipmentSlot.MAINHAND), new ClayPredicates.ItemPredicate(Items.STICK, SoldierEquipmentSlot.MAINHAND), 0.15f));
        this.addSoldierItemPoi((ItemLike)Items.HONEY_BOTTLE, new SoldierPoi(ClayPoiFunctions.EffectFunction.removeEffect((Holder<MobEffect>)MobEffects.POISON), new ClayPredicates.EffectPredicate((Holder<MobEffect>)MobEffects.POISON), 0.1f));
        this.addSoldierItemPoi((ItemLike)Items.HEART_OF_THE_SEA, new SoldierPoi(ClayPoiFunctions.EffectFunction.addEffect((Holder<MobEffect>)MobEffects.CONDUIT_POWER, 360, 0), ClayPredicates.LogicPredicate.not(new ClayPredicates.EffectPredicate((Holder<MobEffect>)MobEffects.CONDUIT_POWER)), 0.0f));
        this.addSoldierItemPoi(ModTags.Items.DYES, new SoldierPoi(new ClayPoiFunctions.DyeSoldierFunction(ColorGetterFunction.FROM_DYE, true), ClayPredicates.LogicPredicate.not(ClayPredicates.ConstantPredicate.getHasCustomColor()), 0.0f));
        this.addSoldierItemPoi((ItemLike)Items.NETHER_WART, new SoldierPoi(new ClayPoiFunctions.ConvertTo(ModEntityTypes.VAMPIRE_CLAY_SOLDIER_ENTITY.get(), VAMPIRE_TAG), ClayPredicates.LogicPredicate.not(ClayPredicates.SoldierPropertyPredicate.isExactly(SoldierPropertyTypes.ATTACK_TYPE.get(), AttackTypeProperty.VAMPIRE)), 1.0f));
        this.addSoldierItemPoi((ItemLike)Items.ROTTEN_FLESH, new SoldierPoi(new ClayPoiFunctions.ConvertTo(ModEntityTypes.ZOMBIE_CLAY_SOLDIER_ENTITY.get(), ZOMBIE_TAG), ClayPredicates.LogicPredicate.not(ClayPredicates.SoldierPropertyPredicate.isExactly(SoldierPropertyTypes.ATTACK_TYPE.get(), AttackTypeProperty.ZOMBIE)), 1.0f));
        this.addSoldierBlockPoi(Blocks.END_ROD, new SoldierPoi(new ClayPoiFunctions.ConvertTo(ModEntityTypes.CLAY_WRAITH.get(), CLAY_WRAITH_TAG), ClayPredicates.ConstantPredicate.getAlwaysTruePredicate(), 0.0f));
        this.addSoldierItemPoi((ItemLike)Items.BOOK, new SoldierPoi(ClayPoiFunctions.SetItem.drop(Items.PAPER.getDefaultInstance(), null), ClayPredicates.ItemPredicate.suitable(Items.PAPER), 0.05f));
        this.addSoldierItemPoi((ItemLike)Items.EGG, new SoldierPoi(List.of(ClayPoiFunctions.SelectRandom.allEqual(new ClayPoiFunctions.ConvertTo(ModEntityTypes.BOSS_CLAY_SOLDIER_ENTITY.get(), DEFAULT_BOSS_TAG), new ClayPoiFunctions.ConvertTo(ModEntityTypes.BOSS_CLAY_SOLDIER_ENTITY.get(), VAMPIRE_BOSS_TAG), new ClayPoiFunctions.ConvertTo(ModEntityTypes.BOSS_CLAY_SOLDIER_ENTITY.get(), ZOMBIE_BOSS_TAG), ClayPoiFunctions.EffectFunction.addEffect((Holder<MobEffect>)MobEffects.WITHER, 340, 9), ClayPoiFunctions.EffectFunction.addEffect((Holder<MobEffect>)MobEffects.POISON, 340, 2))), ClayPredicates.ConstantPredicate.getAlwaysTruePredicate(), 1.0f));
    }

    static {
        VAMPIRE_TAG.putBoolean("Alpha", true);
        ZOMBIE_TAG.putBoolean("Curable", false);
        ZOMBIE_TAG.putBoolean("PickUpItems", true);
        ZOMBIE_TAG.putBoolean("match_teams", true);
        CLAY_WRAITH_TAG.putInt("LifeTicks", 120);
        ClayWraithEntity.writeSpecialAttackToTag(CLAY_WRAITH_TAG, List.of(new SpecialAttacks.LightningAttack(SpecialAttackType.MELEE, 2.0f)));
        BossClaySoldierEntity.writeBossAIToTag(ModBossBehaviours.VAMPIRE.get(), VAMPIRE_BOSS_TAG);
        BossClaySoldierEntity.writeBasePropertiesToTag(SoldierPropertyMap.of(SoldierPropertyTypes.SIZE.get().createProperty(Float.valueOf(5.0f)), SoldierPropertyTypes.ATTACK_RANGE.get().createProperty(Float.valueOf(1.0f))), VAMPIRE_BOSS_TAG);
        BossClaySoldierEntity.writeBossAIToTag(ModBossBehaviours.DEFAULT.get(), DEFAULT_BOSS_TAG);
        BossClaySoldierEntity.writeBasePropertiesToTag(SoldierPropertyMap.of(SoldierPropertyTypes.SIZE.get().createProperty(Float.valueOf(4.0f)), SoldierPropertyTypes.ATTACK_RANGE.get().createProperty(Float.valueOf(1.0f))), DEFAULT_BOSS_TAG);
        BossClaySoldierEntity.writeBossAIToTag(ModBossBehaviours.ZOMBIE.get(), ZOMBIE_BOSS_TAG);
        BossClaySoldierEntity.writeBasePropertiesToTag(SoldierPropertyMap.of(SoldierPropertyTypes.SIZE.get().createProperty(Float.valueOf(3.5f)), SoldierPropertyTypes.ATTACK_RANGE.get().createProperty(Float.valueOf(1.0f))), ZOMBIE_BOSS_TAG);
    }
}

