/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datagen;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.bumblebee.claysoldiers.datagen.api.BootstrapHelper;
import net.bumblebee.claysoldiers.init.ModDamageTypes;
import net.bumblebee.claysoldiers.init.ModEnchantments;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.soldieritemtypes.DefaultSoldierItemTypes;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMap;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;

public class ModDatapackProvider
extends DatapackBuiltinEntriesProvider {
    public static final RegistrySetBuilder BUILDER = new RegistrySetBuilder();
    public static final RegistrySetBuilder BUILDER_BUILTIN = new RegistrySetBuilder();
    public static final String LANGUAGE_PREFIX = "clay_soldier_blueprint.data_name.";
    public static final String SMALL_HOUSE_LANG = "clay_soldier_blueprint.data_name.small_house";
    public static final String SMALL_FARM_LANG = "clay_soldier_blueprint.data_name.small_farm";
    public static final String LARGE_HOUSE_LANG = "clay_soldier_blueprint.data_name.large_house";
    private final String name;

    public ModDatapackProvider(PackOutput output, RegistrySetBuilder builder, CompletableFuture<HolderLookup.Provider> registries, String name) {
        super(output, registries, builder, Collections.singleton("csr"));
        this.name = name;
    }

    public String getName() {
        return super.getName() + this.name;
    }

    public static ModDatapackProvider builtin(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        return new ModDatapackProvider(output, BUILDER_BUILTIN, registries, "builtin");
    }

    public static ModDatapackProvider datapack(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        return new ModDatapackProvider(output, BUILDER, registries, "datapack");
    }

    static {
        BUILDER_BUILTIN.add(Registries.DAMAGE_TYPE, ModDamageTypes::boostrap);
        BUILDER_BUILTIN.add(Registries.ENCHANTMENT, ModEnchantments::boostrap);
        BUILDER_BUILTIN.add(ModRegistries.BLUEPRINTS, context -> new BootstrapHelper.Blueprint(context, "csr"){

            @Override
            protected void gather() {
                this.register("small_house", ResourceLocation.withDefaultNamespace((String)"village/plains/houses/plains_small_house_1"), ModDatapackProvider.SMALL_HOUSE_LANG, 0.0f);
                this.register("small_farm", ResourceLocation.withDefaultNamespace((String)"village/plains/houses/plains_small_farm_1"), ModDatapackProvider.SMALL_FARM_LANG, 0.5f);
                this.register("large_house", ResourceLocation.withDefaultNamespace((String)"village/plains/houses/plains_medium_house_1"), ModDatapackProvider.LARGE_HOUSE_LANG, 1.0f);
            }
        });
        BUILDER.add(ModRegistries.SOLDIER_ITEM_TYPES, DefaultSoldierItemTypes::registerAll);
        BUILDER.add(ModRegistries.CLAY_MOB_TEAMS, context -> new BootstrapHelper.ClayTeam(context, "csr"){

            @Override
            protected void gather() {
                this.register(ClayMobTeamManger.DEFAULT_TYPE.getPath(), ClayMobTeam.of("Normal", ColorHelper.EMPTY).build());
                this.register(ClayMobTeamManger.NO_TEAM_TYPE.getPath(), ClayMobTeam.of("No Team", ColorHelper.EMPTY).allowFriendlyFire().disableTaming().build());
                this.register("white", "White", 0xF9FFFE, Items.WHITE_DYE);
                this.register("orange", "Orange", 16351261, Items.ORANGE_DYE);
                this.register("magenta", "Magenta", 13061821, Items.MAGENTA_DYE);
                this.register("light_blue", "Light Blue", 3847130, Items.LIGHT_BLUE_DYE);
                this.register("yellow", "Yellow", 16701501, Items.YELLOW_DYE);
                this.register("lime", "Lime", 8439583, Items.LIME_DYE);
                this.register("pink", "Pink", 15961002, Items.PINK_DYE);
                this.register("gray", "Gray", 4673362, Items.GRAY_DYE);
                this.register("light_gray", "Light Gray", 0x9D9D97, Items.LIGHT_GRAY_DYE);
                this.register("cyan", "Cyan", 1481884, Items.CYAN_DYE);
                this.register("purple", "Purple", 8991416, Items.PURPLE_DYE);
                this.register("blue", "Blue", 3949738, Items.BLUE_DYE);
                this.register("brown", "Brown", 8606770, Items.BROWN_DYE);
                this.register("green", "Green", 6192150, Items.GREEN_DYE);
                this.register("red", "Red", 11546150, Items.RED_DYE);
                this.register("black", "Black", 0x1D1D21, Items.BLACK_DYE);
                this.register("jeb_", ClayMobTeam.of("Jeb_", ColorHelper.jeb()).setProperties(SoldierPropertyMap.builder().size(1.1f).build()).build());
            }
        });
    }
}

