/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datagen;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.bumblebee.claysoldiers.init.ModBlocks;
import net.bumblebee.claysoldiers.init.ModBossBehaviours;
import net.bumblebee.claysoldiers.init.ModEnchantments;
import net.bumblebee.claysoldiers.init.ModItems;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class ModLoottableProvider
extends LootTableProvider {
    public ModLoottableProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLoottableProvider::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(BossLootTableProvider::new, LootContextParamSets.ENTITY)), pRegistries);
    }

    public static Holder.Reference<Enchantment> createForSlingShot(HolderLookup.Provider lookup) {
        return new FakeHolder(lookup, ModEnchantments.SOLDIER_PROJECTILE, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)HolderSet.empty(), (int)2, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)20), (Enchantment.Cost)Enchantment.constantCost((int)50), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY})).build(ModEnchantments.SOLDIER_PROJECTILE.location()));
    }

    private static class FakeHolder
    extends Holder.Reference<Enchantment> {
        public FakeHolder(HolderLookup.Provider lookup, ResourceKey<Enchantment> key, Enchantment value) {
            super(Holder.Reference.Type.STAND_ALONE, (HolderOwner)lookup.lookupOrThrow(Registries.ENCHANTMENT), key, (Object)value);
        }

        public boolean canSerializeIn(HolderOwner<Enchantment> owner) {
            return true;
        }
    }

    private record BossLootTableProvider(HolderLookup.Provider lookup) implements LootTableSubProvider
    {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> biConsumer) {
            biConsumer.accept(ModBossBehaviours.DEFAULT_LOOT_TABLE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.CLAY_POUCH)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.CLAY_STAFF)).when(LootItemKilledByPlayerCondition.killedByPlayer())).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CLAY_BALL).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CLAY).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))))));
            biConsumer.accept(ModBossBehaviours.VAMPIRE_LOOT_TABLE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.CLAY_POUCH)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOOK).apply((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().withEnchantment(ModLoottableProvider.createForSlingShot(this.lookup), (NumberProvider)ConstantValue.exactly((float)1.0f)))).when(LootItemKilledByPlayerCondition.killedByPlayer())).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CLAY_BALL).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CLAY).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))))));
            biConsumer.accept(ModBossBehaviours.ZOMBIE_LOOT_TABLE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.CLAY_STAFF)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOOK).apply((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().withEnchantment(ModLoottableProvider.createForSlingShot(this.lookup), (NumberProvider)ConstantValue.exactly((float)1.0f)))).when(LootItemKilledByPlayerCondition.killedByPlayer())).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CLAY_BALL).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CLAY).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))))));
        }
    }

    private static class BlockLoottableProvider
    extends BlockLootSubProvider {
        protected BlockLoottableProvider(HolderLookup.Provider lookupProvider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), lookupProvider);
        }

        protected void generate() {
            this.dropSelf(ModBlocks.HAMSTER_WHEEL_BLOCK.get());
            this.dropSelf(ModBlocks.EASEL_BLOCK.get());
            this.dropSelf(ModBlocks.ESCRITOIRE_BLOCK.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return List.of(ModBlocks.HAMSTER_WHEEL_BLOCK.get(), ModBlocks.EASEL_BLOCK.get(), ModBlocks.ESCRITOIRE_BLOCK.get());
        }
    }
}

