/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datagen;

import java.util.ArrayList;
import java.util.List;
import net.bumblebee.claysoldiers.ClaySoldiersClient;
import net.bumblebee.claysoldiers.block.SpecialItemRenderers;
import net.bumblebee.claysoldiers.init.ModBlocks;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.item.ClayBrushItem;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.RangeSelectItemModel;
import net.minecraft.client.renderer.item.SelectItemModel;
import net.minecraft.client.renderer.item.SpecialModelWrapper;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.client.renderer.item.properties.select.DisplayContext;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplateBuilder;

public class ModModelProvider
extends ModelProvider {
    private static final ModelTemplate SPECIAL_BLOCK = ExtendedModelTemplateBuilder.builder().parent(ResourceLocation.withDefaultNamespace((String)"block/block")).build();
    public static ModelTemplate CLAY_STAFF_MODEL = ExtendedModelTemplateBuilder.builder().parent(ResourceLocation.withDefaultNamespace((String)"item/generated")).guiLight(UnbakedModel.GuiLight.FRONT).transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, t -> t.rotation(0.0f, 30.0f, 0.0f).translation(11.0f, 17.0f, 4.5f)).transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, t -> t.rotation(0.0f, -30.0f, 0.0f).translation(11.0f, 17.0f, 4.5f)).transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, t -> t.rotation(0.0f, -90.0f, 25.0f).translation(-3.0f, 17.0f, 1.0f)).transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, t -> t.rotation(0.0f, 90.0f, 25.0f).translation(13.0f, 17.0f, 1.0f)).transform(ItemDisplayContext.GUI, t -> t.rotation(15.0f, -25.0f, -5.0f).translation(2.0f, 6.0f, 0.0f)).transform(ItemDisplayContext.FIXED, t -> t.rotation(0.0f, 180.0f, 0.0f).translation(-2.0f, 4.0f, 0.5f)).transform(ItemDisplayContext.GROUND, t -> t.rotation(0.0f, 0.0f, 0.0f).translation(4.0f, 16.0f, 0.75f)).build();

    public ModModelProvider(PackOutput output) {
        super(output, "csr");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        itemModels.generateFlatItem(ModItems.SHEAR_BLADE.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
        itemModels.generateFlatItem(ModItems.SHARPENED_STICK.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
        itemModels.generateFlatItem((Item)ModItems.BRICKED_CLAY_SOLDIER.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(ModItems.CLAY_COOKIE.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(ModItems.CLAY_DISRUPTOR.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(ModItems.TERRACOTTA_DISRUPTOR.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)ModItems.CLAY_GOGGLES.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem((Item)ModItems.SLIME_BOOTS.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(ModItems.TEST_ITEM.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(ModItems.CAKE_HORSE.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(ModItems.CAKE_PEGASUS.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(ModItems.SNOW_HORSE.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(ModItems.SNOW_PEGASUS.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(ModItems.MYCELIUM_HORSE.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(ModItems.MYCELIUM_PEGASUS.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(ModItems.GRASS_HORSE.get(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(ModItems.GRASS_PEGASUS.get(), ModelTemplates.FLAT_ITEM);
        itemModels.itemModelOutput.accept((Item)ModItems.CLAY_STAFF.get(), ItemModelGenerators.createFlatModelDispatch((ItemModel.Unbaked)ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel((Item)ModItems.CLAY_STAFF.get(), ModelTemplates.FLAT_ITEM)), (ItemModel.Unbaked)new SpecialModelWrapper.Unbaked(ModelLocationUtils.getModelLocation((Item)ModItems.CLAY_STAFF.get(), (String)"_in_hand"), (SpecialModelRenderer.Unbaked)new SpecialItemRenderers.ClayStaffSpecialRenderer.Unbaked())));
        CLAY_STAFF_MODEL.create(ModelLocationUtils.getModelLocation((Item)ModItems.CLAY_STAFF.get(), (String)"_in_hand"), TextureMapping.particle((ResourceLocation)ModelLocationUtils.getModelLocation((Item)ModItems.CLAY_STAFF.get())), itemModels.modelOutput);
        TextureMapping texturemapping = new TextureMapping().put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)Blocks.SPRUCE_PLANKS)).put(TextureSlot.BOTTOM, TextureMapping.getBlockTexture((Block)Blocks.SPRUCE_PLANKS)).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)ModBlocks.ESCRITOIRE_BLOCK.get(), (String)"_top")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)ModBlocks.ESCRITOIRE_BLOCK.get(), (String)"_side"));
        blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)ModBlocks.ESCRITOIRE_BLOCK.get(), (ResourceLocation)ModelTemplates.CUBE_BOTTOM_TOP.create(ModBlocks.ESCRITOIRE_BLOCK.get(), texturemapping, blockModels.modelOutput)));
        blockModels.createParticleOnlyBlock(ModBlocks.HAMSTER_WHEEL_BLOCK.get(), Blocks.COPPER_BLOCK);
        blockModels.createParticleOnlyBlock(ModBlocks.EASEL_BLOCK.get(), Blocks.OAK_PLANKS);
        blockModels.generateSimpleSpecialItemModel(ModBlocks.HAMSTER_WHEEL_BLOCK.get(), (SpecialModelRenderer.Unbaked)new SpecialItemRenderers.HamsterWheelSpecialRenderer.Unbaked());
        blockModels.generateSimpleSpecialItemModel(ModBlocks.EASEL_BLOCK.get(), (SpecialModelRenderer.Unbaked)new SpecialItemRenderers.EaselBlockSpecialRenderer.Unbaked());
        SPECIAL_BLOCK.create(ModBlocks.HAMSTER_WHEEL_BLOCK.asItem(), TextureMapping.particle((Block)Blocks.COPPER_BLOCK), itemModels.modelOutput);
        SPECIAL_BLOCK.create(ModBlocks.EASEL_BLOCK.asItem(), TextureMapping.particle((Block)Blocks.OAK_PLANKS), itemModels.modelOutput);
        ItemModel.Unbaked inHand = ItemModelUtils.tintedModel((ResourceLocation)ModelTemplates.FLAT_ITEM.create((Item)ModItems.CLAY_SOLDIER.get(), TextureMapping.layer0((Item)ModItems.CLAY_SOLDIER.get()), itemModels.modelOutput), (ItemTintSource[])new ItemTintSource[]{ClaySoldiersClient.ClaySoldierItemTintSource.INSTANCE});
        ItemModel.Unbaked head = ItemModelUtils.tintedModel((ResourceLocation)ModelLocationUtils.getModelLocation((Item)ModItems.CLAY_SOLDIER.get(), (String)"_on_head"), (ItemTintSource[])new ItemTintSource[]{ClaySoldiersClient.ClaySoldierItemTintSource.INSTANCE});
        itemModels.itemModelOutput.accept((Item)ModItems.CLAY_SOLDIER.get(), ItemModelUtils.select((SelectItemModelProperty)new DisplayContext(), (ItemModel.Unbaked)inHand, (SelectItemModel.SwitchCase[])new SelectItemModel.SwitchCase[]{ItemModelUtils.when((Object)ItemDisplayContext.HEAD, (ItemModel.Unbaked)head)}));
        this.generateClayPouch(ModItems.CLAY_POUCH.get(), itemModels);
        this.generateClayBrush(ModItems.CLAY_BRUSH.get(), itemModels);
        itemModels.generateFlatItem(ModItems.BLUEPRINT_PAGE.get(), ModelTemplates.FLAT_ITEM);
        this.generateBlueprint(ModItems.BLUEPRINT.get(), ModItems.BLUEPRINT_PAGE.asItem(), itemModels);
    }

    private void generateClayPouch(Item pouch, ItemModelGenerators modelGenerators) {
        ResourceLocation baseTexture = TextureMapping.getItemTexture((Item)pouch);
        ResourceLocation pouchColor = TextureMapping.getItemTexture((Item)pouch, (String)"_cross");
        modelGenerators.itemModelOutput.accept(pouch, ItemModelUtils.tintedModel((ResourceLocation)ModelTemplates.TWO_LAYERED_ITEM.create(pouchColor, TextureMapping.layered((ResourceLocation)baseTexture, (ResourceLocation)pouchColor), modelGenerators.modelOutput), (ItemTintSource[])new ItemTintSource[]{ItemModelGenerators.BLANK_LAYER, ClaySoldiersClient.ClayPouchItemTintSource.INSTANCE}));
    }

    private void generateClayBrush(Item clayBrush, ItemModelGenerators modelGenerators) {
        modelGenerators.itemModelOutput.accept(clayBrush, ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)ClaySoldiersClient.ClayBrushConditionalProperty.INSTANCE, List.of(ItemModelUtils.override((ItemModel.Unbaked)ItemModelUtils.plainModel((ResourceLocation)ModelTemplates.TWO_LAYERED_ITEM.create(ModelLocationUtils.getModelLocation((Item)clayBrush, (String)"_command"), TextureMapping.layered((ResourceLocation)ModelLocationUtils.getModelLocation((Item)clayBrush), (ResourceLocation)ModelLocationUtils.getModelLocation((Item)clayBrush, (String)"_command")), modelGenerators.modelOutput)), (float)ClayBrushItem.Mode.COMMAND.getOverrideProperty()), ItemModelUtils.override((ItemModel.Unbaked)ItemModelUtils.plainModel((ResourceLocation)ModelTemplates.TWO_LAYERED_ITEM.create(ModelLocationUtils.getModelLocation((Item)clayBrush, (String)"_work"), TextureMapping.layered((ResourceLocation)ModelLocationUtils.getModelLocation((Item)clayBrush), (ResourceLocation)ModelLocationUtils.getModelLocation((Item)clayBrush, (String)"_work")), modelGenerators.modelOutput)), (float)ClayBrushItem.Mode.WORK.getOverrideProperty()), ItemModelUtils.override((ItemModel.Unbaked)ItemModelUtils.plainModel((ResourceLocation)ModelTemplates.TWO_LAYERED_ITEM.create(ModelLocationUtils.getModelLocation((Item)clayBrush, (String)"_poi"), TextureMapping.layered((ResourceLocation)ModelLocationUtils.getModelLocation((Item)clayBrush), (ResourceLocation)ModelLocationUtils.getModelLocation((Item)clayBrush, (String)"_poi")), modelGenerators.modelOutput)), (float)ClayBrushItem.Mode.POI.getOverrideProperty()))));
    }

    private void generateBlueprint(Item blueprint, Item blueprintPage, ItemModelGenerators modelGenerators) {
        int maxCount = 3;
        ArrayList<RangeSelectItemModel.Entry> models = new ArrayList<RangeSelectItemModel.Entry>();
        for (int i = 0; i < maxCount; ++i) {
            models.add(ItemModelUtils.override((ItemModel.Unbaked)ItemModelUtils.plainModel((ResourceLocation)ModelTemplates.TWO_LAYERED_ITEM.create(ModelLocationUtils.getModelLocation((Item)blueprint, (String)("_marking_" + i)), TextureMapping.layered((ResourceLocation)ModelLocationUtils.getModelLocation((Item)blueprintPage), (ResourceLocation)ModelLocationUtils.getModelLocation((Item)blueprint, (String)("_marking_" + i))), modelGenerators.modelOutput)), (float)((float)i / (float)(maxCount - 1))));
        }
        modelGenerators.itemModelOutput.accept(blueprint, ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)ClaySoldiersClient.BlueprintPageConditionalProperty.INSTANCE, models));
    }
}

