/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datagen;

import java.util.concurrent.CompletableFuture;
import net.bumblebee.claysoldiers.entity.variant.ClayHorseVariants;
import net.bumblebee.claysoldiers.init.ModBlocks;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.recipe.BrickedItemReviveRecipe;
import net.bumblebee.claysoldiers.recipe.ClaySoldierCookingRecipe;
import net.bumblebee.claysoldiers.recipe.ClaySoldierCraftingRecipe;
import net.bumblebee.claysoldiers.recipe.ShearBladeRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class ModRecipeProvider
extends RecipeProvider {
    private static final String CLAY_HORSE_GROUP_NAME = "csr:clay_horse";
    private static final String CLAY_PEGASUS_GROUP_NAME = "csr:clay_pegasus";
    private static final String CLAY_DISRUPTOR_GROUP_NAME = "csr:clay_disruptor";
    public static final ResourceKey<Recipe<?>> CLAY_SOLDIER_CRAFTING = ModRecipeProvider.createResourceKey("clay_soldier");
    public static final ResourceKey<Recipe<?>> CLAY_SOLDIER_REVIVE = ModRecipeProvider.createResourceKey("clay_soldier_reviving");
    public static final ResourceKey<Recipe<?>> BLUEPRINT_PAGE = ModRecipeProvider.createResourceKey("blueprint_page");
    private final RecipeOutput recipeOutput;

    public ModRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
        super(registries, output);
        this.recipeOutput = output;
    }

    protected void buildRecipes() {
        SpecialRecipeBuilder.special(ClaySoldierCraftingRecipe::new).save(this.recipeOutput, ModRecipeProvider.createResourceKey("clay_soldier_crafting"));
        SpecialRecipeBuilder.special(BrickedItemReviveRecipe::new).save(this.recipeOutput, CLAY_SOLDIER_REVIVE);
        SpecialRecipeBuilder.special(ShearBladeRecipe::new).save(this.recipeOutput, ModRecipeProvider.createResourceKey("shear_blade"));
        SpecialRecipeBuilder.special(bc -> ClaySoldierCookingRecipe.smelting()).save(this.recipeOutput, ModRecipeProvider.createResourceKey("clay_soldier_smelting"));
        SpecialRecipeBuilder.special(bc -> ClaySoldierCookingRecipe.blasting()).save(this.recipeOutput, ModRecipeProvider.createResourceKey("clay_soldier_blasting"));
        SpecialRecipeBuilder.special(bc -> ClaySoldierCookingRecipe.campfire()).save(this.recipeOutput, ModRecipeProvider.createResourceKey("clay_soldier_campfire"));
        SpecialRecipeBuilder.special(bc -> ClaySoldierCookingRecipe.smoking()).save(this.recipeOutput, ModRecipeProvider.createResourceKey("clay_soldier_smoking"));
        this.shaped(RecipeCategory.MISC, (ItemLike)ModItems.CLAY_SOLDIER.get(), 4).define(Character.valueOf('E'), (ItemLike)Items.CLAY_BALL).define(Character.valueOf('S'), (ItemLike)Items.SOUL_SAND).pattern("E").pattern("S").unlockedBy("has_clay", this.has((ItemLike)Items.CLAY)).unlockedBy("has_clay_ball", this.has((ItemLike)Items.CLAY_BALL)).save(this.recipeOutput, CLAY_SOLDIER_CRAFTING);
        this.shapeless(RecipeCategory.TOOLS, (ItemLike)Items.SHEARS).requires((ItemLike)ModItems.SHEAR_BLADE.get()).requires((ItemLike)ModItems.SHEAR_BLADE.get()).unlockedBy("has_shear_blade", this.has((ItemLike)ModItems.SHEAR_BLADE.get())).save(this.recipeOutput);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)ModItems.CLAY_DISRUPTOR.get()).define(Character.valueOf('C'), (ItemLike)Items.CLAY).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("CSC").pattern("CRC").group(CLAY_DISRUPTOR_GROUP_NAME).unlockedBy("has_clay", this.has((ItemLike)Items.CLAY)).unlockedBy("has_clay_ball", this.has((ItemLike)Items.CLAY_BALL)).save(this.recipeOutput);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)ModItems.TERRACOTTA_DISRUPTOR.get()).define(Character.valueOf('C'), ItemTags.TERRACOTTA).define(Character.valueOf('R'), ModItems.CLAY_DISRUPTOR).define(Character.valueOf('S'), (ItemLike)Items.REDSTONE).pattern("CSC").pattern("CRC").group(CLAY_DISRUPTOR_GROUP_NAME).unlockedBy("has_clay", this.has((ItemLike)Items.CLAY)).unlockedBy("has_clay_ball", this.has((ItemLike)Items.CLAY_BALL)).unlockedBy("has_terracotta", this.has((ItemLike)Items.TERRACOTTA)).save(this.recipeOutput);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)ModItems.CLAY_COOKIE.get(), 4).define(Character.valueOf('#'), (ItemLike)Items.CLAY_BALL).define(Character.valueOf('R'), (ItemLike)Items.GHAST_TEAR).pattern("#R#").unlockedBy("has_clay_ball", this.has((ItemLike)Items.CLAY_BALL)).save(this.recipeOutput);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)ModItems.CLAY_GOGGLES.get()).define(Character.valueOf('#'), (ItemLike)Items.GLASS_PANE).define(Character.valueOf('R'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('S'), (ItemLike)Items.LEATHER).pattern(" S ").pattern("#R#").unlockedBy("has_clay_ball", this.has((ItemLike)Items.CLAY_BALL)).unlockedBy("has_copper", this.has((ItemLike)Items.COPPER_INGOT)).save(this.recipeOutput);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)ModItems.SLIME_BOOTS.get()).define(Character.valueOf('#'), (ItemLike)Items.SLIME_BLOCK).define(Character.valueOf('S'), (ItemLike)Items.COPPER_INGOT).pattern("S S").pattern("# #").unlockedBy("has_slime_ball", this.has((ItemLike)Items.SLIME_BLOCK)).unlockedBy("has_copper", this.has((ItemLike)Items.COPPER_INGOT)).save(this.recipeOutput);
        this.shaped(RecipeCategory.TOOLS, (ItemLike)ModItems.CLAY_BRUSH.get()).define(Character.valueOf('#'), (ItemLike)Items.CLAY_BALL).define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("#").pattern("C").pattern("S").unlockedBy("has_clay_ball", this.has((ItemLike)Items.CLAY_BALL)).save(this.recipeOutput);
        this.shaped(RecipeCategory.MISC, (ItemLike)ModItems.BLUEPRINT_PAGE.get()).define(Character.valueOf('#'), (ItemLike)Items.LAPIS_LAZULI).define(Character.valueOf('C'), (ItemLike)Items.PAPER).define(Character.valueOf('S'), (ItemLike)Items.CLAY_BALL).pattern("#").pattern("C").pattern("S").unlockedBy("has_clay_ball", this.has((ItemLike)Items.CLAY_BALL)).save(this.recipeOutput, BLUEPRINT_PAGE);
        this.shaped(RecipeCategory.MISC, ModBlocks.ESCRITOIRE_BLOCK).define(Character.valueOf('#'), ModItems.BLUEPRINT_PAGE).define(Character.valueOf('C'), ItemTags.PLANKS).pattern("##").pattern("CC").pattern("CC").unlockedBy("has_blueprint", this.has(ModItems.BLUEPRINT_PAGE)).save(this.recipeOutput);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)ModBlocks.EASEL_BLOCK.get()).define(Character.valueOf('#'), (ItemLike)Items.STICK).pattern(" # ").pattern("###").pattern("# #").unlockedBy("has_stick", this.has((ItemLike)Items.STICK)).unlockedBy("has_clay_ball", this.has((ItemLike)Items.CLAY_BALL)).save(this.recipeOutput);
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)ModBlocks.HAMSTER_WHEEL_BLOCK.get()).define(Character.valueOf('#'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('C'), (ItemLike)Items.STICK).define(Character.valueOf('S'), (ItemLike)Items.STONE).pattern(" # ").pattern("#C#").pattern("S#S").unlockedBy("has_copper_ingot", this.has((ItemLike)Items.COPPER_INGOT)).unlockedBy("has_clay_ball", this.has((ItemLike)Items.CLAY_BALL)).save(this.recipeOutput);
        this.clayHorseRecipe(ClayHorseVariants.CAKE, (ItemLike)Items.CAKE);
        this.clayHorseRecipe(ClayHorseVariants.GRASS, (ItemLike)Items.GRASS_BLOCK);
        this.clayHorseRecipe(ClayHorseVariants.SNOW, (ItemLike)Items.SNOW_BLOCK);
        this.clayHorseRecipe(ClayHorseVariants.MYCELIUM, (ItemLike)Items.MYCELIUM);
        this.stonecutterResultFromBase(RecipeCategory.COMBAT, (ItemLike)ModItems.SHARPENED_STICK.get(), (ItemLike)Items.STICK);
    }

    private void clayHorseRecipe(ClayHorseVariants variant, ItemLike material) {
        this.shaped(RecipeCategory.TOOLS, (ItemLike)ClayHorseVariants.clayHorseByVariant(variant).get(), 2).define(Character.valueOf('C'), (ItemLike)Items.CLAY_BALL).define(Character.valueOf('H'), material).pattern("CHC").pattern("C C").unlockedBy("has_clay_ball", this.has((ItemLike)Items.CLAY_BALL)).group(CLAY_HORSE_GROUP_NAME).save(this.recipeOutput, ModRecipeProvider.getClayHorseKey(variant));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)ClayHorseVariants.clayPegasusByVariant(variant).get(), 2).define(Character.valueOf('C'), (ItemLike)Items.CLAY_BALL).define(Character.valueOf('H'), material).define(Character.valueOf('F'), (ItemLike)Items.FEATHER).pattern(" F ").pattern("CHC").pattern("C C").unlockedBy("has_clay_ball", this.has((ItemLike)Items.CLAY_BALL)).group(CLAY_PEGASUS_GROUP_NAME).save(this.recipeOutput, ModRecipeProvider.getClayPegasusKey(variant, false));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)ClayHorseVariants.clayPegasusByVariant(variant).get()).define(Character.valueOf('H'), (ItemLike)ClayHorseVariants.clayHorseByVariant(variant).get()).define(Character.valueOf('F'), (ItemLike)Items.FEATHER).pattern("F").pattern("H").unlockedBy("has_clay_ball", this.has((ItemLike)Items.CLAY_BALL)).group(CLAY_PEGASUS_GROUP_NAME).save(this.recipeOutput, ModRecipeProvider.getClayPegasusKey(variant, true));
    }

    public static ResourceKey<Recipe<?>> getClayHorseKey(ClayHorseVariants variant) {
        return ModRecipeProvider.createResourceKey(variant.getVariantName() + "_horse");
    }

    public static ResourceKey<Recipe<?>> getClayPegasusKey(ClayHorseVariants variant, boolean fromHorse) {
        return ModRecipeProvider.createResourceKey(variant.getVariantName() + "_pegasus" + (fromHorse ? "_feather" : ""));
    }

    private static ResourceKey<Recipe<?>> createResourceKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"csr", (String)name));
    }

    public static class Runner
    extends RecipeProvider.Runner {
        protected Runner(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
            super(packOutput, registries);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
            return new ModRecipeProvider(provider, recipeOutput);
        }

        public String getName() {
            return "csr Recipies";
        }
    }
}

