/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datagen.advancements;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.bumblebee.claysoldiers.advancements.BlueprintPlaceBlockTrigger;
import net.bumblebee.claysoldiers.advancements.BossClaySoldierSubPredicate;
import net.bumblebee.claysoldiers.advancements.ClayBrushCommandTrigger;
import net.bumblebee.claysoldiers.advancements.ClaySoldierDeathTrigger;
import net.bumblebee.claysoldiers.advancements.ClaySoldierOnHeadTrigger;
import net.bumblebee.claysoldiers.advancements.DisruptorKillTrigger;
import net.bumblebee.claysoldiers.advancements.FeedItemClaySoldierTrigger;
import net.bumblebee.claysoldiers.advancements.HitWithClayBlockTrigger;
import net.bumblebee.claysoldiers.advancements.MultiSpawnItemUseTrigger;
import net.bumblebee.claysoldiers.advancements.SoldierPoiUseTrigger;
import net.bumblebee.claysoldiers.advancements.SoldierPropertyItemPredicate;
import net.bumblebee.claysoldiers.advancements.UseAssignedWorksiteTrigger;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntity;
import net.bumblebee.claysoldiers.datagen.ModRecipeProvider;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.entity.goal.UseAssignedPoiGoal;
import net.bumblebee.claysoldiers.entity.variant.ClayHorseVariants;
import net.bumblebee.claysoldiers.init.ModBlocks;
import net.bumblebee.claysoldiers.init.ModBossBehaviours;
import net.bumblebee.claysoldiers.init.ModCriterions;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.item.ClayBrushItem;
import net.bumblebee.claysoldiers.item.blueprint.BlueprintItem;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PickedUpItemTrigger;
import net.minecraft.advancements.critereon.RecipeCraftedTrigger;
import net.minecraft.advancements.critereon.SummonedEntityTrigger;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class ModAdvancements
implements AdvancementSubProvider {
    private static final String TITLE_BASE = "advancements.csr.clay_soldiers.%s.title";
    private static final String DESCRIPTION_BASE = "advancements.csr.clay_soldiers.%s.description";
    public static final String ROOT_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("root");
    public static final String ROOT_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("root");
    public static final String SOLDIER_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("soldier");
    public static final String SOLDIER_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("soldier");
    public static final String BRICKED_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("bricked");
    public static final String BRICKED_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("bricked");
    public static final String REVIVE_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("revive");
    public static final String REVIVE_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("revive");
    public static final String DISRUPTOR_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("disruptor");
    public static final String DISRUPTOR_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("disruptor");
    public static final String WAXED_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("waxed");
    public static final String WAXED_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("waxed");
    public static final String BATTLE_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("battle");
    public static final String BATTLE_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("battle");
    public static final String FOOD_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("food");
    public static final String FOOD_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("food");
    public static final String EQUIPMENT_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("equipment");
    public static final String EQUIPMENT_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("equipment");
    public static final String ARMOR_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("armor");
    public static final String ARMOR_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("armor");
    public static final String WEAPON_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("weapon");
    public static final String WEAPON_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("weapon");
    public static final String ROYALTY_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("royalty");
    public static final String ROYALTY_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("royalty");
    public static final String WORKER_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("worker");
    public static final String WORKER_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("worker");
    public static final String LOYALTY_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("loyalty");
    public static final String LOYALTY_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("loyalty");
    public static final String COMMAND_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("command");
    public static final String COMMAND_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("command");
    public static final String POI_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("poi");
    public static final String POI_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("poi");
    public static final String HAMSTER_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("hamster");
    public static final String HAMSTER_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("hamster");
    public static final String CHEST_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("chest");
    public static final String CHEST_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("chest");
    public static final String WORK_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("work");
    public static final String WORK_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("work");
    public static final String POI_USE_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("poi_use");
    public static final String POI_USE_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("poi_use");
    public static final String BOSS_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("boss");
    public static final String BOSS_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("boss");
    public static final String STAFF_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("clay_staff");
    public static final String STAFF_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("clay_staff");
    public static final String POUCH_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("clay_pouch");
    public static final String POUCH_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("clay_pouch");
    public static final String BOOK_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("book");
    public static final String BOOK_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("book");
    public static final String HORSE_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("horse");
    public static final String HORSE_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("horse");
    public static final String PEGASUS_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("pegasus");
    public static final String PEGASUS_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("pegasus");
    public static final String BLUEPRINT_PAGE_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("blueprint_page");
    public static final String BLUEPRINT_PAGE_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("blueprint_page");
    public static final String BLUEPRINT_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("blueprint");
    public static final String BLUEPRINT_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("blueprint");
    public static final String HOUSE_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("house");
    public static final String HOUSE_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("house");
    public static final String SOLDIER_ON_HEAD_TITLE = "advancements.csr.clay_soldiers.%s.title".formatted("soldier_on_head");
    public static final String SOLDIER_ON_HEAD_DESCRIPTION = "advancements.csr.clay_soldiers.%s.description".formatted("soldier_on_head");
    public static ResourceLocation SOLDIER_ID = ModAdvancements.getSaveLocation("soldier");
    public static ResourceLocation LOYALTY_ID = ModAdvancements.getSaveLocation("loyalty");

    public void generate(HolderLookup.Provider provider, Consumer<AdvancementHolder> saver) {
        HolderLookup.RegistryLookup entityTypeHolderGetter = provider.lookupOrThrow(Registries.ENTITY_TYPE);
        HolderLookup.RegistryLookup itemRegistry = provider.lookupOrThrow(Registries.ITEM);
        ItemStack clayBrushItemPoi = ModItems.CLAY_BRUSH.get().getDefaultInstance();
        clayBrushItemPoi.set(ModDataComponents.CLAY_BRUSH_MODE.get(), (Object)ClayBrushItem.Mode.POI);
        ItemStack clayBrushItemWork = ModItems.CLAY_BRUSH.get().getDefaultInstance();
        clayBrushItemWork.set(ModDataComponents.CLAY_BRUSH_MODE.get(), (Object)ClayBrushItem.Mode.WORK);
        AdvancementHolder root = new Advancement.Builder().display(new ItemStack((ItemLike)Items.CLAY_BALL), (Component)Component.translatable((String)ROOT_TITLE), (Component)Component.translatable((String)ROOT_DESCRIPTION), ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"textures/gui/advancements/backgrounds/clay.png"), AdvancementType.TASK, true, false, false).rewards(AdvancementRewards.Builder.experience((int)100).addRecipe(ModRecipeProvider.CLAY_SOLDIER_CRAFTING)).addCriterion("has_clay_ball", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.CLAY_BALL})).addCriterion("has_clay", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.CLAY})).requirements(AdvancementRequirements.Strategy.OR).save(saver, ModAdvancements.getSaveLocation("root"));
        AdvancementHolder soldier = new Advancement.Builder().display(new ItemStack((ItemLike)ModItems.CLAY_SOLDIER.get()), (Component)Component.translatable((String)SOLDIER_TITLE), (Component)Component.translatable((String)SOLDIER_DESCRIPTION), null, AdvancementType.TASK, true, false, false).parent(root).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("clay_soldier_crafted", RecipeCraftedTrigger.TriggerInstance.craftedItem(ModRecipeProvider.CLAY_SOLDIER_CRAFTING)).save(saver, SOLDIER_ID);
        AdvancementHolder bricked = new Advancement.Builder().display(new ItemStack((ItemLike)ModItems.BRICKED_CLAY_SOLDIER.get()), (Component)Component.translatable((String)BRICKED_TITLE), (Component)Component.translatable((String)BRICKED_DESCRIPTION), null, AdvancementType.TASK, true, false, true).parent(soldier).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("clay_soldier_smelted", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BRICKED_CLAY_SOLDIER.get()})).save(saver, ModAdvancements.getSaveLocation("clay_soldier_smelted"));
        AdvancementHolder revive = new Advancement.Builder().display(new ItemStack((ItemLike)Items.GHAST_TEAR), (Component)Component.translatable((String)REVIVE_TITLE), (Component)Component.translatable((String)REVIVE_DESCRIPTION, (Object[])new Object[]{Items.GHAST_TEAR.getName()}), null, AdvancementType.TASK, true, false, false).parent(bricked).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("revive", RecipeCraftedTrigger.TriggerInstance.craftedItem(ModRecipeProvider.CLAY_SOLDIER_REVIVE)).save(saver, ModAdvancements.getSaveLocation("revive"));
        AdvancementHolder disruptor = new Advancement.Builder().display(new ItemStack((ItemLike)ModItems.CLAY_DISRUPTOR.get()), (Component)Component.translatable((String)DISRUPTOR_TITLE), (Component)Component.translatable((String)DISRUPTOR_DESCRIPTION), null, AdvancementType.TASK, true, false, false).parent(soldier).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("kill_clay_soldier", DisruptorKillTrigger.createInstance(32)).save(saver, ModAdvancements.getSaveLocation("disruptor_kill"));
        AdvancementHolder waxed_soldier = new Advancement.Builder().display(new ItemStack((ItemLike)Items.HONEYCOMB), (Component)Component.translatable((String)WAXED_TITLE), (Component)Component.translatable((String)WAXED_DESCRIPTION), null, AdvancementType.GOAL, true, false, true).parent(soldier).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("wax_clay_mob", FeedItemClaySoldierTrigger.wax().build()).save(saver, ModAdvancements.getSaveLocation("wax"));
        AdvancementHolder battle = new Advancement.Builder().display(new ItemStack((ItemLike)ModItems.CLAY_SOLDIER.get()), (Component)Component.translatable((String)BATTLE_TITLE), (Component)Component.translatable((String)BATTLE_DESCRIPTION), null, AdvancementType.GOAL, true, false, false).parent(soldier).rewards(AdvancementRewards.Builder.experience((int)200)).addCriterion("clay_soldier_kill", ClaySoldierDeathTrigger.createBattle(EntityPredicate.Builder.entity().of((HolderGetter)entityTypeHolderGetter, ModTags.EntityTypes.CLAY_SOLDIER).build())).save(saver, ModAdvancements.getSaveLocation("battler"));
        AdvancementHolder food = new Advancement.Builder().display(new ItemStack((ItemLike)ModItems.CLAY_COOKIE.get()), (Component)Component.translatable((String)FOOD_TITLE), (Component)Component.translatable((String)FOOD_DESCRIPTION), null, AdvancementType.TASK, true, false, false).parent(soldier).rewards(AdvancementRewards.Builder.experience((int)200)).addCriterion("clay_soldier_food", FeedItemClaySoldierTrigger.ofCookie().build()).save(saver, ModAdvancements.getSaveLocation("food"));
        AdvancementHolder equipment = new Advancement.Builder().display(new ItemStack((ItemLike)Items.STICK), (Component)Component.translatable((String)EQUIPMENT_TITLE), (Component)Component.translatable((String)EQUIPMENT_DESCRIPTION), null, AdvancementType.TASK, true, false, false).parent(soldier).rewards(AdvancementRewards.Builder.experience((int)20)).addCriterion("equipment", PickedUpItemTrigger.TriggerInstance.thrownItemPickedUpByEntity((ContextAwarePredicate)ContextAwarePredicate.create((LootItemCondition[])new LootItemCondition[0]), Optional.empty(), Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)entityTypeHolderGetter, ModEntityTypes.CLAY_SOLDIER_ENTITY.get()))))).save(saver, ModAdvancements.getSaveLocation("equipment"));
        AdvancementHolder armor = new Advancement.Builder().display(new ItemStack((ItemLike)Items.LEATHER), (Component)Component.translatable((String)ARMOR_TITLE), (Component)Component.translatable((String)ARMOR_DESCRIPTION), null, AdvancementType.TASK, true, false, false).parent(equipment).rewards(AdvancementRewards.Builder.experience((int)20)).addCriterion("armor", PickedUpItemTrigger.TriggerInstance.thrownItemPickedUpByEntity((ContextAwarePredicate)ContextAwarePredicate.create((LootItemCondition[])new LootItemCondition[0]), Optional.of(ItemPredicate.Builder.item().of((HolderGetter)itemRegistry, ModTags.Items.SOLDIER_ARMOR).build()), Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)entityTypeHolderGetter, ModEntityTypes.CLAY_SOLDIER_ENTITY.get()))))).save(saver, ModAdvancements.getSaveLocation("armor"));
        AdvancementHolder weapon = new Advancement.Builder().display(new ItemStack((ItemLike)ModItems.SHEAR_BLADE.get()), (Component)Component.translatable((String)WEAPON_TITLE), (Component)Component.translatable((String)WEAPON_DESCRIPTION), null, AdvancementType.TASK, true, false, false).parent(equipment).rewards(AdvancementRewards.Builder.experience((int)20)).addCriterion("weapon", PickedUpItemTrigger.TriggerInstance.thrownItemPickedUpByEntity((ContextAwarePredicate)ContextAwarePredicate.create((LootItemCondition[])new LootItemCondition[0]), Optional.of(ItemPredicate.Builder.item().of((HolderGetter)itemRegistry, ModTags.Items.SOLDIER_WEAPON).build()), Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)entityTypeHolderGetter, ModEntityTypes.CLAY_SOLDIER_ENTITY.get()))))).save(saver, ModAdvancements.getSaveLocation("weapon"));
        Advancement.Builder makeAKingBuilder = new Advancement.Builder().display(new ItemStack((ItemLike)Items.GOLD_INGOT), (Component)Component.translatable((String)ROYALTY_TITLE), (Component)Component.translatable((String)ROYALTY_DESCRIPTION), null, AdvancementType.GOAL, false, false, false).parent(soldier).rewards(AdvancementRewards.Builder.experience((int)200)).requirements(AdvancementRequirements.Strategy.OR);
        for (AttackTypeProperty attackTypeProperty : AttackTypeProperty.values()) {
            if (!attackTypeProperty.isRoyalty()) continue;
            makeAKingBuilder.addCriterion(attackTypeProperty.getSerializedName(), PickedUpItemTrigger.TriggerInstance.thrownItemPickedUpByEntity((ContextAwarePredicate)ContextAwarePredicate.create((LootItemCondition[])new LootItemCondition[0]), Optional.of(ItemPredicate.Builder.item().withSubPredicate(ModCriterions.SOLDIER_PROPERTY_ITEM_PREDICATE.get(), (ItemSubPredicate)SoldierPropertyItemPredicate.hasProperty(SoldierPropertyTypes.ATTACK_TYPE.get(), attackTypeProperty)).build()), Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)entityTypeHolderGetter, ModEntityTypes.CLAY_SOLDIER_ENTITY.get())))));
        }
        AdvancementHolder makeAKing = makeAKingBuilder.save(saver, ModAdvancements.getSaveLocation("make_a_king"));
        AdvancementHolder loyalty = new Advancement.Builder().display(new ItemStack((ItemLike)Items.EMERALD), (Component)Component.translatable((String)LOYALTY_TITLE), (Component)Component.translatable((String)LOYALTY_DESCRIPTION), null, AdvancementType.CHALLENGE, true, false, false).parent(makeAKing).rewards(AdvancementRewards.Builder.experience((int)400)).addCriterion("loyalty", FeedItemClaySoldierTrigger.ofLoyalty().build()).save(saver, LOYALTY_ID);
        AdvancementHolder clayBrush = new Advancement.Builder().display(new ItemStack((ItemLike)ModItems.CLAY_BRUSH.get()), (Component)Component.translatable((String)COMMAND_TITLE), (Component)Component.translatable((String)COMMAND_DESCRIPTION), null, AdvancementType.TASK, true, false, false).parent(loyalty).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("clay_soldier_sit", ClayBrushCommandTrigger.create(ClayBrushItem.Mode.COMMAND)).save(saver, ModAdvancements.getSaveLocation("clay_soldier_sit"));
        Advancement.Builder workerBuilder = new Advancement.Builder().display(new ItemStack((ItemLike)Items.WHEAT), (Component)Component.translatable((String)WORKER_TITLE), (Component)Component.translatable((String)WORKER_DESCRIPTION), null, AdvancementType.GOAL, false, false, false).parent(loyalty).rewards(AdvancementRewards.Builder.experience((int)200)).requirements(AdvancementRequirements.Strategy.OR);
        for (AttackTypeProperty attackTypeProperty : AttackTypeProperty.values()) {
            if (!attackTypeProperty.isSupportive()) continue;
            workerBuilder.addCriterion(attackTypeProperty.getSerializedName(), PickedUpItemTrigger.TriggerInstance.thrownItemPickedUpByEntity((ContextAwarePredicate)ContextAwarePredicate.create((LootItemCondition[])new LootItemCondition[0]), Optional.of(ItemPredicate.Builder.item().withSubPredicate(ModCriterions.SOLDIER_PROPERTY_ITEM_PREDICATE.get(), (ItemSubPredicate)SoldierPropertyItemPredicate.hasProperty(SoldierPropertyTypes.ATTACK_TYPE.get(), attackTypeProperty)).build()), Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)entityTypeHolderGetter, ModEntityTypes.CLAY_SOLDIER_ENTITY.get())))));
        }
        AdvancementHolder worker = workerBuilder.save(saver, ModAdvancements.getSaveLocation("worker"));
        AdvancementHolder clayBrushPoi = new Advancement.Builder().display(clayBrushItemPoi, (Component)Component.translatable((String)POI_TITLE), (Component)Component.translatable((String)POI_DESCRIPTION), null, AdvancementType.TASK, true, false, false).parent(loyalty).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("clay_soldier_poi", ClayBrushCommandTrigger.create(ClayBrushItem.Mode.POI)).save(saver, ModAdvancements.getSaveLocation("clay_soldier_poi"));
        AdvancementHolder hamsterWheel = new Advancement.Builder().display((ItemLike)ModBlocks.HAMSTER_WHEEL_BLOCK.asItem(), (Component)Component.translatable((String)HAMSTER_TITLE), (Component)Component.translatable((String)HAMSTER_DESCRIPTION), null, AdvancementType.GOAL, true, false, true).parent(clayBrushPoi).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("hamster", UseAssignedWorksiteTrigger.of().setType(HamsterWheelBlockEntity.WORKSITE_ID).setTime(MinMaxBounds.Ints.between((int)13000, (int)23000)).build()).save(saver, ModAdvancements.getSaveLocation("hamster"));
        AdvancementHolder chest = new Advancement.Builder().display((ItemLike)Blocks.CHEST, (Component)Component.translatable((String)CHEST_TITLE), (Component)Component.translatable((String)CHEST_DESCRIPTION), null, AdvancementType.GOAL, true, false, true).parent(clayBrushPoi).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("chest", UseAssignedWorksiteTrigger.of().setType(UseAssignedPoiGoal.STORAGE_WORKSITE_ID).setTimesUsed(MinMaxBounds.Ints.atLeast((int)SoldierEquipmentSlot.values().length)).build()).save(saver, ModAdvancements.getSaveLocation("chest"));
        AdvancementHolder clayBrushWork = new Advancement.Builder().display(clayBrushItemWork, (Component)Component.translatable((String)WORK_TITLE), (Component)Component.translatable((String)WORK_DESCRIPTION), null, AdvancementType.TASK, true, false, false).parent(worker).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("clay_soldier_work", ClayBrushCommandTrigger.create(ClayBrushItem.Mode.WORK)).save(saver, ModAdvancements.getSaveLocation("clay_soldier_work"));
        AdvancementHolder flint = new Advancement.Builder().display(Items.FLINT.getDefaultInstance(), (Component)Component.translatable((String)POI_USE_TITLE), (Component)Component.translatable((String)POI_USE_DESCRIPTION), null, AdvancementType.TASK, true, false, false).parent(soldier).rewards(AdvancementRewards.Builder.experience((int)100)).addCriterion("poi", SoldierPoiUseTrigger.any()).save(saver, ModAdvancements.getSaveLocation("poi_use"));
        AdvancementHolder spawnClayBoss = new Advancement.Builder().display(Items.EGG.getDefaultInstance(), (Component)Component.translatable((String)BOSS_TITLE), (Component)Component.translatable((String)BOSS_DESCRIPTION), null, AdvancementType.GOAL, true, false, false).parent(flint).rewards(AdvancementRewards.Builder.experience((int)10)).addCriterion("clay_boss", SummonedEntityTrigger.TriggerInstance.summonedEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)entityTypeHolderGetter, ModEntityTypes.BOSS_CLAY_SOLDIER_ENTITY.get()))).save(saver, ModAdvancements.getSaveLocation("boss"));
        AdvancementHolder clayStaff = new Advancement.Builder().display(ModItems.CLAY_STAFF.get().getDefaultInstance(), (Component)Component.translatable((String)STAFF_TITLE), (Component)Component.translatable((String)STAFF_DESCRIPTION), null, AdvancementType.CHALLENGE, true, false, true).parent(spawnClayBoss).rewards(AdvancementRewards.Builder.experience((int)10)).addCriterion("normal", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)entityTypeHolderGetter, ModEntityTypes.BOSS_CLAY_SOLDIER_ENTITY.get()).subPredicate((EntitySubPredicate)BossClaySoldierSubPredicate.of(ModBossBehaviours.DEFAULT.get())))).addCriterion("zombie", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((HolderGetter)entityTypeHolderGetter, ModEntityTypes.BOSS_CLAY_SOLDIER_ENTITY.get()).subPredicate((EntitySubPredicate)BossClaySoldierSubPredicate.of(ModBossBehaviours.ZOMBIE.get())))).addCriterion("staff", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ModItems.CLAY_STAFF.get()})).requirements(new AdvancementRequirements(List.of(List.of("staff"), List.of("normal", "zombie")))).save(saver, ModAdvancements.getSaveLocation("boss_staff"));
        AdvancementHolder clayPouch = new Advancement.Builder().display(ModItems.CLAY_POUCH.get().getDefaultInstance(), (Component)Component.translatable((String)POUCH_TITLE), (Component)Component.translatable((String)POUCH_DESCRIPTION), null, AdvancementType.CHALLENGE, true, false, true).parent(spawnClayBoss).rewards(AdvancementRewards.Builder.experience((int)10)).addCriterion("pouch", MultiSpawnItemUseTrigger.of().setMinMaxBounds(MinMaxBounds.Ints.atLeast((int)65)).build()).save(saver, ModAdvancements.getSaveLocation("boss_pouch"));
        AdvancementHolder staffEnchant = new Advancement.Builder().display(ModItems.CLAY_SOLDIER.get().getDefaultInstance(), (Component)Component.translatable((String)BOOK_TITLE), (Component)Component.translatable((String)BOOK_DESCRIPTION), null, AdvancementType.CHALLENGE, false, false, true).parent(clayStaff).rewards(AdvancementRewards.Builder.experience((int)10)).addCriterion("hit", HitWithClayBlockTrigger.of().needsToBeSoldier().setTarget(EntityPredicate.Builder.entity().of((HolderGetter)entityTypeHolderGetter, ModTags.EntityTypes.CLAY_SOLDIER).build()).setWeapon(ItemPredicate.Builder.item().of((HolderGetter)itemRegistry, new ItemLike[]{ModItems.CLAY_STAFF.get()})).build()).save(saver, ModAdvancements.getSaveLocation("boss_book"));
        Advancement.Builder horseBuilder = new Advancement.Builder().display(new ItemStack((ItemLike)ModItems.GRASS_HORSE.get()), (Component)Component.translatable((String)HORSE_TITLE), (Component)Component.translatable((String)HORSE_DESCRIPTION), null, AdvancementType.TASK, true, false, false).parent(soldier).rewards(AdvancementRewards.Builder.experience((int)100)).requirements(AdvancementRequirements.Strategy.OR);
        for (ClayHorseVariants variant : ClayHorseVariants.values()) {
            horseBuilder.addCriterion(variant.getVariantName(), RecipeCraftedTrigger.TriggerInstance.craftedItem(ModRecipeProvider.getClayHorseKey(variant)));
        }
        AdvancementHolder horse = horseBuilder.save(saver, ModAdvancements.getSaveLocation("horse"));
        Advancement.Builder pegasusBuilder = new Advancement.Builder().display(new ItemStack((ItemLike)ModItems.GRASS_PEGASUS.get()), (Component)Component.translatable((String)PEGASUS_TITLE), (Component)Component.translatable((String)PEGASUS_DESCRIPTION), null, AdvancementType.TASK, true, false, false).parent(horse).rewards(AdvancementRewards.Builder.experience((int)100)).requirements(AdvancementRequirements.Strategy.OR);
        for (ClayHorseVariants variant : ClayHorseVariants.values()) {
            pegasusBuilder.addCriterion(variant.getVariantName(), RecipeCraftedTrigger.TriggerInstance.craftedItem(ModRecipeProvider.getClayPegasusKey(variant, false)));
            pegasusBuilder.addCriterion(variant.getVariantName() + "_feather", RecipeCraftedTrigger.TriggerInstance.craftedItem(ModRecipeProvider.getClayPegasusKey(variant, true)));
        }
        AdvancementHolder pegasus = pegasusBuilder.save(saver, ModAdvancements.getSaveLocation("pegasus"));
        AdvancementHolder soldierOnHead = new Advancement.Builder().display(ModItems.CLAY_SOLDIER.get().getDefaultInstance(), (Component)Component.translatable((String)SOLDIER_ON_HEAD_TITLE), (Component)Component.translatable((String)SOLDIER_ON_HEAD_DESCRIPTION), null, AdvancementType.GOAL, false, false, true).parent(loyalty).rewards(AdvancementRewards.Builder.experience((int)10)).addCriterion("equip", ClaySoldierOnHeadTrigger.create()).save(saver, ModAdvancements.getSaveLocation("clay_soldier_on_head"));
    }

    public static void generateForBlueprint(HolderLookup.Provider provider, Consumer<AdvancementHolder> saver) {
        ItemStack blueprintStack = ModItems.BLUEPRINT.get().getDefaultInstance();
        blueprintStack.set(ModDataComponents.BLUEPRINT_ITEM_DATA, (Object)new BlueprintItem.BlueprintItemData(0.1f));
        AdvancementHolder page = new Advancement.Builder().display(ModItems.BLUEPRINT_PAGE.get().getDefaultInstance(), (Component)Component.translatable((String)BLUEPRINT_PAGE_TITLE), (Component)Component.translatable((String)BLUEPRINT_PAGE_DESCRIPTION), null, AdvancementType.TASK, true, false, false).parent(Advancement.Builder.advancement().build(LOYALTY_ID)).rewards(AdvancementRewards.Builder.experience((int)10)).addCriterion("page", RecipeCraftedTrigger.TriggerInstance.craftedItem(ModRecipeProvider.BLUEPRINT_PAGE)).save(saver, ModAdvancements.getSaveLocation("blueprint_page"));
        AdvancementHolder blueprint = new Advancement.Builder().display(blueprintStack, (Component)Component.translatable((String)BLUEPRINT_TITLE), (Component)Component.translatable((String)BLUEPRINT_DESCRIPTION), null, AdvancementType.TASK, true, false, false).parent(page).rewards(AdvancementRewards.Builder.experience((int)10)).addCriterion("page", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BLUEPRINT.get()})).save(saver, ModAdvancements.getSaveLocation("blueprint"));
        AdvancementHolder house = new Advancement.Builder().display((ItemLike)Items.OAK_DOOR, (Component)Component.translatable((String)HOUSE_TITLE), (Component)Component.translatable((String)HOUSE_DESCRIPTION), null, AdvancementType.GOAL, true, false, false).parent(blueprint).rewards(AdvancementRewards.Builder.experience((int)150)).addCriterion("house", BlueprintPlaceBlockTrigger.of().build()).save(saver, ModAdvancements.getSaveLocation("house"));
    }

    private static ResourceLocation getSaveLocation(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"%s/%s".formatted("clay_soldiers", name));
    }
}

