/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datagen.api;

import net.bumblebee.claysoldiers.blueprint.BlueprintData;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public abstract class BootstrapHelper<T> {
    private final BootstrapContext<T> context;
    private final ResourceKey<Registry<T>> registry;
    private final String modId;

    protected BootstrapHelper(BootstrapContext<T> context, ResourceKey<Registry<T>> registry, String modId) {
        this.context = context;
        this.registry = registry;
        this.modId = modId;
        this.gather();
    }

    protected void register(ResourceKey<T> key, T value) {
        this.context.register(key, value);
    }

    protected void register(String key, T value) {
        this.register(this.createKey(key), value);
    }

    protected abstract void gather();

    protected ResourceKey<T> createKey(String name) {
        return ResourceKey.create(this.registry, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name));
    }

    public static abstract class ClayTeam
    extends BootstrapHelper<ClayMobTeam> {
        public ClayTeam(BootstrapContext<ClayMobTeam> context, String modId) {
            super(context, ModRegistries.CLAY_MOB_TEAMS, modId);
        }

        protected void register(String id, String displayName, int color, Item getFrom) {
            this.register(id, ClayMobTeam.of(displayName, ColorHelper.color(color)).setGetFrom(getFrom).build());
        }
    }

    public static abstract class Blueprint
    extends BootstrapHelper<BlueprintData> {
        public Blueprint(BootstrapContext<BlueprintData> context, String modId) {
            super(context, ModRegistries.BLUEPRINTS, modId);
        }

        protected void register(String key, ResourceLocation structureLocation, String name, float marking) {
            this.register(key, new BlueprintData(structureLocation, name, marking));
        }
    }
}

