/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datagen.tags;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.init.ModDamageTypes;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.init.ModPoiTypes;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.data.tags.EnchantmentTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.PoiTypeTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public final class ModTagProvider {
    public static List<GatherDataEvent.DataProviderFromOutputLookup<TagsProvider<?>>> getTagProviders() {
        return List.of(DamageTypeTagProvider::new, EntityTypeTagProvider::new, EnchantmentTagProvider::new, SoldierPropertyTypeTagProvider::new, PoiTypeTagProvider::new);
    }

    public static class ForcedTagEntry
    extends TagEntry {
        private final TagEntry delegate;

        public static TagEntry element(ResourceKey<?> key) {
            return new ForcedTagEntry(ForcedTagEntry.element((ResourceLocation)key.location()), false);
        }

        public static TagEntry tag(TagKey<?> tag) {
            return new ForcedTagEntry(ForcedTagEntry.tag((ResourceLocation)tag.location()), true);
        }

        public ForcedTagEntry(TagEntry delegate, boolean tag) {
            super(delegate.id, tag, delegate.required);
            this.delegate = delegate;
        }

        public <T> boolean build(TagEntry.Lookup<T> arg, Consumer<T> consumer) {
            return this.delegate.build(arg, consumer);
        }

        public boolean verifyIfPresent(Predicate<ResourceLocation> objectExistsTest, Predicate<ResourceLocation> tagExistsTest) {
            return true;
        }
    }

    private static class PoiTypeTagProvider
    extends PoiTypeTagsProvider {
        public PoiTypeTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
            super(output, provider, "csr");
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(ModTags.PoiTypes.SOLDIER_CONTAINER).add(ModPoiTypes.HAMSTER_WHEEL_POI_KEY);
        }
    }

    private static class SoldierPropertyTypeTagProvider
    extends IntrinsicHolderTagsProvider<SoldierPropertyType<?>> {
        public SoldierPropertyTypeTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, ModRegistries.SOLDIER_PROPERTY_TYPES, lookupProvider, SoldierPropertyTypeTagProvider::keyExtractor, "csr");
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(ModTags.SoldierPropertyTypes.REQUIRES_OWNER).add((Object[])new SoldierPropertyType[]{SoldierPropertyTypes.TELEPORT_TO_OWNER.get(), SoldierPropertyTypes.BREAKING_POWER.get()});
        }

        private static ResourceKey<SoldierPropertyType<?>> keyExtractor(SoldierPropertyType<?> type) {
            ResourceLocation res = ModRegistries.SOLDIER_PROPERTY_TYPES_REGISTRY.getKey(type);
            if (res == null) {
                ClaySoldiersCommon.LOGGER.error("Cannot create Tag with an Unregistered Property");
                throw new IllegalArgumentException("Cannot create Tag with an Unregistered Property");
            }
            return ResourceKey.create(ModRegistries.SOLDIER_PROPERTY_TYPES, (ResourceLocation)res);
        }
    }

    private static class EnchantmentTagProvider
    extends EnchantmentTagsProvider {
        public EnchantmentTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider, "csr");
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(ModTags.Enchantments.SOLDIER_SLINGSHOT_EXCLUSIVE).add(Enchantments.PIERCING);
        }
    }

    private static class EntityTypeTagProvider
    extends EntityTypeTagsProvider {
        public EntityTypeTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture) {
            super(packOutput, completableFuture, "csr");
        }

        protected void addTags(HolderLookup.Provider pProvider) {
            this.tag(EntityTypeTags.UNDEAD).add((Object[])new EntityType[]{ModEntityTypes.ZOMBIE_CLAY_SOLDIER_ENTITY.get(), ModEntityTypes.VAMPIRE_CLAY_SOLDIER_ENTITY.get()});
            this.tag(ModTags.EntityTypes.CLAY_BOSS).add(ModEntityTypes.BOSS_CLAY_SOLDIER_ENTITY.get());
            this.tag(ModTags.EntityTypes.CLAY_SOLDIER).add(ModEntityTypes.CLAY_SOLDIER_ENTITY.get()).add(ModEntityTypes.VAMPIRE_CLAY_SOLDIER_ENTITY.get()).add(ModEntityTypes.ZOMBIE_CLAY_SOLDIER_ENTITY.get());
        }
    }

    private static class DamageTypeTagProvider
    extends DamageTypeTagsProvider {
        public DamageTypeTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture) {
            super(packOutput, completableFuture, "csr");
        }

        protected void addTags(HolderLookup.Provider pProvider) {
            this.tag(ModTags.DamageTypes.CLAY_SOLDIER_DAMAGE).add(ForcedTagEntry.element(ModDamageTypes.CLAY_HURT)).add(ForcedTagEntry.element(ModDamageTypes.CLAY_ON_FIRE)).add(new ResourceKey[]{DamageTypes.THROWN, DamageTypes.THORNS}).addTag(DamageTypeTags.IS_EXPLOSION).addOptional(NeoForgeMod.POISON_DAMAGE.location());
        }
    }
}

