/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap.armor;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.bumblebee.claysoldiers.datamap.armor.SoldierWearableEffect;
import net.bumblebee.claysoldiers.util.ErrorHandler;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import org.jetbrains.annotations.Nullable;

public class ClientSoldierWearableEffect
extends SoldierWearableEffect {
    private Equippable equippable;
    private boolean createdEquippable = false;
    private final boolean shouldRenderArmor;
    private List<TrimHolder> finishedArmorTrims;

    public ClientSoldierWearableEffect(@Nullable ArmorItem item, ColorHelper color, Set<SoldierWearableEffect.SoldierArmorTrim> trims, boolean offsetColor) {
        super(item, color, trims, offsetColor);
        this.shouldRenderArmor = item != null;
    }

    public static SoldierWearableEffect create(ArmorItem item, ColorHelper color, Set<SoldierWearableEffect.SoldierArmorTrim> trims, boolean offsetColor) {
        return new ClientSoldierWearableEffect(item, color, trims, offsetColor);
    }

    public boolean shouldRenderArmor() {
        return this.shouldRenderArmor;
    }

    @Nullable
    public Equippable getEquippable() {
        if (this.createdEquippable || this.equippable != null) {
            return this.equippable;
        }
        ArmorItem copyModel = this.copyModel();
        this.createdEquippable = true;
        if (copyModel == null) {
            return null;
        }
        this.equippable = (Equippable)copyModel.getDefaultInstance().get(DataComponents.EQUIPPABLE);
        return this.equippable;
    }

    @Override
    public void buildTrims(HolderLookup.Provider access) {
        if (this.finishedArmorTrims != null) {
            return;
        }
        this.finishedArmorTrims = new ArrayList<TrimHolder>(this.trims.size());
        for (SoldierWearableEffect.SoldierArmorTrim trim : this.trims) {
            ArmorTrim armorTrim = trim.createTrim(access);
            if (armorTrim != null) {
                this.finishedArmorTrims.add(new TrimHolder(armorTrim, trim.getColor()));
                continue;
            }
            ErrorHandler.INSTANCE.error("Failed to create an ArmorTrim for " + String.valueOf(trim));
        }
    }

    public Iterable<TrimHolder> getArmorTrims() {
        return this.finishedArmorTrims == null ? List.of() : this.finishedArmorTrims;
    }

    @Override
    public String toString() {
        return "%s{%s, %s}".formatted(this.getClass().getSimpleName(), this.copyModel(), "Finished Trims(" + this.finishedArmorTrims.size() + ")");
    }

    public record TrimHolder(ArmorTrim trim, ColorHelper color) {
    }
}

