/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap.armor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.datamap.armor.ClientSoldierWearableEffect;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class SoldierWearableEffect {
    public static final Codec<SoldierWearableEffect> CODEC = RecordCodecBuilder.create(in -> in.group((App)ArmorModel.CODEC.optionalFieldOf("model", (Object)ArmorModel.EMPTY).forGetter(s -> s.armorModel), (App)CodecUtils.singularOrPluralCodecOptional(SoldierArmorTrim.CODEC, "trim").forGetter(SoldierWearableEffect::trims), (App)ColorHelper.CODEC.optionalFieldOf("color", (Object)ColorHelper.EMPTY).forGetter(SoldierWearableEffect::getColorHelper), (App)Codec.BOOL.optionalFieldOf("offset_color", (Object)false).forGetter(s -> s.offsetColor)).apply((Applicative)in, SoldierWearableEffect::createSided));
    public static final StreamCodec<RegistryFriendlyByteBuf, SoldierWearableEffect> STREAM_CODEC = StreamCodec.composite(ArmorModel.STREAM_CODEC, s -> s.armorModel, (StreamCodec)SoldierArmorTrim.STREAM_CODEC.apply(ByteBufCodecs.collection(HashSet::new)), SoldierWearableEffect::trims, ColorHelper.STREAM_CODEC, SoldierWearableEffect::getColorHelper, (StreamCodec)ByteBufCodecs.BOOL, SoldierWearableEffect::isAffectedByOffsetColor, SoldierWearableEffect::createSided);
    private final ColorHelper color;
    private final ArmorModel armorModel;
    protected final Set<SoldierArmorTrim> trims;
    private final boolean offsetColor;

    private SoldierWearableEffect(ArmorModel model, ColorHelper color, Set<SoldierArmorTrim> trims, boolean offsetColor) {
        this.color = color;
        this.armorModel = model;
        this.trims = trims;
        this.offsetColor = offsetColor;
    }

    @ApiStatus.Internal
    public SoldierWearableEffect(@Nullable ArmorItem item, ColorHelper color, Set<SoldierArmorTrim> trims, boolean offsetColor) {
        this(item == null ? ArmorModel.EMPTY : new ArmorModel(item), color, trims, offsetColor);
    }

    public ColorHelper getColorHelper() {
        return this.color;
    }

    @Nullable
    protected ArmorItem copyModel() {
        return this.armorModel.item;
    }

    private Set<SoldierArmorTrim> trims() {
        return this.trims;
    }

    public boolean isAffectedByOffsetColor() {
        return this.offsetColor;
    }

    private static SoldierWearableEffect createSided(ArmorModel model, Set<SoldierArmorTrim> trims, ColorHelper color, boolean colorOffset) {
        if (ClaySoldiersCommon.PLATFORM.isClient()) {
            return ClientSoldierWearableEffect.create(model.item, color, trims, colorOffset);
        }
        return new SoldierWearableEffect(model, color, trims, colorOffset);
    }

    public void buildTrims(HolderLookup.Provider registryAccess) {
    }

    public String toString() {
        return "%s{%s, %s}".formatted(this.getClass().getSimpleName(), this.armorModel, !this.trims.isEmpty() ? "Trims(" + this.trims.size() + ")" : "No Trims");
    }

    private record ArmorModel(ArmorItem item, boolean empty) {
        private static final ArmorModel EMPTY = new ArmorModel(null, true);
        private static final Codec<ArmorModel> CODEC = Codec.either((Codec)BuiltInRegistries.ITEM.byNameCodec(), (Codec)Codec.BOOL).xmap(ArmorModel::fromEither, a -> a.empty ? Either.right((Object)true) : Either.left((Object)a.item));
        private static final StreamCodec<RegistryFriendlyByteBuf, ArmorModel> STREAM_CODEC = ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM)).map(s -> s.map(i -> {
            ArmorModel armorModel;
            if (i instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)i;
                armorModel = new ArmorModel(armorItem);
            } else {
                armorModel = EMPTY;
            }
            return armorModel;
        }).orElse(EMPTY), a -> a.empty ? Optional.empty() : Optional.of(a.item));

        private ArmorModel(ArmorItem item) {
            this(Objects.requireNonNull(item), false);
        }

        @Override
        public String toString() {
            return "ArmorModel[%s]".formatted(this.empty ? "Empty" : this.item);
        }

        private static ArmorModel fromEither(Either<Item, Boolean> either) {
            ArmorModel armorModel;
            if (either.right().isPresent()) {
                return EMPTY;
            }
            Object t = either.left().orElseThrow();
            if (t instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)t;
                armorModel = new ArmorModel(armorItem);
            } else {
                armorModel = EMPTY;
            }
            return armorModel;
        }
    }

    public static class SoldierArmorTrim {
        private static final Codec<SoldierArmorTrim> CODEC = RecordCodecBuilder.create(in -> in.group((App)ResourceLocation.CODEC.fieldOf("pattern").forGetter(t -> t.pattern.location()), (App)ResourceLocation.CODEC.fieldOf("material").forGetter(t -> t.material.location()), (App)ColorHelper.CODEC.optionalFieldOf("color", (Object)ColorHelper.EMPTY).forGetter(t -> t.color)).apply((Applicative)in, SoldierArmorTrim::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, SoldierArmorTrim> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, s -> s.pattern.location(), (StreamCodec)ResourceLocation.STREAM_CODEC, s -> s.material.location(), ColorHelper.STREAM_CODEC, s -> s.color, SoldierArmorTrim::new);
        private final ResourceKey<TrimPattern> pattern;
        private final ResourceKey<TrimMaterial> material;
        private final ColorHelper color;

        private SoldierArmorTrim(ResourceLocation pattern, ResourceLocation material, ColorHelper color) {
            this((ResourceKey<TrimPattern>)ResourceKey.create((ResourceKey)Registries.TRIM_PATTERN, (ResourceLocation)pattern), (ResourceKey<TrimMaterial>)ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)material), color);
        }

        public SoldierArmorTrim(ResourceKey<TrimPattern> pattern, ResourceKey<TrimMaterial> material, ColorHelper color) {
            this.pattern = pattern;
            this.material = material;
            this.color = color;
        }

        @Nullable
        public ArmorTrim createTrim(HolderLookup.Provider access) {
            Optional trimPattern = access.lookupOrThrow(Registries.TRIM_PATTERN).get(this.pattern);
            Optional trimMaterial = access.lookupOrThrow(Registries.TRIM_MATERIAL).get(this.material);
            if (trimPattern.isPresent() && trimMaterial.isPresent()) {
                return new ArmorTrim((Holder)trimMaterial.orElseThrow(), (Holder)trimPattern.orElseThrow());
            }
            return null;
        }

        public ColorHelper getColor() {
            return this.color;
        }
    }
}

