/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap.armor.accessories.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.bumblebee.claysoldiers.datamap.armor.accessories.AccessoryRenderState;
import net.bumblebee.claysoldiers.datamap.armor.accessories.IAccessoryRenderLayer;
import net.bumblebee.claysoldiers.datamap.armor.accessories.RenderableAccessory;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;

public class CapeRenderable
implements RenderableAccessory {
    public static final Codec<CapeRenderable> CODEC = RecordCodecBuilder.create(in -> in.group((App)ResourceLocation.CODEC.fieldOf("texture_location").forGetter(c -> c.textureLocation), (App)ColorHelper.CODEC.optionalFieldOf("color", (Object)ColorHelper.EMPTY).forGetter(c -> c.color), (App)Codec.BOOL.optionalFieldOf("affectedByOffsetColor", (Object)true).forGetter(c -> c.affectedByOffsetColor)).apply((Applicative)in, CapeRenderable::new));
    public static final StreamCodec<ByteBuf, CapeRenderable> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, c -> c.textureLocation, ColorHelper.STREAM_CODEC, c -> c.color, (StreamCodec)ByteBufCodecs.BOOL, c -> c.affectedByOffsetColor, CapeRenderable::new);
    private final ResourceLocation textureLocation;
    private final ColorHelper color;
    private final boolean affectedByOffsetColor;

    public CapeRenderable(ResourceLocation textureLocation) {
        this(textureLocation, ColorHelper.EMPTY, true);
    }

    public CapeRenderable(ResourceLocation textureLocation, ColorHelper color, boolean affectedByOffsetColor) {
        this.textureLocation = textureLocation;
        this.color = color;
        this.affectedByOffsetColor = affectedByOffsetColor;
    }

    @Override
    public void render(IAccessoryRenderLayer renderedFrom, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, AccessoryRenderState claySoldier) {
        if (!claySoldier.isInvisible && this.textureLocation != null && !this.hasLayer(claySoldier.chestEquipment, EquipmentClientInfo.LayerType.WINGS, renderedFrom)) {
            pPoseStack.pushPose();
            if (this.hasLayer(claySoldier.chestEquipment, EquipmentClientInfo.LayerType.HUMANOID, renderedFrom)) {
                pPoseStack.translate(0.0f, -0.053125f, 0.06875f);
            }
            VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.entitySolid((ResourceLocation)this.textureLocation));
            renderedFrom.getCapeModel().renderToBuffer(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, this.getCapeColor(claySoldier));
            pPoseStack.popPose();
        }
    }

    private boolean hasLayer(ItemStack stack, EquipmentClientInfo.LayerType layer, IAccessoryRenderLayer renderer) {
        Equippable equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE);
        if (equippable != null && equippable.assetId().isPresent()) {
            EquipmentClientInfo equipmentclientinfo = renderer.getEquipmentAssets().get((ResourceKey)equippable.assetId().get());
            return !equipmentclientinfo.getLayers(layer).isEmpty();
        }
        return false;
    }

    private boolean affectByOffsetColor() {
        return this.affectedByOffsetColor;
    }

    public int getCapeColor(AccessoryRenderState soldier) {
        if (this.affectByOffsetColor()) {
            return soldier.offsetColor;
        }
        return this.color.getColor(soldier.id, soldier.ageInTicks);
    }
}

