/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap.armor.accessories.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import net.bumblebee.claysoldiers.datamap.armor.accessories.AccessoryRenderState;
import net.bumblebee.claysoldiers.datamap.armor.accessories.IAccessoryRenderLayer;
import net.bumblebee.claysoldiers.datamap.armor.accessories.RenderableAccessory;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class GliderRenderable
implements RenderableAccessory {
    public static final Codec<GliderRenderable> CODEC = BuiltInRegistries.ITEM.byNameCodec().xmap(GliderRenderable::new, g -> g.glider);
    public static final StreamCodec<RegistryFriendlyByteBuf, GliderRenderable> STREAM_CODEC = ByteBufCodecs.registry((ResourceKey)Registries.ITEM).map(GliderRenderable::new, g -> g.glider);
    private final Item glider;
    private final ItemStack gliderStack;

    public GliderRenderable(Item glider) {
        this.glider = glider;
        this.gliderStack = glider.getDefaultInstance();
    }

    @Override
    public void render(IAccessoryRenderLayer renderedFrom, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, AccessoryRenderState claySoldier) {
        if (claySoldier.isFalling) {
            pPoseStack.pushPose();
            pPoseStack.translate(-1.2, 0.12, 0.0);
            pPoseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            pPoseStack.scale(1.5f, 1.5f, 1.5f);
            claySoldier.gliderAccessory.render(pPoseStack, pBuffer, pPackedLight, OverlayTexture.NO_OVERLAY);
            pPoseStack.popPose();
        }
    }

    public ItemStack getGliderStack() {
        return this.gliderStack;
    }
}

