/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap.horse;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import org.jetbrains.annotations.Nullable;

public final class ClayHorseWearableProperties {
    public static final Codec<ClayHorseWearableProperties> CODEC = RecordCodecBuilder.create(in -> in.group((App)Codec.FLOAT.optionalFieldOf("protection", (Object)Float.valueOf(0.0f)).forGetter(ClayHorseWearableProperties::protection), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("armor_item").forGetter(ClayHorseWearableProperties::armorItem), (App)ColorHelper.CODEC.optionalFieldOf("color", (Object)ColorHelper.EMPTY).forGetter(ClayHorseWearableProperties::color)).apply((Applicative)in, ClayHorseWearableProperties::new));
    private final float protection;
    private final Item armorItem;
    private final ColorHelper color;
    @Nullable
    private Equippable equippable;
    private final ItemStack stack;

    public ClayHorseWearableProperties(float protection, Item armorItem, ColorHelper color) {
        this.protection = protection;
        this.armorItem = armorItem;
        this.color = color;
        this.stack = armorItem.getDefaultInstance();
    }

    public float protection() {
        return this.protection;
    }

    public Item armorItem() {
        return this.armorItem;
    }

    public ColorHelper color() {
        return this.color;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Nullable
    public Equippable getEquippable() {
        if (this.equippable == null) {
            this.equippable = (Equippable)this.armorItem.getDefaultInstance().get(DataComponents.EQUIPPABLE);
        }
        return this.equippable;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ClayHorseWearableProperties that = (ClayHorseWearableProperties)obj;
        return Float.floatToIntBits(this.protection) == Float.floatToIntBits(that.protection) && Objects.equals(this.armorItem, that.armorItem) && Objects.equals(this.color, that.color);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.protection), this.armorItem, this.color);
    }

    public String toString() {
        return "ClayHorseWearableProperties[protection=" + this.protection + ", armorItem=" + String.valueOf(this.armorItem) + ", color=" + String.valueOf(this.color) + "]";
    }
}

