/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity;

import java.util.List;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public abstract class ClayMobRideableEntity
extends ClayMobEntity {
    protected ClayMobRideableEntity(EntityType<? extends ClayMobRideableEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof AbstractClaySoldierEntity) {
            return (AbstractClaySoldierEntity)entity;
        }
        return super.getControllingPassenger();
    }

    public float shareDamagePercent() {
        return 0.25f;
    }

    @Override
    public ResourceLocation getClayTeamType() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof ClayMobEntity) {
            ClayMobEntity clayMob = (ClayMobEntity)entity;
            return clayMob.getClayTeamType();
        }
        return ClayMobTeamManger.NO_TEAM_TYPE;
    }

    public int getTeamColor() {
        return this.getFirstPassenger() != null ? this.getFirstPassenger().getTeamColor() : super.getTeamColor();
    }

    @Override
    public boolean isOrderedToSit() {
        ClayMobEntity clayMob;
        Entity entity;
        return super.isOrderedToSit() || (entity = this.getFirstPassenger()) instanceof ClayMobEntity && (clayMob = (ClayMobEntity)entity).isOrderedToSit();
    }

    @Override
    public List<String> getInfoState() {
        List<String> info = super.getInfoState();
        info.add("Rider: " + (this.getFirstPassenger() == null ? "Null" : this.getFirstPassenger().getClass().getSimpleName()));
        return info;
    }
}

