/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.boss;

import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BossBatEntity
extends Bat {
    private NonNullList<ItemStack> inventory = NonNullList.createWithCapacity((int)0);

    public BossBatEntity(EntityType<? extends BossBatEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier createBatAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).build();
    }

    public void setLoot(List<ItemStack> loot) {
        this.inventory = NonNullList.createWithCapacity((int)loot.size());
        this.inventory.addAll(loot);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        ContainerHelper.saveAllItems((CompoundTag)compound, this.inventory, (boolean)false, (HolderLookup.Provider)this.registryAccess());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Items")) {
            this.inventory = NonNullList.create();
            ContainerHelper.loadAllItems((CompoundTag)compound, this.inventory, (HolderLookup.Provider)this.registryAccess());
        }
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean recentlyHit) {
        super.dropCustomDeathLoot(level, damageSource, recentlyHit);
        this.inventory.forEach(stack -> this.spawnAtLocation(level, (ItemStack)stack));
    }
}

