/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.boss;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Consumer;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierBehaviour;
import net.bumblebee.claysoldiers.entity.boss.ClayBlockProjectileEntity;
import net.bumblebee.claysoldiers.entity.goal.ClaySodlierBreathAirGoal;
import net.bumblebee.claysoldiers.entity.goal.ClaySoldierMeleeAttackGoal;
import net.bumblebee.claysoldiers.entity.goal.target.ClaySoldierNearestTargetGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.WorkSelectorGoal;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.status.SoldierStatusHolder;
import net.bumblebee.claysoldiers.init.ModBossBehaviours;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.networking.spawnpayloads.ClayBossSpawnPayload;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMap;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMapReader;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.combined.SoldierPropertyCombinedMap;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BossClaySoldierEntity
extends AbstractClaySoldierEntity {
    private static final EntityDataAccessor<Byte> BOSS_TYPE = SynchedEntityData.defineId(BossClaySoldierEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final Logger LOGGER = ClaySoldiersCommon.LOGGER;
    private static final String BASE_PROPERTIES_TAG = "baseProperties";
    private static final String TYPE_TAG = "bossType";
    private static final String BOSS_AI_TAG = "bossAI";
    private static final String MINION_OWNER_TAG = "minionOwner";
    private static final String MINIONS_TAG = "minions";
    private static final String PHASE_COMPLETED_TAG = "phaseCompleted";
    private static final SoldierStatusHolder EMPTY = () -> null;
    private final ServerBossEvent bossEvent;
    private final SoldierPropertyCombinedMap baseProperties;
    @Nullable
    private BossClaySoldierBehaviour bossAI;
    @Nullable
    private BossClaySoldierEntity minionOwner;
    @Nullable
    private UUID minionOwnerUUID;
    @Nullable
    private List<BossClaySoldierEntity> minions;
    @Nullable
    private List<UUID> minionUUIDs;
    private int phaseCompleted = 0;
    private int nextMinionGlow = 0;

    public BossClaySoldierEntity(EntityType<? extends BossClaySoldierEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel, AttackTypeProperty.BOSS, s -> EMPTY);
        this.otherPlayerDamage = (w, e) -> w ? 0.9f : 1.0f;
        this.defaultDamage = (w, e) -> w ? 0.9f : 1.0f;
        this.clayDamage = (w, e) -> w ? 0.25f : 0.5f;
        this.bossEvent = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
        this.baseProperties = new SoldierPropertyCombinedMap();
    }

    public void setBossAI(@NotNull BossClaySoldierBehaviour bossAI) {
        if (this.bossAI != null || bossAI == null) {
            throw new IllegalStateException("Cannot set Boss Ai twice");
        }
        this.bossAI = bossAI;
        this.bossAI.setUpBoss(this, this.bossEvent);
    }

    @NotNull
    public BossClaySoldierBehaviour getBossAI() {
        return Objects.requireNonNull(this.bossAI, "Boss AI not initialized");
    }

    public static AttributeSupplier bossAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.ARMOR, 5.0).add(Attributes.ATTACK_DAMAGE, 2.5).add(Attributes.ATTACK_SPEED, 0.1).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.6).add(Attributes.TEMPT_RANGE).build();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        if (!this.baseProperties.isEmpty()) {
            BossClaySoldierEntity.writeBasePropertiesToTag(this.baseProperties, pCompound);
        }
        BossTypes.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getBossType()).ifSuccess(tag -> pCompound.put(TYPE_TAG, tag)).ifError(err -> LOGGER.error("Error saving Boss Type: {}", (Object)err.message()));
        BossClaySoldierEntity.writeBossAIToTag(this.getBossAI(), pCompound);
        if (this.minionOwner != null) {
            pCompound.putUUID(MINION_OWNER_TAG, this.minionOwner.getUUID());
        }
        if (this.minions != null) {
            ListTag listTag = new ListTag();
            this.minions.forEach(minion -> listTag.add((Object)NbtUtils.createUUID((UUID)minion.getUUID())));
            pCompound.put(MINIONS_TAG, (Tag)listTag);
        }
        if (this.phaseCompleted > 0) {
            pCompound.putInt(PHASE_COMPLETED_TAG, this.phaseCompleted);
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.readAndSetBasePropertiesFromTag(pCompound);
        if (this.readAndSetBossAI(pCompound) && pCompound.contains(TYPE_TAG)) {
            BossTypes.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pCompound.get(TYPE_TAG)).ifSuccess(this::setBossType).ifError(err -> LOGGER.error("Error parsing Boss Type: {}", (Object)err.message()));
        }
        if (this.hasCustomName()) {
            this.bossEvent.setName(this.getDisplayName());
        }
        if (pCompound.contains(MINION_OWNER_TAG)) {
            this.minionOwnerUUID = pCompound.getUUID(MINION_OWNER_TAG);
        }
        if (pCompound.contains(MINIONS_TAG, 9)) {
            ListTag listTag = pCompound.getList(MINIONS_TAG, 11);
            this.minionUUIDs = new ArrayList<UUID>(listTag.size());
            for (Tag tag : listTag) {
                this.minionUUIDs.add(NbtUtils.loadUUID((Tag)tag));
            }
        }
        if (pCompound.contains(PHASE_COMPLETED_TAG)) {
            this.phaseCompleted = pCompound.getInt(PHASE_COMPLETED_TAG);
        }
    }

    @Override
    public void readItemPersistentData(CompoundTag tag) {
        if (!this.readAndSetBossAI(tag)) {
            this.setBossAI(ModBossBehaviours.DEFAULT.get());
        }
        this.readAndSetBasePropertiesFromTag(tag);
    }

    private boolean readAndSetBossAI(CompoundTag pCompound) {
        if (pCompound.contains(BOSS_AI_TAG)) {
            return BossClaySoldierBehaviour.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pCompound.get(BOSS_AI_TAG)).ifSuccess(this::setBossAI).ifError(err -> LOGGER.error("Error parsing Boss AI: {}", (Object)err.message())).isSuccess();
        }
        return false;
    }

    public static void writeBossAIToTag(BossClaySoldierBehaviour ai, CompoundTag pCompound) {
        BossClaySoldierBehaviour.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)ai).ifSuccess(tag -> pCompound.put(BOSS_AI_TAG, tag)).ifError(err -> LOGGER.error("Error saving Boss AI: {}", (Object)err.message()));
    }

    public static void writeBasePropertiesToTag(SoldierPropertyMap properties, CompoundTag compound) {
        SoldierPropertyMap.CODEC_FOR_NON_ITEM.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)properties).ifSuccess(tag -> compound.put(BASE_PROPERTIES_TAG, tag)).ifError(err -> LOGGER.error("Error saving Base Properties: {}", (Object)err.message()));
    }

    private void readAndSetBasePropertiesFromTag(CompoundTag compound) {
        if (compound.contains(BASE_PROPERTIES_TAG)) {
            SoldierPropertyMap.CODEC_FOR_NON_ITEM.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get(BASE_PROPERTIES_TAG)).ifSuccess(this::setBaseProperties).ifError(err -> LOGGER.error("Error parsing Base Properties: {}", (Object)err.message()));
        }
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new ClaySodlierBreathAirGoal(this));
        this.goalSelector.addGoal(0, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 20.0f));
        this.goalSelector.addGoal(1, (Goal)new ClaySoldierMeleeAttackGoal(this, 1.0, false));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{this.getClass()}));
        this.targetSelector.addGoal(1, (Goal)new ClaySoldierNearestTargetGoal(this, true, (x$0, x$1) -> this.targetPredicate(x$0, x$1), this::specificTargetPredicate));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BOSS_TYPE, (Object)((byte)BossTypes.NORMAL.ordinal()));
    }

    @Override
    public boolean hurtServer(ServerLevel level, DamageSource source, float amount) {
        boolean aiAllowHurt = true;
        if (this.bossAI != null) {
            aiAllowHurt = this.bossAI.onHurt(this, source);
        }
        if (!aiAllowHurt) {
            return false;
        }
        return super.hurtServer(level, source, amount);
    }

    @Override
    public boolean hasNoTeam() {
        return true;
    }

    @Override
    protected boolean isClayFood(ItemStack stack) {
        return false;
    }

    @Override
    protected WorkSelectorGoal getOrCreateWorkSelectorGoal() {
        return new WorkSelectorGoal(this, List.of());
    }

    @Override
    @Nullable
    public UUID getClayTeamOwnerUUID() {
        return null;
    }

    @Override
    public void sendSpawnPayload(ServerPlayer tracking) {
        ClaySoldiersCommon.NETWORK_MANGER.sendToPlayer(tracking, new ClayBossSpawnPayload(this));
        super.sendSpawnPayload(tracking);
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bossEvent.setName(this.getDisplayName());
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        if (this.bossAI != null) {
            this.bossAI.getBossEventProgress(this, this.bossEvent);
        }
        if (this.tickCount % 200 == 0) {
            boolean shouldMinionsGlow;
            this.loadMinions();
            boolean bl = shouldMinionsGlow = this.nextMinionGlow < this.tickCount;
            if (shouldMinionsGlow) {
                this.nextMinionGlow += 400;
            }
            if (this.minions != null) {
                Iterator<BossClaySoldierEntity> each = this.minions.iterator();
                while (each.hasNext()) {
                    BossClaySoldierEntity minion = each.next();
                    if (!minion.isAlive() && minion.getMinionOwner() == null) {
                        each.remove();
                        if (this.minionUUIDs == null) continue;
                        this.minionUUIDs.remove(minion.getUUID());
                        continue;
                    }
                    if (!shouldMinionsGlow) continue;
                    minion.addEffect(new MobEffectInstance(MobEffects.GLOWING, 60, 0, false, false, true));
                }
            }
        }
    }

    @Override
    public void startSeenByPlayer(ServerPlayer serverPlayer) {
        super.startSeenByPlayer(serverPlayer);
        this.bossEvent.addPlayer(serverPlayer);
    }

    public void stopSeenByPlayer(ServerPlayer serverPlayer) {
        super.stopSeenByPlayer(serverPlayer);
        this.bossEvent.addPlayer(serverPlayer);
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        this.bossEvent.removeAllPlayers();
    }

    public void setBaseProperties(SoldierPropertyMapReader baseProperties) {
        if (!baseProperties.attackType().compatibleWith(this.getAttackType())) {
            throw new IllegalArgumentException("Cannot set Base Properties of %s as Attack Type %s is not compatible with the Attack Type of the Boss (%s).".formatted(baseProperties, baseProperties.attackType(), this.getAttackType()));
        }
        this.baseProperties.clear();
        this.baseProperties.combineMap(baseProperties);
        this.propertyCombiner.addBaseProperties(baseProperties);
        this.propertyCombiner.combine();
    }

    public SoldierPropertyMap getBaseProperties() {
        return this.baseProperties;
    }

    @Override
    public float getSoldierSize() {
        if (this.allProperties() == null) {
            return 1.0f;
        }
        return Math.max(0.2f, this.allProperties().getSoldierSize());
    }

    @Override
    protected boolean specificTargetPredicate(LivingEntity target, ServerLevel level) {
        return this.targetPredicate(target, level);
    }

    @Override
    protected boolean dropInventoryOnDeath() {
        return false;
    }

    @Override
    public boolean wantsToPickUp(ServerLevel level, ItemStack pStack) {
        return false;
    }

    @Override
    public boolean canHoldItem(ItemStack pStack) {
        return pStack.is(ModTags.Items.SOLDIER_BOSS_EQUIPABLE);
    }

    @Override
    public boolean canRevive() {
        return false;
    }

    @Override
    public boolean canBeKilledByDisruptor(ServerLevel level, ServerPlayer serverPlayer) {
        return false;
    }

    @Override
    protected OptionalInt openMenuScreen(Player player) {
        return OptionalInt.empty();
    }

    @NotNull
    public BossTypes getBossType() {
        return BossTypes.values()[(Byte)this.entityData.get(BOSS_TYPE)];
    }

    public void setBossType(@NotNull BossTypes type) {
        if (this.level().isClientSide() || !this.getBossAI().isAllowed(type)) {
            return;
        }
        this.entityData.set(BOSS_TYPE, (Object)((byte)type.ordinal()));
    }

    @Override
    protected void specializedAttack(Entity target) {
        if (this.isVampire()) {
            this.heal(2.0f);
        }
    }

    @Override
    protected float getAttackPower(Entity target) {
        return target instanceof ClayMobEntity ? 10.0f : 1.0f;
    }

    @Override
    public void performRangedAttack(@NotNull LivingEntity target, float pVelocity) {
        this.performRangedAttack(target.getX(), target.getY() + (double)target.getEyeHeight() * 0.5, target.getZ(), 0.75f);
    }

    private void performRangedAttack(double x, double y, double z, float size) {
        if (!this.isSilent()) {
            this.level().levelEvent(null, 1024, this.blockPosition(), 0);
        }
        double skullX = this.getX();
        double skullY = this.getY();
        double skullZ = this.getZ();
        double dX = x - skullX;
        double dY = y - skullY;
        double dZ = z - skullZ;
        Vec3 velocity = new Vec3(dX, dY, dZ);
        ClayBlockProjectileEntity clayBlock = new ClayBlockProjectileEntity(this.level(), (LivingEntity)this, velocity.normalize());
        clayBlock.setOwner((Entity)this);
        clayBlock.setPosRaw(skullX, skullY, skullZ);
        clayBlock.setBlockSize(size);
        this.level().addFreshEntity((Entity)clayBlock);
    }

    private BossClaySoldierEntity getMinionOwner() {
        if (this.minionOwner != null) {
            return this.minionOwner;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.minionOwnerUUID != null) {
                this.minionOwner = (BossClaySoldierEntity)serverLevel.getEntity(this.minionOwnerUUID);
            }
        }
        return this.minionOwner;
    }

    private void loadMinions() {
        if (this.minions != null || this.minionUUIDs == null) {
            return;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.minions = new ArrayList<BossClaySoldierEntity>(this.minionUUIDs.size());
            Iterator<UUID> uuidIterator = this.minionUUIDs.iterator();
            while (uuidIterator.hasNext()) {
                UUID uuidMinion = uuidIterator.next();
                BossClaySoldierEntity minion = (BossClaySoldierEntity)serverLevel.getEntity(uuidMinion);
                if (minion != null) {
                    this.minions.add(minion);
                    continue;
                }
                uuidIterator.remove();
                LOGGER.error("Minion {} of {} was not found in the world.", (Object)uuidMinion, (Object)this);
            }
        }
    }

    public int getMinionCount() {
        this.loadMinions();
        return this.minions == null ? 0 : this.minions.size();
    }

    public void addAllMinions(List<BossClaySoldierEntity> minionsToAdd) {
        this.loadMinions();
        if (this.minions == null || this.minionUUIDs == null) {
            this.minions = new ArrayList<BossClaySoldierEntity>(minionsToAdd.size());
            this.minionUUIDs = new ArrayList<UUID>(minionsToAdd.size());
        }
        this.minions.addAll(minionsToAdd);
        minionsToAdd.forEach(minion -> this.minionUUIDs.add(minion.getUUID()));
        if (this.minions.size() != this.minionUUIDs.size()) {
            throw new IllegalStateException("Minion UUIDs and Minions do not match");
        }
    }

    public void setMinionOwner(@Nullable BossClaySoldierEntity minionOwner) {
        this.minionOwner = minionOwner;
        this.minionOwnerUUID = minionOwner == null ? null : minionOwner.getUUID();
    }

    public void notifyMinionOwnerOfDeath() {
        if (this.level().isClientSide()) {
            return;
        }
        BossClaySoldierEntity minionOwner = this.getMinionOwner();
        if (minionOwner == null) {
            LOGGER.error("{} tried to notify Minion Owner of death, but owner was null.", (Object)this);
            return;
        }
        minionOwner.removeMinion(this);
    }

    private void removeMinion(BossClaySoldierEntity minion) {
        this.loadMinions();
        if (this.minions == null || this.minionUUIDs == null) {
            LOGGER.error("Minion Owner {} of {} did not have minions.", (Object)this, (Object)minion);
            return;
        }
        this.minionUUIDs.remove(minion.getUUID());
        if (!this.minions.remove(minion)) {
            LOGGER.error("Minion Owner {} of {} did not contain this.", (Object)this, (Object)minion);
        }
        if (this.minions.isEmpty()) {
            this.minions = null;
            this.minionUUIDs = null;
        }
    }

    public int getPhaseCompleted() {
        return this.phaseCompleted;
    }

    public void completePhase() {
        ++this.phaseCompleted;
    }

    @Override
    public void die(DamageSource damageSource) {
        if (!this.getBossAI().shouldDie(this)) {
            return;
        }
        super.die(damageSource);
        this.getBossAI().onDeath(this, damageSource);
    }

    protected boolean isUndead() {
        return this.getBossType() != BossTypes.NORMAL;
    }

    protected boolean isVampire() {
        return this.getBossType() == BossTypes.VAMPIRE;
    }

    @Override
    public boolean isZombie() {
        return this.getBossType() == BossTypes.ZOMBIE;
    }

    protected boolean shouldWalkToTarget(@Nullable Vec3 pos) {
        return pos == null || !this.isUndead() || !this.level().canSeeSky(BlockPos.containing((Position)pos));
    }

    @Override
    public void onConversion(ClayMobEntity oldSoldier, CompoundTag tag, @Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.SUMMONED_ENTITY.trigger(serverPlayer, (Entity)this);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (this.bossAI == null) {
            this.setBossAI(ModBossBehaviours.DEFAULT.get());
        }
        if (!this.baseProperties.isEmpty()) {
            this.setBaseProperties(SoldierPropertyMap.of(SoldierPropertyTypes.SIZE.get().createProperty(Float.valueOf(level.getRandom().nextFloat() * 3.0f + 1.0f))));
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public List<ItemStack> getBossDeathLoot(DamageSource damageSource) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.bossAI != null) {
                ResourceKey<LootTable> lootTableKey = this.bossAI.getLootTable();
                if (lootTableKey == null) {
                    return List.of();
                }
                LootTable lootTable = this.level().getServer().reloadableRegistries().getLootTable(lootTableKey);
                LootParams.Builder paramBuilder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)damageSource.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)damageSource.getDirectEntity());
                if (this.lastHurtByPlayerTime > 0 && this.lastHurtByPlayer != null) {
                    paramBuilder = paramBuilder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)this.lastHurtByPlayer).withLuck(this.lastHurtByPlayer.getLuck());
                }
                return lootTable.getRandomItems(paramBuilder.create(LootContextParamSets.ENTITY), this.getLootTableSeed());
            }
        }
        return List.of();
    }

    @Override
    public List<String> getInfoState() {
        List<String> list = super.getInfoState();
        list.add(String.format("Boss Type: %s", new Object[]{this.getBossType()}));
        list.add(String.format("Boss AI: %s", ModRegistries.BOSS_CLAY_SOLDIER_BEHAVIOURS_REGISTRY.getKey((Object)this.getBossAI())));
        list.add(String.format("Base Properties: %s", this.baseProperties));
        if (!this.level().isClientSide()) {
            this.getMinionOwner();
            this.loadMinions();
            list.add("MinionOwner: " + String.valueOf(this.minionOwner) + (this.minionOwnerUUID == null ? "" : " (uuid)"));
            list.add("Minions: " + String.valueOf(this.minions == null ? "null" : Integer.valueOf(this.minions.size())) + " | " + String.valueOf(this.minionUUIDs == null ? "null" : Integer.valueOf(this.minionUUIDs.size())));
            list.add("Phase Completed: " + this.phaseCompleted);
        }
        return list;
    }

    public static enum BossTypes implements StringRepresentable
    {
        NORMAL("normal", event -> event.setColor(BossEvent.BossBarColor.BLUE)),
        ZOMBIE("zombie", event -> event.setColor(BossEvent.BossBarColor.GREEN)),
        VAMPIRE("vampire", event -> event.setDarkenScreen(true).setColor(BossEvent.BossBarColor.RED));

        public static final Codec<BossTypes> CODEC;
        private final String serializedName;

        private BossTypes(String serializedName, Consumer<BossEvent> modifyBossEvent) {
            this.serializedName = serializedName;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(BossTypes::values);
        }
    }
}

